/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CopyTagsFromSource;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceSpecification;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateSnapshotsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateSnapshotsRequest> {
    private String description;
    private InstanceSpecification instanceSpecification;
    private String outpostArn;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String copyTagsFromSource;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSnapshotsRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setInstanceSpecification(InstanceSpecification instanceSpecification) {
        this.instanceSpecification = instanceSpecification;
    }

    public InstanceSpecification getInstanceSpecification() {
        return this.instanceSpecification;
    }

    public CreateSnapshotsRequest withInstanceSpecification(InstanceSpecification instanceSpecification) {
        this.setInstanceSpecification(instanceSpecification);
        return this;
    }

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    public String getOutpostArn() {
        return this.outpostArn;
    }

    public CreateSnapshotsRequest withOutpostArn(String outpostArn) {
        this.setOutpostArn(outpostArn);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateSnapshotsRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateSnapshotsRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setCopyTagsFromSource(String copyTagsFromSource) {
        this.copyTagsFromSource = copyTagsFromSource;
    }

    public String getCopyTagsFromSource() {
        return this.copyTagsFromSource;
    }

    public CreateSnapshotsRequest withCopyTagsFromSource(String copyTagsFromSource) {
        this.setCopyTagsFromSource(copyTagsFromSource);
        return this;
    }

    public CreateSnapshotsRequest withCopyTagsFromSource(CopyTagsFromSource copyTagsFromSource) {
        this.copyTagsFromSource = copyTagsFromSource.toString();
        return this;
    }

    @Override
    public Request<CreateSnapshotsRequest> getDryRunRequest() {
        Request<CreateSnapshotsRequest> request = new CreateSnapshotsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInstanceSpecification() != null) {
            sb.append("InstanceSpecification: ").append(this.getInstanceSpecification()).append(",");
        }
        if (this.getOutpostArn() != null) {
            sb.append("OutpostArn: ").append(this.getOutpostArn()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getCopyTagsFromSource() != null) {
            sb.append("CopyTagsFromSource: ").append(this.getCopyTagsFromSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotsRequest)) {
            return false;
        }
        CreateSnapshotsRequest other = (CreateSnapshotsRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInstanceSpecification() == null ^ this.getInstanceSpecification() == null) {
            return false;
        }
        if (other.getInstanceSpecification() != null && !other.getInstanceSpecification().equals(this.getInstanceSpecification())) {
            return false;
        }
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null) {
            return false;
        }
        if (other.getOutpostArn() != null && !other.getOutpostArn().equals(this.getOutpostArn())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getCopyTagsFromSource() == null ^ this.getCopyTagsFromSource() == null) {
            return false;
        }
        return other.getCopyTagsFromSource() == null || other.getCopyTagsFromSource().equals(this.getCopyTagsFromSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceSpecification() == null ? 0 : this.getInstanceSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostArn() == null ? 0 : this.getOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsFromSource() == null ? 0 : this.getCopyTagsFromSource().hashCode());
        return hashCode;
    }

    public CreateSnapshotsRequest clone() {
        return (CreateSnapshotsRequest)super.clone();
    }
}

