/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.KafkaLookupExtractorIntrospectionHandler;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;

@JsonTypeName(value="kafka")
public class KafkaLookupExtractorFactory
implements LookupExtractorFactory {
    private static final Logger LOG;
    private final ListeningExecutorService executorService;
    private final AtomicLong doubleEventCount = new AtomicLong(0L);
    private final NamespaceExtractionCacheManager cacheManager;
    private final String factoryId;
    private final AtomicReference<Map<String, String>> mapRef = new AtomicReference<Object>(null);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private CacheHandler cacheHandler;
    private volatile ListenableFuture<?> future = null;
    @JsonProperty
    private final String kafkaTopic;
    @JsonProperty
    private final Map<String, String> kafkaProperties;
    @JsonProperty
    private final long connectTimeout;
    @JsonProperty
    private final boolean injective;

    @JsonCreator
    public KafkaLookupExtractorFactory(@JacksonInject NamespaceExtractionCacheManager cacheManager, @JsonProperty(value="kafkaTopic") String kafkaTopic, @JsonProperty(value="kafkaProperties") Map<String, String> kafkaProperties, @JsonProperty(value="connectTimeout") @Min(value=0L) @Min(value=0L) long connectTimeout, @JsonProperty(value="injective") boolean injective) {
        this.kafkaTopic = (String)Preconditions.checkNotNull((Object)kafkaTopic, (Object)"kafkaTopic required");
        this.kafkaProperties = (Map)Preconditions.checkNotNull(kafkaProperties, (Object)"kafkaProperties required");
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)("kafka-factory-" + StringUtils.encodeForFormat((String)kafkaTopic) + "-%s"), (Integer)1));
        this.cacheManager = cacheManager;
        this.connectTimeout = connectTimeout;
        this.injective = injective;
        this.factoryId = "kafka-factory-" + kafkaTopic + UUID.randomUUID();
    }

    public KafkaLookupExtractorFactory(NamespaceExtractionCacheManager cacheManager, String kafkaTopic, Map<String, String> kafkaProperties) {
        this(cacheManager, kafkaTopic, kafkaProperties, 0L, false);
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public Map<String, String> getKafkaProperties() {
        return this.kafkaProperties;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isInjective() {
        return this.injective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.get()) {
                LOG.warn("Already started, not starting again", new Object[0]);
                return true;
            }
            if (this.executorService.isShutdown()) {
                LOG.warn("Already shut down, not starting again", new Object[0]);
                return false;
            }
            this.verifyKafkaProperties();
            final String topic = this.getKafkaTopic();
            LOG.debug("About to listen to topic [%s] with group.id [%s]", new Object[]{topic, this.factoryId});
            this.cacheHandler = this.cacheManager.createCache();
            Map map = this.cacheHandler.getCache();
            this.mapRef.set(map);
            CountDownLatch startingReads = new CountDownLatch(1);
            ListenableFuture future = this.executorService.submit(() -> {
                consumer.subscribe(Collections.singletonList(topic));
                try (Consumer<String, String> consumer = this.getConsumer();){
                    while (!this.executorService.isShutdown()) {
                        try {
                            if (this.executorService.isShutdown()) {
                                break;
                            }
                            ConsumerRecords records = consumer.poll(1000L);
                            startingReads.countDown();
                            for (ConsumerRecord record : records) {
                                String key = (String)record.key();
                                String message = (String)record.value();
                                if (key == null) {
                                    LOG.error("Bad key from topic [%s]: [%s]", new Object[]{topic, record});
                                    continue;
                                }
                                if (message == null) {
                                    LOG.trace("Removed key[%s] val[%s]", new Object[]{key, message});
                                    this.doubleEventCount.incrementAndGet();
                                    map.remove(key);
                                    this.doubleEventCount.incrementAndGet();
                                    continue;
                                }
                                this.doubleEventCount.incrementAndGet();
                                map.put(key, message);
                                this.doubleEventCount.incrementAndGet();
                                LOG.trace("Placed key[%s] val[%s]", new Object[]{key, message});
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e, "Error reading stream for topic [%s]", new Object[]{topic});
                        }
                    }
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    LOG.debug("Success listening to [%s]", new Object[]{topic});
                }

                public void onFailure(Throwable t) {
                    if (t instanceof CancellationException) {
                        LOG.debug("Topic [%s] cancelled", new Object[]{topic});
                    } else {
                        LOG.error(t, "Error in listening to [%s]", new Object[]{topic});
                    }
                }
            }, (Executor)Execs.directExecutor());
            this.future = future;
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                while (!startingReads.await(100L, TimeUnit.MILLISECONDS) && this.connectTimeout > 0L) {
                    if (future.isDone()) {
                        future.get();
                        continue;
                    }
                    if (stopwatch.elapsed(TimeUnit.MILLISECONDS) <= this.connectTimeout) continue;
                    throw new TimeoutException("Failed to connect to kafka in sufficient time");
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.executorService.shutdown();
                future.cancel(true);
                LOG.error((Throwable)e, "Failed to start kafka extraction factory", new Object[0]);
                this.cacheHandler.close();
                return false;
            }
            this.started.set(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get() || this.executorService.isShutdown()) {
                LOG.info("Already shutdown, ignoring", new Object[0]);
                return !this.started.get();
            }
            this.started.set(false);
            this.executorService.shutdown();
            ListenableFuture<?> future = this.future;
            if (future != null) {
                future.cancel(true);
            }
            this.cacheHandler.close();
            return true;
        }
    }

    public boolean replaces(@Nullable LookupExtractorFactory other) {
        if (this == other) {
            return false;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return true;
        }
        KafkaLookupExtractorFactory that = (KafkaLookupExtractorFactory)other;
        return !this.getKafkaTopic().equals(that.getKafkaTopic()) || !this.getKafkaProperties().equals(that.getKafkaProperties()) || this.getConnectTimeout() != that.getConnectTimeout() || this.isInjective() != that.isInjective();
    }

    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return new KafkaLookupExtractorIntrospectionHandler(this);
    }

    public void awaitInitialization() {
    }

    public boolean isInitialized() {
        return true;
    }

    public LookupExtractor get() {
        Map map = (Map)Preconditions.checkNotNull(this.mapRef.get(), (Object)"Not started");
        final long startCount = this.doubleEventCount.get();
        return new MapLookupExtractor(map, this.isInjective()){

            public byte[] getCacheKey() {
                byte[] idutf8 = StringUtils.toUtf8((String)KafkaLookupExtractorFactory.this.factoryId);
                if (startCount == KafkaLookupExtractorFactory.this.doubleEventCount.get()) {
                    return ByteBuffer.allocate(idutf8.length + 1 + 8).put(idutf8).put((byte)-1).putLong(startCount).array();
                }
                byte[] scrambler = StringUtils.toUtf8((String)UUID.randomUUID().toString());
                return ByteBuffer.allocate(idutf8.length + 1 + scrambler.length + 1).put(idutf8).put((byte)-1).put(scrambler).put((byte)-1).array();
            }
        };
    }

    public long getCompletedEventCount() {
        return this.doubleEventCount.get() >> 1;
    }

    NamespaceExtractionCacheManager getCacheManager() {
        return this.cacheManager;
    }

    AtomicReference<Map<String, String>> getMapRef() {
        return this.mapRef;
    }

    AtomicLong getDoubleEventCount() {
        return this.doubleEventCount;
    }

    ListenableFuture<?> getFuture() {
        return this.future;
    }

    private void verifyKafkaProperties() {
        if (this.kafkaProperties.containsKey("group.id")) {
            throw new IAE("Cannot set kafka property [group.id]. Property is randomly generated for you. Found [%s]", new Object[]{this.kafkaProperties.get("group.id")});
        }
        if (this.kafkaProperties.containsKey("auto.offset.reset")) {
            throw new IAE("Cannot set kafka property [auto.offset.reset]. Property will be forced to [earliest]. Found [%s]", new Object[]{this.kafkaProperties.get("auto.offset.reset")});
        }
        if (this.kafkaProperties.containsKey("enable.auto.commit") && !this.kafkaProperties.get("enable.auto.commit").equals("false")) {
            throw new IAE("Cannot set kafka property [enable.auto.commit]. Property will be forced to [false]. Found [%s]", new Object[]{this.kafkaProperties.get("enable.auto.commit")});
        }
        Preconditions.checkNotNull((Object)this.kafkaProperties.get("bootstrap.servers"), (Object)"bootstrap.servers required property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Consumer<String, String> getConsumer() {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        Properties properties = this.getConsumerProperties();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            KafkaConsumer kafkaConsumer = new KafkaConsumer(properties, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            return kafkaConsumer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    @Nonnull
    private Properties getConsumerProperties() {
        Properties properties = new Properties();
        properties.putAll(this.kafkaProperties);
        properties.setProperty("auto.offset.reset", "earliest");
        properties.setProperty("group.id", this.factoryId);
        properties.setProperty("enable.auto.commit", "false");
        return properties;
    }

    static {
        String allowedSaslOauthbearerUrlsConfig = "org.apache.kafka.sasl.oauthbearer.allowed.urls";
        String allowedUrlsProp = System.getProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
        if (allowedUrlsProp == null) {
            System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", "notallowed");
        }
        LOG = new Logger(KafkaLookupExtractorFactory.class);
    }
}

