/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.joda.time.Interval;

public class SegmentLockAcquireAction
implements TaskAction<LockResult> {
    private final TaskLockType lockType;
    private final Interval interval;
    private final String version;
    private final int partitionId;
    private final long timeoutMs;

    @JsonCreator
    public SegmentLockAcquireAction(@JsonProperty(value="lockType") TaskLockType lockType, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="timeoutMs") long timeoutMs) {
        this.lockType = (TaskLockType)((Object)Preconditions.checkNotNull((Object)((Object)lockType), (Object)"lockType"));
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.partitionId = partitionId;
        this.timeoutMs = timeoutMs;
    }

    @JsonProperty
    public TaskLockType getLockType() {
        return this.lockType;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public TypeReference<LockResult> getReturnTypeReference() {
        return new TypeReference<LockResult>(){};
    }

    @Override
    public LockResult perform(Task task, TaskActionToolbox toolbox) {
        try {
            if (this.timeoutMs == 0L) {
                return toolbox.getTaskLockbox().lock(task, new SpecificSegmentLockRequest(this.lockType, task, this.interval, this.version, this.partitionId));
            }
            return toolbox.getTaskLockbox().lock(task, new SpecificSegmentLockRequest(this.lockType, task, this.interval, this.version, this.partitionId), this.timeoutMs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "SegmentLockAcquireAction{lockType=" + this.lockType + ", interval=" + this.interval + ", version='" + this.version + "', partitionId=" + this.partitionId + ", timeoutMs=" + this.timeoutMs + "}";
    }
}

