/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.Uuid;

public class ShareFetchMetadata {
    public static final int INITIAL_EPOCH = 0;
    public static final int FINAL_EPOCH = -1;
    private final Uuid memberId;
    private final int epoch;

    public boolean isNewSession() {
        return this.epoch == 0;
    }

    public boolean isFull() {
        return this.epoch == 0 || this.epoch == -1;
    }

    public static int nextEpoch(int prevEpoch) {
        if (prevEpoch < 0) {
            return -1;
        }
        if (prevEpoch == Integer.MAX_VALUE) {
            return 1;
        }
        return prevEpoch + 1;
    }

    public ShareFetchMetadata(Uuid memberId, int epoch) {
        this.memberId = memberId;
        this.epoch = epoch;
    }

    public static ShareFetchMetadata initialEpoch(Uuid memberId) {
        return new ShareFetchMetadata(memberId, 0);
    }

    public ShareFetchMetadata nextEpoch() {
        return new ShareFetchMetadata(this.memberId, ShareFetchMetadata.nextEpoch(this.epoch));
    }

    public ShareFetchMetadata nextCloseExistingAttemptNew() {
        return new ShareFetchMetadata(this.memberId, 0);
    }

    public ShareFetchMetadata finalEpoch() {
        return new ShareFetchMetadata(this.memberId, -1);
    }

    public Uuid memberId() {
        return this.memberId;
    }

    public int epoch() {
        return this.epoch;
    }

    public boolean isFinalEpoch() {
        return this.epoch == -1;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(memberId=").append(this.memberId).append(", ");
        if (this.epoch == 0) {
            bld.append("epoch=INITIAL)");
        } else if (this.epoch == -1) {
            bld.append("epoch=FINAL)");
        } else {
            bld.append("epoch=").append(this.epoch).append(")");
        }
        return bld.toString();
    }
}

