/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.segment.cache.CacheStats;
import org.apache.druid.metadata.segment.cache.HeapMemoryDatasourceSegmentCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentRecord;
import org.apache.druid.metadata.segment.cache.SegmentSchemaRecord;
import org.apache.druid.metadata.segment.cache.SegmentSyncResult;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.TransactionCallback;

@ThreadSafe
public class HeapMemorySegmentMetadataCache
implements SegmentMetadataCache {
    private static final EmittingLogger log = new EmittingLogger(HeapMemorySegmentMetadataCache.class);
    private static final int SQL_MAX_RETRIES = 3;
    private static final int SQL_QUIET_RETRIES = 2;
    private static final int READY_TIMEOUT_MILLIS = 300000;
    private static final int MIN_SYNC_DELAY_MILLIS = 1000;
    private static final int MAX_IMMEDIATE_SYNC_RETRIES = 3;
    private static final Duration SYNC_BUFFER_DURATION = Duration.standardSeconds((long)10L);
    private final ObjectMapper jsonMapper;
    private final Duration pollDuration;
    private final SegmentMetadataCache.UsageMode cacheMode;
    private final MetadataStorageTablesConfig tablesConfig;
    private final SQLMetadataConnector connector;
    private final boolean useSchemaCache;
    private final SegmentSchemaCache segmentSchemaCache;
    private final ListeningScheduledExecutorService pollExecutor;
    private final ServiceEmitter emitter;
    private final Object cacheStateLock = new Object();
    private final AtomicBoolean isCacheReady = new AtomicBoolean(false);
    @GuardedBy(value="cacheStateLock")
    private CacheState currentCacheState = CacheState.STOPPED;
    @GuardedBy(value="cacheStateLock")
    private ListenableFuture<Long> nextSyncFuture = null;
    @GuardedBy(value="cacheStateLock")
    private int consecutiveSyncFailures = 0;
    private final ConcurrentHashMap<String, HeapMemoryDatasourceSegmentCache> datasourceToSegmentCache = new ConcurrentHashMap();
    private final AtomicReference<DateTime> syncFinishTime = new AtomicReference();
    private final AtomicReference<DataSourcesSnapshot> datasourcesSnapshot = new AtomicReference<Object>(null);

    @Inject
    public HeapMemorySegmentMetadataCache(ObjectMapper jsonMapper, Supplier<SegmentsMetadataManagerConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfig, SegmentSchemaCache segmentSchemaCache, SQLMetadataConnector connector, ScheduledExecutorFactory executorFactory, ServiceEmitter emitter) {
        this.jsonMapper = jsonMapper;
        this.cacheMode = ((SegmentsMetadataManagerConfig)config.get()).getCacheUsageMode();
        this.pollDuration = ((SegmentsMetadataManagerConfig)config.get()).getPollDuration().toStandardDuration();
        this.tablesConfig = (MetadataStorageTablesConfig)tablesConfig.get();
        this.useSchemaCache = segmentSchemaCache.isEnabled();
        this.segmentSchemaCache = segmentSchemaCache;
        this.connector = connector;
        this.pollExecutor = this.isEnabled() ? MoreExecutors.listeningDecorator((ScheduledExecutorService)executorFactory.create(1, "SegmentMetadataCache-%s")) : null;
        this.emitter = emitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this.isEnabled()) {
            log.info("Segment metadata cache is not enabled.", new Object[0]);
            return;
        }
        Object object = this.cacheStateLock;
        synchronized (object) {
            if (this.currentCacheState == CacheState.STOPPED) {
                this.updateCacheState(CacheState.FOLLOWER, "Scheduling sync with metadata store");
            }
            if (this.cacheMode == SegmentMetadataCache.UsageMode.ALWAYS) {
                this.performFirstSync();
            }
            this.scheduleSyncWithMetadataStore(this.pollDuration.getMillis());
        }
    }

    private void performFirstSync() {
        try {
            log.info("Cache is in usage mode[%s]. Starting first sync with metadata store.", new Object[]{this.cacheMode});
            long syncDurationMillis = this.syncWithMetadataStore();
            this.emitMetric("segment/metadataCache/sync/time", syncDurationMillis);
            log.info("Finished first sync of cache with metadata store in [%d] millis.", new Object[]{syncDurationMillis});
        }
        catch (Throwable t) {
            throw InternalServerError.exception((Throwable)t, (String)"Could not sync segment metadata cache with metadata store", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.cacheStateLock;
        synchronized (object) {
            if (this.isEnabled()) {
                this.pollExecutor.shutdownNow();
                this.datasourceToSegmentCache.forEach((datasource, cache) -> cache.stop());
                this.datasourceToSegmentCache.clear();
                this.datasourcesSnapshot.set(null);
                this.syncFinishTime.set(null);
                this.updateCacheState(CacheState.STOPPED, "Stopped sync with metadata store");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void becomeLeader() {
        Object object = this.cacheStateLock;
        synchronized (object) {
            if (this.isEnabled()) {
                if (this.currentCacheState == CacheState.STOPPED) {
                    throw DruidException.defensive((String)"Cache has not been started yet", (Object[])new Object[0]);
                }
                if (this.currentCacheState == CacheState.FOLLOWER) {
                    this.updateCacheState(CacheState.LEADER_FIRST_SYNC_PENDING, "We are now leader");
                    if (this.nextSyncFuture != null && !this.nextSyncFuture.isDone()) {
                        this.nextSyncFuture.cancel(true);
                    }
                } else {
                    log.info("We are already the leader. Cache is in state[%s].", new Object[]{this.currentCacheState});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBeingLeader() {
        Object object = this.cacheStateLock;
        synchronized (object) {
            if (this.isEnabled()) {
                this.updateCacheState(CacheState.FOLLOWER, "Not leader anymore");
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.cacheMode != SegmentMetadataCache.UsageMode.NEVER;
    }

    @Override
    public boolean isSyncedForRead() {
        return this.isEnabled() && this.isCacheReady.get();
    }

    @Override
    public DataSourcesSnapshot getDataSourcesSnapshot() {
        this.verifyCacheIsUsableAndAwaitSyncIf(this.isEnabled());
        return this.datasourcesSnapshot.get();
    }

    @Override
    public void awaitNextSync(long timeoutMillis) {
        DateTime lastSyncTime = this.syncFinishTime.get();
        Supplier lastSyncTimeIsNotUpdated = () -> Objects.equals(this.syncFinishTime.get(), lastSyncTime);
        this.waitForCacheToFinishSyncWhile((Supplier<Boolean>)lastSyncTimeIsNotUpdated, timeoutMillis);
    }

    @Override
    public <T> T readCacheForDataSource(String dataSource, SegmentMetadataCache.Action<T> readAction) {
        this.verifyCacheIsUsableAndAwaitSyncIf(this.isEnabled());
        try (HeapMemoryDatasourceSegmentCache datasourceCache = this.getCacheWithReference(dataSource);){
            Object t = datasourceCache.withReadLock(() -> {
                try {
                    return readAction.perform(datasourceCache);
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            return t;
        }
    }

    @Override
    public <T> T writeCacheForDataSource(String dataSource, SegmentMetadataCache.Action<T> writeAction) {
        this.verifyCacheIsUsableAndAwaitSyncIf(this.cacheMode == SegmentMetadataCache.UsageMode.ALWAYS);
        try (HeapMemoryDatasourceSegmentCache datasourceCache = this.getCacheWithReference(dataSource);){
            Object t = datasourceCache.withWriteLock(() -> {
                try {
                    return writeAction.perform(datasourceCache);
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            return t;
        }
    }

    private HeapMemoryDatasourceSegmentCache getCacheWithReference(String dataSource) {
        return this.datasourceToSegmentCache.compute(dataSource, (ds, existingCache) -> {
            HeapMemoryDatasourceSegmentCache newCache = existingCache == null ? new HeapMemoryDatasourceSegmentCache((String)ds) : existingCache;
            newCache.acquireReference();
            return newCache;
        });
    }

    private HeapMemoryDatasourceSegmentCache getCacheForDatasource(String dataSource) {
        return this.datasourceToSegmentCache.computeIfAbsent(dataSource, HeapMemoryDatasourceSegmentCache::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCacheIsUsableAndAwaitSyncIf(boolean shouldWait) {
        if (!this.isEnabled()) {
            throw DruidException.defensive((String)"Segment metadata cache is not enabled.", (Object[])new Object[0]);
        }
        Object object = this.cacheStateLock;
        synchronized (object) {
            switch (this.currentCacheState) {
                case STOPPED: {
                    throw InternalServerError.exception((String)"Segment metadata cache has not been started yet.", (Object[])new Object[0]);
                }
                case FOLLOWER: {
                    throw InternalServerError.exception((String)"Not leader yet. Segment metadata cache is not usable.", (Object[])new Object[0]);
                }
                case LEADER_FIRST_SYNC_PENDING: 
                case LEADER_FIRST_SYNC_STARTED: {
                    if (!shouldWait) break;
                    this.waitForCacheToFinishSyncWhile((Supplier<Boolean>)((Supplier)this::isLeaderSyncPending), 300000L);
                    this.verifyCacheIsUsableAndAwaitSyncIf(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLeaderSyncPending() {
        Object object = this.cacheStateLock;
        synchronized (object) {
            return this.currentCacheState == CacheState.LEADER_FIRST_SYNC_PENDING || this.currentCacheState == CacheState.LEADER_FIRST_SYNC_STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCacheToFinishSyncWhile(Supplier<Boolean> waitCondition, long timeoutMillis) {
        Stopwatch totalWaitTime = Stopwatch.createStarted();
        Object object = this.cacheStateLock;
        synchronized (object) {
            log.info("Waiting for cache to finish sync with metadata store.", new Object[0]);
            while (((Boolean)waitCondition.get()).booleanValue() && totalWaitTime.millisElapsed() <= timeoutMillis) {
                try {
                    this.cacheStateLock.wait(timeoutMillis);
                }
                catch (InterruptedException e) {
                    log.noStackTrace().info((Throwable)e, "Interrupted while waiting for cache to be ready", new Object[0]);
                    throw DruidException.defensive((Throwable)e, (String)"Interrupted while waiting for cache to be ready", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Error while waiting for cache to be ready", new Object[0]);
                    throw DruidException.defensive((Throwable)e, (String)"Error while waiting for cache to be ready", (Object[])new Object[0]);
                }
            }
            log.info("Wait complete. Cache is now in state[%s].", new Object[]{this.currentCacheState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheState(CacheState targetState, String message) {
        Object object = this.cacheStateLock;
        synchronized (object) {
            this.currentCacheState = targetState;
            log.info("%s. Cache is now in state[%s].", new Object[]{message, this.currentCacheState});
            this.isCacheReady.set(this.currentCacheState == CacheState.LEADER_READY);
            this.notifyThreadsWaitingOnCacheSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThreadsWaitingOnCacheSync() {
        Object object = this.cacheStateLock;
        synchronized (object) {
            this.cacheStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSyncWithMetadataStore(long delayMillis) {
        Object object = this.cacheStateLock;
        synchronized (object) {
            this.nextSyncFuture = this.pollExecutor.schedule(this::syncWithMetadataStore, delayMillis, TimeUnit.MILLISECONDS);
            Futures.addCallback(this.nextSyncFuture, (FutureCallback)new FutureCallback<Long>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Long previousSyncDurationMillis) {
                    long nextSyncDelay;
                    Object object = HeapMemorySegmentMetadataCache.this.cacheStateLock;
                    synchronized (object) {
                        if (HeapMemorySegmentMetadataCache.this.currentCacheState == CacheState.LEADER_FIRST_SYNC_STARTED) {
                            HeapMemorySegmentMetadataCache.this.updateCacheState(CacheState.LEADER_READY, StringUtils.format((String)"Finished sync with metadata store in [%d] millis", (Object[])new Object[]{previousSyncDurationMillis}));
                        } else {
                            HeapMemorySegmentMetadataCache.this.notifyThreadsWaitingOnCacheSync();
                        }
                    }
                    HeapMemorySegmentMetadataCache.this.emitMetric("segment/metadataCache/sync/time", previousSyncDurationMillis);
                    Object object2 = HeapMemorySegmentMetadataCache.this.cacheStateLock;
                    synchronized (object2) {
                        HeapMemorySegmentMetadataCache.this.consecutiveSyncFailures = 0;
                        nextSyncDelay = HeapMemorySegmentMetadataCache.this.currentCacheState == CacheState.LEADER_FIRST_SYNC_PENDING ? 0L : Math.max(HeapMemorySegmentMetadataCache.this.pollDuration.getMillis() - previousSyncDurationMillis, 0L);
                    }
                    HeapMemorySegmentMetadataCache.this.scheduleSyncWithMetadataStore(nextSyncDelay);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    long nextSyncDelay;
                    if (t instanceof CancellationException) {
                        log.noStackTrace().info(t, "Sync with metadata store was cancelled", new Object[0]);
                    } else {
                        log.noStackTrace().makeAlert(t, "Could not sync segment metadata cache with metadata store", new Object[0]).emit();
                    }
                    Object object = HeapMemorySegmentMetadataCache.this.cacheStateLock;
                    synchronized (object) {
                        nextSyncDelay = ++HeapMemorySegmentMetadataCache.this.consecutiveSyncFailures > 3 || HeapMemorySegmentMetadataCache.this.currentCacheState != CacheState.LEADER_FIRST_SYNC_PENDING ? HeapMemorySegmentMetadataCache.this.pollDuration.getMillis() : 1000L;
                    }
                    HeapMemorySegmentMetadataCache.this.scheduleSyncWithMetadataStore(nextSyncDelay);
                }
            }, (Executor)this.pollExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long syncWithMetadataStore() {
        DateTime syncStartTime = DateTimes.nowUtc();
        Stopwatch totalSyncDuration = Stopwatch.createStarted();
        Object object = this.cacheStateLock;
        synchronized (object) {
            if (this.currentCacheState == CacheState.LEADER_FIRST_SYNC_PENDING) {
                this.updateCacheState(CacheState.LEADER_FIRST_SYNC_STARTED, "Started sync of latest updates from metadata store");
            }
        }
        HashMap<String, DatasourceSegmentSummary> datasourceToSummary = new HashMap<String, DatasourceSegmentSummary>();
        if (this.syncFinishTime.get() == null) {
            this.retrieveAllUsedSegments(datasourceToSummary);
        } else {
            this.retrieveUsedSegmentIds(datasourceToSummary);
            this.updateSegmentIdsInCache(datasourceToSummary, syncStartTime.minus((ReadableDuration)SYNC_BUFFER_DURATION));
            this.retrieveUsedSegmentPayloads(datasourceToSummary);
        }
        this.updateUsedSegmentPayloadsInCache(datasourceToSummary);
        this.retrieveAllPendingSegments(datasourceToSummary);
        this.updatePendingSegmentsInCache(datasourceToSummary, syncStartTime.minus((ReadableDuration)SYNC_BUFFER_DURATION));
        if (this.useSchemaCache) {
            this.retrieveAndResetUsedSegmentSchemas(datasourceToSummary);
        }
        this.markCacheSynced(syncStartTime);
        this.syncFinishTime.set(DateTimes.nowUtc());
        return totalSyncDuration.millisElapsed();
    }

    private void markCacheSynced(DateTime syncStartTime) {
        Stopwatch updateDuration = Stopwatch.createStarted();
        Set<String> cachedDatasources = Set.copyOf(this.datasourceToSegmentCache.keySet());
        HashMap<String, Set<DataSegment>> datasourceToUsedSegments = new HashMap<String, Set<DataSegment>>();
        for (String dataSource : cachedDatasources) {
            HeapMemoryDatasourceSegmentCache cache = this.datasourceToSegmentCache.getOrDefault(dataSource, new HeapMemoryDatasourceSegmentCache(dataSource));
            CacheStats stats = cache.markCacheSynced();
            if (cache.isEmpty()) {
                this.datasourceToSegmentCache.compute(dataSource, (ds, existingCache) -> {
                    if (existingCache != null && existingCache.isEmpty() && !existingCache.isBeingUsedByTransaction()) {
                        this.emitMetric(dataSource, "segment/metadataCache/dataSource/deleted", 1L);
                        return null;
                    }
                    return existingCache;
                });
                continue;
            }
            this.emitMetric(dataSource, "segment/metadataCache/interval/count", stats.getNumIntervals());
            this.emitMetric(dataSource, "segment/metadataCache/used/count", stats.getNumUsedSegments());
            this.emitMetric(dataSource, "segment/metadataCache/unused/count", stats.getNumUnusedSegments());
            this.emitMetric(dataSource, "segment/metadataCache/pending/count", stats.getNumPendingSegments());
            datasourceToUsedSegments.put(dataSource, cache.findUsedSegmentsOverlappingAnyOf(List.of()));
        }
        this.datasourcesSnapshot.set(DataSourcesSnapshot.fromUsedSegments(datasourceToUsedSegments, syncStartTime));
        this.emitMetric("segment/metadataCache/updateSnapshot/time", updateDuration.millisElapsed());
    }

    private void retrieveUsedSegmentIds(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Stopwatch retrieveDuration = Stopwatch.createStarted();
        String sql = StringUtils.format((String)"SELECT id, dataSource, used_status_last_updated FROM %s WHERE used = true", (Object[])new Object[]{this.tablesConfig.getSegmentsTable()});
        int numSkippedRecords = (Integer)this.inReadOnlyTransaction((handle, status) -> {
            try (ResultIterator iterator = handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> SegmentRecord.fromResultSet(r)).iterator();){
                int skippedRecords = 0;
                while (iterator.hasNext()) {
                    SegmentRecord record = (SegmentRecord)iterator.next();
                    if (record == null) {
                        ++skippedRecords;
                        continue;
                    }
                    SegmentId segmentId = record.getSegmentId();
                    datasourceToSummary.computeIfAbsent(segmentId.getDataSource(), ds -> new DatasourceSegmentSummary()).addSegmentRecord(record);
                }
                Integer n = skippedRecords;
                return n;
            }
        });
        if (numSkippedRecords > 0) {
            this.emitMetric("segment/metadataCache/skipped", numSkippedRecords);
        }
        datasourceToSummary.forEach((dataSource, summary) -> this.emitMetric((String)dataSource, "segment/used/count", summary.persistedSegments.size()));
        this.emitMetric("segment/metadataCache/fetchIds/time", retrieveDuration.millisElapsed());
    }

    private <T> T query(Function<SqlSegmentsMetadataQuery, T> sqlFunction) {
        return this.inReadOnlyTransaction((handle, status) -> sqlFunction.apply(SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.tablesConfig, this.jsonMapper)));
    }

    private <T> T inReadOnlyTransaction(TransactionCallback<T> callback) {
        return this.connector.retryReadOnlyTransaction(callback, 2, 3);
    }

    private void retrieveRequiredUsedSegments(String dataSource, DatasourceSegmentSummary summary) {
        Set<SegmentId> segmentIdsToRefresh = summary.usedSegmentIdsToRefresh;
        if (segmentIdsToRefresh.isEmpty()) {
            return;
        }
        this.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator<DataSegmentPlus> iterator = SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.tablesConfig, this.jsonMapper).retrieveSegmentsByIdIterator(dataSource, segmentIdsToRefresh, this.useSchemaCache);){
                iterator.forEachRemaining(summary.usedSegments::add);
                Integer n = 0;
                return n;
            }
        });
    }

    private void updateSegmentIdsInCache(Map<String, DatasourceSegmentSummary> datasourceToSummary, DateTime syncStartTime) {
        Stopwatch updateDuration = Stopwatch.createStarted();
        datasourceToSummary.forEach((dataSource, summary) -> {
            HeapMemoryDatasourceSegmentCache cache = this.getCacheForDatasource((String)dataSource);
            SegmentSyncResult result = cache.syncSegmentIds(summary.persistedSegments, syncStartTime);
            this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/used/stale", result.getExpiredIds().size());
            this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/deleted", result.getDeleted());
            summary.usedSegmentIdsToRefresh.addAll(result.getExpiredIds());
        });
        this.datasourceToSegmentCache.forEach((dataSource, cache) -> {
            if (!datasourceToSummary.containsKey(dataSource)) {
                SegmentSyncResult result = cache.syncSegmentIds(List.of(), syncStartTime);
                this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/deleted", result.getDeleted());
            }
        });
        this.emitMetric("segment/metadataCache/updateIds/time", updateDuration.millisElapsed());
    }

    private void retrieveUsedSegmentPayloads(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Stopwatch retrieveDuration = Stopwatch.createStarted();
        datasourceToSummary.forEach(this::retrieveRequiredUsedSegments);
        this.emitMetric("segment/metadataCache/fetchPayloads/time", retrieveDuration.millisElapsed());
    }

    private void retrieveAllUsedSegments(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Stopwatch retrieveDuration = Stopwatch.createStarted();
        String sql = this.useSchemaCache ? StringUtils.format((String)"SELECT id, payload, created_date, used_status_last_updated, schema_fingerprint, num_rows FROM %s WHERE used = true", (Object[])new Object[]{this.tablesConfig.getSegmentsTable()}) : StringUtils.format((String)"SELECT id, payload, created_date, used_status_last_updated FROM %s WHERE used = true", (Object[])new Object[]{this.tablesConfig.getSegmentsTable()});
        int numSkippedSegments = (Integer)this.inReadOnlyTransaction((handle, status) -> {
            try (ResultIterator iterator = handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> this.mapToSegmentPlus(r)).iterator();){
                int skippedRecords = 0;
                while (iterator.hasNext()) {
                    DataSegmentPlus segment = (DataSegmentPlus)iterator.next();
                    if (segment == null) {
                        ++skippedRecords;
                        continue;
                    }
                    datasourceToSummary.computeIfAbsent(segment.getDataSegment().getDataSource(), (Function<String, DatasourceSegmentSummary>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$retrieveAllUsedSegments$15(java.lang.String ), (Ljava/lang/String;)Lorg/apache/druid/metadata/segment/cache/HeapMemorySegmentMetadataCache$DatasourceSegmentSummary;)()).usedSegments.add(segment);
                }
                Integer n = skippedRecords;
                return n;
            }
        });
        if (numSkippedSegments > 0) {
            this.emitMetric("segment/metadataCache/skipped", numSkippedSegments);
        }
        datasourceToSummary.forEach((dataSource, summary) -> this.emitMetric((String)dataSource, "segment/used/count", summary.usedSegments.size()));
        this.emitMetric("segment/metadataCache/fetchPayloads/time", retrieveDuration.millisElapsed());
    }

    private void updateUsedSegmentPayloadsInCache(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        datasourceToSummary.forEach((dataSource, summary) -> {
            HeapMemoryDatasourceSegmentCache cache = this.getCacheForDatasource((String)dataSource);
            int numUpdatedSegments = cache.insertSegments(summary.usedSegments);
            this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/used/updated", numUpdatedSegments);
        });
    }

    private void updatePendingSegmentsInCache(Map<String, DatasourceSegmentSummary> datasourceToSummary, DateTime syncStartTime) {
        datasourceToSummary.forEach((dataSource, summary) -> {
            HeapMemoryDatasourceSegmentCache cache = this.getCacheForDatasource((String)dataSource);
            SegmentSyncResult result = cache.syncPendingSegments(summary.persistedPendingSegments, syncStartTime);
            this.emitMetric((String)dataSource, "segment/pending/count", summary.persistedPendingSegments.size());
            this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/pending/updated", result.getUpdated());
            this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/pending/deleted", result.getDeleted());
        });
        this.datasourceToSegmentCache.forEach((dataSource, cache) -> {
            if (!datasourceToSummary.containsKey(dataSource)) {
                SegmentSyncResult result = cache.syncPendingSegments(List.of(), syncStartTime);
                this.emitNonZeroMetric((String)dataSource, "segment/metadataCache/pending/deleted", result.getDeleted());
            }
        });
    }

    private void retrieveAllPendingSegments(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Stopwatch fetchDuration = Stopwatch.createStarted();
        String sql = StringUtils.format((String)"SELECT id, dataSource, payload, sequence_name, sequence_prev_id, upgraded_from_segment_id, task_allocator_id, created_date FROM %1$s", (Object[])new Object[]{this.tablesConfig.getPendingSegmentsTable()});
        AtomicInteger numSkippedRecords = new AtomicInteger();
        this.inReadOnlyTransaction((handle, status) -> handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> {
            String segmentId = null;
            String dataSource = null;
            try {
                segmentId = r.getString("id");
                dataSource = r.getString("dataSource");
                datasourceToSummary.computeIfAbsent(dataSource, ds -> new DatasourceSegmentSummary()).addPendingSegmentRecord(PendingSegmentRecord.fromResultSet(r, this.jsonMapper));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error occurred while reading Pending Segment ID[%s] of datasource[%s].", new Object[]{segmentId, dataSource});
                numSkippedRecords.incrementAndGet();
            }
            return 0;
        }).list());
        this.emitMetric("segment/metadataCache/fetchPending/time", fetchDuration.millisElapsed());
        if (numSkippedRecords.get() > 0) {
            this.emitMetric("segment/metadataCache/pending/skipped", numSkippedRecords.get());
        }
    }

    private void retrieveAndResetUsedSegmentSchemas(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Stopwatch schemaSyncDuration = Stopwatch.createStarted();
        Map<String, SchemaPayload> schemaFingerprintToPayload = this.syncFinishTime.get() == null ? this.buildSchemaFingerprintToPayloadMapForFullSync() : this.buildSchemaFingerprintToPayloadMapForDeltaSync();
        this.segmentSchemaCache.resetSchemaForPublishedSegments(this.buildSegmentIdToMetadataMapForSync(datasourceToSummary), schemaFingerprintToPayload);
        this.segmentSchemaCache.getStats().forEach(this::emitMetric);
        this.emitMetric("segment/metadataCache/fetchSchemas/time", schemaSyncDuration.millisElapsed());
    }

    private Map<String, SchemaPayload> buildSchemaFingerprintToPayloadMapForFullSync() {
        List records = this.query(SqlSegmentsMetadataQuery::retrieveAllUsedSegmentSchemas);
        return records.stream().collect(Collectors.toMap(SegmentSchemaRecord::getFingerprint, SegmentSchemaRecord::getPayload));
    }

    private Map<String, SchemaPayload> buildSchemaFingerprintToPayloadMapForDeltaSync() {
        HashMap<String, SchemaPayload> schemaFingerprintToPayload = new HashMap<String, SchemaPayload>(this.segmentSchemaCache.getPublishedSchemaPayloadMap());
        Set cachedFingerprints = Set.copyOf(schemaFingerprintToPayload.keySet());
        Set persistedFingerprints = this.query(SqlSegmentsMetadataQuery::retrieveAllUsedSegmentSchemaFingerprints);
        Sets.SetView deletedFingerprints = Sets.difference(cachedFingerprints, (Set)persistedFingerprints);
        deletedFingerprints.forEach(schemaFingerprintToPayload::remove);
        Sets.SetView addedFingerprints = Sets.difference((Set)persistedFingerprints, cachedFingerprints);
        List addedSegmentSchemaRecords = this.query(arg_0 -> HeapMemorySegmentMetadataCache.lambda$buildSchemaFingerprintToPayloadMapForDeltaSync$24((Set)addedFingerprints, arg_0));
        if (addedSegmentSchemaRecords.size() < addedFingerprints.size()) {
            this.emitMetric("segment/metadataCache/schema/skipped", addedFingerprints.size() - addedSegmentSchemaRecords.size());
        }
        addedSegmentSchemaRecords.forEach(schema -> schemaFingerprintToPayload.put(schema.getFingerprint(), schema.getPayload()));
        return schemaFingerprintToPayload;
    }

    private Map<SegmentId, SegmentMetadata> buildSegmentIdToMetadataMapForSync(Map<String, DatasourceSegmentSummary> datasourceToSummary) {
        Map<SegmentId, SegmentMetadata> cachedSegmentIdToMetadata = this.segmentSchemaCache.getPublishedSegmentMetadataMap();
        HashMap<SegmentId, SegmentMetadata> syncedSegmentIdToMetadataMap = new HashMap<SegmentId, SegmentMetadata>(cachedSegmentIdToMetadata);
        cachedSegmentIdToMetadata.keySet().forEach(segmentId -> {
            DataSegment cachedSegment = this.getCacheForDatasource(segmentId.getDataSource()).findUsedSegment((SegmentId)segmentId);
            if (cachedSegment == null) {
                syncedSegmentIdToMetadataMap.remove(segmentId);
            }
        });
        datasourceToSummary.values().forEach(summary -> summary.usedSegments.forEach(segment -> {
            if (segment.getNumRows() != null && segment.getSchemaFingerprint() != null) {
                syncedSegmentIdToMetadataMap.put(segment.getDataSegment().getId(), new SegmentMetadata(segment.getNumRows(), segment.getSchemaFingerprint()));
            }
        }));
        return syncedSegmentIdToMetadataMap;
    }

    @Nullable
    private DataSegmentPlus mapToSegmentPlus(ResultSet resultSet) {
        String segmentId = null;
        try {
            segmentId = resultSet.getString(1);
            return new DataSegmentPlus((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])resultSet.getBytes(2), DataSegment.class), DateTimes.of((String)resultSet.getString(3)), SqlSegmentsMetadataQuery.nullAndEmptySafeDate(resultSet.getString(4)), true, this.useSchemaCache ? resultSet.getString(5) : null, this.useSchemaCache ? (Long)resultSet.getObject(6) : null, null);
        }
        catch (Throwable t) {
            log.error(t, "Could not read segment with ID[%s]", new Object[]{segmentId});
            return null;
        }
    }

    private void emitMetric(String metric, long value) {
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric(metric, (Number)value));
    }

    private void emitNonZeroMetric(String datasource, String metric, long value) {
        if (value == 0L) {
            return;
        }
        this.emitMetric(datasource, metric, value);
    }

    private void emitMetric(String datasource, String metric, long value) {
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("dataSource", (Object)datasource).setMetric(metric, (Number)value));
    }

    private static /* synthetic */ List lambda$buildSchemaFingerprintToPayloadMapForDeltaSync$24(Set addedFingerprints, SqlSegmentsMetadataQuery sql) {
        return sql.retrieveUsedSegmentSchemasForFingerprints(addedFingerprints);
    }

    private static /* synthetic */ DatasourceSegmentSummary lambda$retrieveAllUsedSegments$15(String ds) {
        return new DatasourceSegmentSummary();
    }

    private static enum CacheState {
        STOPPED,
        FOLLOWER,
        LEADER_FIRST_SYNC_PENDING,
        LEADER_FIRST_SYNC_STARTED,
        LEADER_READY;

    }

    private static class DatasourceSegmentSummary {
        final List<SegmentRecord> persistedSegments = new ArrayList<SegmentRecord>();
        final List<PendingSegmentRecord> persistedPendingSegments = new ArrayList<PendingSegmentRecord>();
        final Set<SegmentId> usedSegmentIdsToRefresh = new HashSet<SegmentId>();
        final Set<DataSegmentPlus> usedSegments = new HashSet<DataSegmentPlus>();

        private DatasourceSegmentSummary() {
        }

        private void addSegmentRecord(SegmentRecord record) {
            this.persistedSegments.add(record);
        }

        private void addPendingSegmentRecord(PendingSegmentRecord record) {
            this.persistedPendingSegments.add(record);
        }
    }
}

