/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.druid.guice.KeyHolder;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryLogic;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.DruidNode;

public class DruidBinders {
    public static MapBinder<Class<? extends Query>, QueryRunnerFactory> queryRunnerFactoryBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Query>>(){}, (TypeLiteral)TypeLiteral.get(QueryRunnerFactory.class));
    }

    public static MapBinder<Class<? extends Query>, QueryToolChest> queryToolChestBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Query>>(){}, (TypeLiteral)new TypeLiteral<QueryToolChest>(){});
    }

    public static MapBinder<Class<? extends Query>, QueryLogic> queryLogicBinderType(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Query>>(){}, (TypeLiteral)new TypeLiteral<QueryLogic>(){});
    }

    public static QueryBinder queryBinder(Binder binder) {
        return new QueryBinder(binder);
    }

    public static Multibinder<KeyHolder<DruidNode>> discoveryAnnouncementBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<KeyHolder<DruidNode>>(){});
    }

    public static Multibinder<Class<? extends Monitor>> metricMonitorBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Monitor>>(){});
    }

    public static MapBinder<Class<? extends DataSource>, SegmentWrangler> segmentWranglerBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends DataSource>>(){}, (TypeLiteral)new TypeLiteral<SegmentWrangler>(){});
    }

    public static Multibinder<JoinableFactory> joinableFactoryMultiBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<JoinableFactory>(){});
    }

    public static MapBinder<Class<? extends JoinableFactory>, Class<? extends DataSource>> joinableMappingBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends JoinableFactory>>(){}, (TypeLiteral)new TypeLiteral<Class<? extends DataSource>>(){});
    }

    public static class QueryBinder {
        MapBinderHelper<Class<? extends Query>, QueryLogic> queryLogicBinder;
        MapBinderHelper<Class<? extends Query>, QueryRunnerFactory> queryRunnerFactoryBinder;
        MapBinderHelper<Class<? extends Query>, QueryToolChest> queryToolChestBinder;

        public QueryBinder(Binder binder) {
            this.queryLogicBinder = new MapBinderHelper<Class<? extends Query>, QueryLogic>(binder, DruidBinders.queryLogicBinderType(binder), (Set<Class<? extends Annotation>>)ImmutableSet.of(LazySingleton.class));
            this.queryRunnerFactoryBinder = new MapBinderHelper<Class<? extends Query>, QueryRunnerFactory>(binder, DruidBinders.queryRunnerFactoryBinder(binder), (Set<Class<? extends Annotation>>)ImmutableSet.of(LazySingleton.class));
            this.queryToolChestBinder = new MapBinderHelper<Class<? extends Query>, QueryToolChest>(binder, DruidBinders.queryToolChestBinder(binder), (Set<Class<? extends Annotation>>)ImmutableSet.of(LazySingleton.class));
        }

        public QueryBinder bindQueryLogic(Class<? extends Query> queryTypeClazz, Class<? extends QueryLogic> queryLogicClazz) {
            this.queryLogicBinder.bind(queryTypeClazz, queryLogicClazz);
            return this;
        }

        public QueryBinder bindQueryRunnerFactory(Class<? extends Query> queryTypeClazz, Class<? extends QueryRunnerFactory> queryRunnerFactory) {
            this.queryRunnerFactoryBinder.bind(queryTypeClazz, queryRunnerFactory);
            return this;
        }

        public QueryBinder naiveBinding2(Class<? extends Query> class1, Class<? extends QueryToolChest> class2) {
            return this.bindQueryToolChest(class1, class2);
        }

        public QueryBinder bindQueryToolChest(Class<? extends Query> queryTypeClazz, Class<? extends QueryToolChest> queryToolChest) {
            this.queryToolChestBinder.bind(queryTypeClazz, queryToolChest);
            return this;
        }

        public QueryBinder naiveBinding(Class<? extends Query> queryTypeClazz, Class<? extends QueryRunnerFactory> queryRunnerFactory) {
            return this.bindQueryRunnerFactory(queryTypeClazz, queryRunnerFactory);
        }
    }

    public static class MapBinderHelper<KeyClass, ValueClass> {
        protected final Binder binder;
        protected final MapBinder<KeyClass, ValueClass> mapBinder;
        protected final Set<Class<? extends Annotation>> scopes;

        private MapBinderHelper(Binder binder, MapBinder<KeyClass, ValueClass> mapBinder, Set<Class<? extends Annotation>> scopes) {
            this.binder = binder;
            this.mapBinder = mapBinder;
            this.scopes = scopes;
        }

        protected Binder getBinder() {
            return this.binder;
        }

        protected MapBinder<KeyClass, ValueClass> getMapBinder() {
            return this.mapBinder;
        }

        public MapBinderHelper<KeyClass, ValueClass> bind(KeyClass key, Class<? extends ValueClass> value) {
            this.mapBinder.addBinding(key).to(value);
            for (Class<? extends Annotation> clazz : this.scopes) {
                this.binder.bind(value).in(clazz);
            }
            return this;
        }
    }
}

