/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Integration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeIntegrationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<Integration> integrations;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeIntegrationsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Integration> getIntegrations() {
        if (this.integrations == null) {
            this.integrations = new SdkInternalList();
        }
        return this.integrations;
    }

    public void setIntegrations(Collection<Integration> integrations) {
        if (integrations == null) {
            this.integrations = null;
            return;
        }
        this.integrations = new SdkInternalList(integrations);
    }

    public DescribeIntegrationsResult withIntegrations(Integration ... integrations) {
        if (this.integrations == null) {
            this.setIntegrations((Collection<Integration>)new SdkInternalList(integrations.length));
        }
        for (Integration ele : integrations) {
            this.integrations.add((Object)ele);
        }
        return this;
    }

    public DescribeIntegrationsResult withIntegrations(Collection<Integration> integrations) {
        this.setIntegrations(integrations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getIntegrations() != null) {
            sb.append("Integrations: ").append(this.getIntegrations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsResult)) {
            return false;
        }
        DescribeIntegrationsResult other = (DescribeIntegrationsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getIntegrations() == null ^ this.getIntegrations() == null) {
            return false;
        }
        return other.getIntegrations() == null || other.getIntegrations().equals(this.getIntegrations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrations() == null ? 0 : this.getIntegrations().hashCode());
        return hashCode;
    }

    public DescribeIntegrationsResult clone() {
        try {
            return (DescribeIntegrationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

