/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.timeline.DataSegment;

public class CompactionState {
    private final PartitionsSpec partitionsSpec;
    private final DimensionsSpec dimensionsSpec;
    private final CompactionTransformSpec transformSpec;
    private final IndexSpec indexSpec;
    private final GranularitySpec granularitySpec;
    private final List<AggregatorFactory> metricsSpec;
    @Nullable
    private final List<AggregateProjectionSpec> projections;

    @JsonCreator
    public CompactionState(@JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") List<AggregatorFactory> metricsSpec, @JsonProperty(value="transformSpec") CompactionTransformSpec transformSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="projections") @Nullable List<AggregateProjectionSpec> projections) {
        this.partitionsSpec = partitionsSpec;
        this.dimensionsSpec = dimensionsSpec;
        this.metricsSpec = metricsSpec;
        this.transformSpec = transformSpec;
        this.indexSpec = indexSpec;
        this.granularitySpec = granularitySpec;
        this.projections = projections;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    public List<AggregatorFactory> getMetricsSpec() {
        return this.metricsSpec;
    }

    @JsonProperty
    public CompactionTransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionState that = (CompactionState)o;
        return Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.dimensionsSpec, that.dimensionsSpec) && Objects.equals(this.transformSpec, that.transformSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.metricsSpec, that.metricsSpec) && Objects.equals(this.projections, that.projections);
    }

    public int hashCode() {
        return Objects.hash(this.partitionsSpec, this.dimensionsSpec, this.transformSpec, this.indexSpec, this.granularitySpec, this.metricsSpec, this.projections);
    }

    public String toString() {
        return "CompactionState{partitionsSpec=" + this.partitionsSpec + ", dimensionsSpec=" + this.dimensionsSpec + ", transformSpec=" + this.transformSpec + ", indexSpec=" + this.indexSpec + ", granularitySpec=" + this.granularitySpec + ", metricsSpec=" + this.metricsSpec + ", projections=" + this.projections + "}";
    }

    public static Function<Set<DataSegment>, Set<DataSegment>> addCompactionStateToSegments(PartitionsSpec partitionsSpec, DimensionsSpec dimensionsSpec, List<AggregatorFactory> metricsSpec, CompactionTransformSpec transformSpec, IndexSpec indexSpec, GranularitySpec granularitySpec, @Nullable List<AggregateProjectionSpec> projections) {
        IndexSpec effectiveIndexSpec = indexSpec.getEffectiveSpec();
        DimensionsSpec effectiveDimensions = DimensionsSpec.builder(dimensionsSpec).setDimensions(dimensionsSpec.getDimensions().stream().map(dim -> dim.getEffectiveSchema(effectiveIndexSpec)).collect(Collectors.toList())).build();
        CompactionState compactionState = new CompactionState(partitionsSpec, effectiveDimensions, metricsSpec, transformSpec, effectiveIndexSpec, granularitySpec, projections);
        return segments -> segments.stream().map(s -> s.withLastCompactionState(compactionState)).collect(Collectors.toSet());
    }
}

