/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.ColumnMapping;

public class ColumnMappings {
    private final List<ColumnMapping> mappings;
    private final Map<String, IntList> outputColumnNameToPositionMap;
    private final Map<String, IntList> queryColumnNameToPositionMap;

    @JsonCreator
    public ColumnMappings(List<ColumnMapping> mappings) {
        this.mappings = (List)Preconditions.checkNotNull(mappings, (Object)"mappings");
        this.outputColumnNameToPositionMap = new HashMap<String, IntList>();
        this.queryColumnNameToPositionMap = new HashMap<String, IntList>();
        for (int i = 0; i < mappings.size(); ++i) {
            ColumnMapping mapping = mappings.get(i);
            this.outputColumnNameToPositionMap.computeIfAbsent(mapping.getOutputColumn(), k -> new IntArrayList()).add(i);
            this.queryColumnNameToPositionMap.computeIfAbsent(mapping.getQueryColumn(), k -> new IntArrayList()).add(i);
        }
    }

    public static ColumnMappings identity(RowSignature signature) {
        return new ColumnMappings(signature.getColumnNames().stream().map(column -> new ColumnMapping((String)column, (String)column)).collect(Collectors.toList()));
    }

    public int size() {
        return this.mappings.size();
    }

    public List<String> getOutputColumnNames() {
        return this.mappings.stream().map(ColumnMapping::getOutputColumn).collect(Collectors.toList());
    }

    public boolean hasUniqueOutputColumnNames() {
        HashSet<String> encountered = new HashSet<String>();
        for (ColumnMapping mapping : this.mappings) {
            if (encountered.add(mapping.getOutputColumn())) continue;
            return false;
        }
        return true;
    }

    public boolean hasOutputColumn(String outputColumnName) {
        return this.outputColumnNameToPositionMap.containsKey(outputColumnName);
    }

    public String getQueryColumnName(int outputColumn) {
        if (outputColumn < 0 || outputColumn >= this.mappings.size()) {
            throw new IAE("Output column position[%d] out of range", new Object[]{outputColumn});
        }
        return this.mappings.get(outputColumn).getQueryColumn();
    }

    public String getOutputColumnName(int outputColumn) {
        if (outputColumn < 0 || outputColumn >= this.mappings.size()) {
            throw new IAE("Output column position[%d] out of range", new Object[]{outputColumn});
        }
        return this.mappings.get(outputColumn).getOutputColumn();
    }

    public IntList getOutputColumnsByName(String outputColumnName) {
        return this.outputColumnNameToPositionMap.getOrDefault(outputColumnName, IntLists.emptyList());
    }

    public IntList getOutputColumnsForQueryColumn(String queryColumnName) {
        IntList outputColumnPositions = this.queryColumnNameToPositionMap.get(queryColumnName);
        if (outputColumnPositions == null) {
            return IntLists.emptyList();
        }
        return outputColumnPositions;
    }

    @JsonValue
    public List<ColumnMapping> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMappings that = (ColumnMappings)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public String toString() {
        return "ColumnMappings{mappings=" + this.mappings + "}";
    }

    public Iterable<String> getOutputColumns() {
        return Iterables.transform(this.mappings, ColumnMapping::getOutputColumn);
    }
}

