/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.input;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.shuffle.output.StageOutputHolder;

public class WorkerOrLocalInputChannelFactory
implements InputChannelFactory {
    private final String myId;
    private final Supplier<List<String>> workerIdsSupplier;
    private final InputChannelFactory workerInputChannelFactory;
    private final StageOutputHolderProvider stageOutputHolderProvider;

    public WorkerOrLocalInputChannelFactory(String myId, Supplier<List<String>> workerIdsSupplier, InputChannelFactory workerInputChannelFactory, StageOutputHolderProvider stageOutputHolderProvider) {
        this.myId = myId;
        this.workerIdsSupplier = workerIdsSupplier;
        this.workerInputChannelFactory = workerInputChannelFactory;
        this.stageOutputHolderProvider = stageOutputHolderProvider;
    }

    @Override
    public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) throws IOException {
        String taskId = this.workerIdsSupplier.get().get(workerNumber);
        if (taskId.equals(this.myId)) {
            return this.stageOutputHolderProvider.getHolder(stageId, partitionNumber).readLocally();
        }
        return this.workerInputChannelFactory.openChannel(stageId, workerNumber, partitionNumber);
    }

    public static interface StageOutputHolderProvider {
        public StageOutputHolder getHolder(StageId var1, int var2);
    }
}

