/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="InsertCannotBeEmpty")
public class InsertCannotBeEmptyFault
extends BaseMSQFault {
    public static final String CODE = "InsertCannotBeEmpty";
    private final String dataSource;

    @JsonCreator
    public InsertCannotBeEmptyFault(@JsonProperty(value="dataSource") String dataSource) {
        super(CODE, "No rows to insert for dataSource[%s]. Set failOnEmptyInsert : false in the query context to allow empty inserts.", dataSource, new Object[0]);
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertCannotBeEmptyFault that = (InsertCannotBeEmptyFault)o;
        return Objects.equals(this.dataSource, that.dataSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataSource);
    }
}

