/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.Indexed;

public class StringUtf8DictionaryEncodedColumnSupplier<TIndexed extends Indexed<ByteBuffer>>
implements Supplier<DictionaryEncodedColumn<?>> {
    private final Supplier<TIndexed> utf8Dictionary;
    @Nullable
    private final Supplier<ColumnarInts> singleValuedColumn;
    @Nullable
    private final Supplier<ColumnarMultiInts> multiValuedColumn;
    private final BitmapFactory bitmapFactory;

    public StringUtf8DictionaryEncodedColumnSupplier(Supplier<TIndexed> utf8Dictionary, @Nullable Supplier<ColumnarInts> singleValuedColumn, @Nullable Supplier<ColumnarMultiInts> multiValuedColumn, BitmapFactory bitmapFactory) {
        this.utf8Dictionary = utf8Dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.bitmapFactory = bitmapFactory;
    }

    public Supplier<TIndexed> getDictionary() {
        return this.utf8Dictionary;
    }

    public DictionaryEncodedColumn<?> get() {
        Indexed suppliedUtf8Dictionary = (Indexed)this.utf8Dictionary.get();
        return new StringUtf8DictionaryEncodedColumn(this.singleValuedColumn != null ? (ColumnarInts)this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? (ColumnarMultiInts)this.multiValuedColumn.get() : null, suppliedUtf8Dictionary, this.bitmapFactory);
    }
}

