/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public final class NullableNumericAggregator
implements Aggregator {
    private final Aggregator delegate;
    private final BaseNullableColumnValueSelector selector;
    private boolean isNullResult = true;

    public NullableNumericAggregator(Aggregator delegate, BaseNullableColumnValueSelector selector) {
        this.delegate = delegate;
        this.selector = selector;
    }

    @Override
    public void aggregate() {
        boolean isNotNull;
        boolean bl = isNotNull = !this.selector.isNull();
        if (isNotNull) {
            if (this.isNullResult) {
                this.isNullResult = false;
            }
            this.delegate.aggregate();
        }
    }

    @Override
    @Nullable
    public Object get() {
        if (this.isNullResult) {
            return null;
        }
        return this.delegate.get();
    }

    @Override
    public float getFloat() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return float for Null Value");
        }
        return this.delegate.getFloat();
    }

    @Override
    public long getLong() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return long for Null Value");
        }
        return this.delegate.getLong();
    }

    @Override
    public double getDouble() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return double for Null Value");
        }
        return this.delegate.getDouble();
    }

    @Override
    public boolean isNull() {
        return this.isNullResult || this.delegate.isNull();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

