/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.pool;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClientProxyConfig;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.pool.ResourceFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.Timer;

public class ChannelResourceFactory
implements ResourceFactory<String, ChannelFuture> {
    private static final Logger log = new Logger(ChannelResourceFactory.class);
    private static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final String PROXY_HANDLER_NAME = "druid-proxy";
    private static final String ERROR_HANDLER_NAME = "druid-connection-error";
    private final ClientBootstrap bootstrap;
    private final SSLContext sslContext;
    private final HttpClientProxyConfig proxyConfig;
    private final Timer timer;
    private final long sslHandshakeTimeout;

    public ChannelResourceFactory(ClientBootstrap bootstrap, SSLContext sslContext, HttpClientProxyConfig proxyConfig, Timer timer, long sslHandshakeTimeout) {
        this.bootstrap = (ClientBootstrap)Preconditions.checkNotNull((Object)bootstrap, (Object)"bootstrap");
        this.sslContext = sslContext;
        this.proxyConfig = proxyConfig;
        this.timer = timer;
        long l = this.sslHandshakeTimeout = sslHandshakeTimeout >= 0L ? sslHandshakeTimeout : DEFAULT_SSL_HANDSHAKE_TIMEOUT_MILLIS;
        if (sslContext != null) {
            Preconditions.checkNotNull((Object)timer, (Object)"timer is required when sslContext is present");
        }
    }

    @Override
    public ChannelFuture generate(final String hostname) {
        ChannelFuture retVal;
        ChannelFuture connectFuture;
        int port;
        URL url;
        log.debug("Generating: %s", hostname);
        try {
            url = new URL(hostname);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String host = url.getHost();
        int n = port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if (this.proxyConfig != null) {
            ChannelFuture proxyFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.proxyConfig.getHost(), this.proxyConfig.getPort()));
            connectFuture = Channels.future((Channel)proxyFuture.getChannel());
            final String proxyUri = StringUtils.format("%s:%d", host, port);
            final DefaultHttpRequest connectRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, proxyUri);
            if (this.proxyConfig.getUser() != null) {
                connectRequest.headers().add("Proxy-Authorization", (Object)Request.makeBasicAuthenticationString(this.proxyConfig.getUser(), this.proxyConfig.getPassword()));
            }
            proxyFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f1) {
                    if (f1.isSuccess()) {
                        Channel channel = f1.getChannel();
                        channel.getPipeline().addLast(ChannelResourceFactory.PROXY_HANDLER_NAME, (ChannelHandler)new SimpleChannelUpstreamHandler(){

                            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
                                Object msg = e.getMessage();
                                ChannelPipeline pipeline = ctx.getPipeline();
                                pipeline.remove(ChannelResourceFactory.PROXY_HANDLER_NAME);
                                if (msg instanceof HttpResponse) {
                                    HttpResponse httpResponse = (HttpResponse)msg;
                                    if (HttpResponseStatus.OK.equals((Object)httpResponse.getStatus())) {
                                        pipeline.replace("codec", "codec", (ChannelHandler)new HttpClientCodec());
                                        connectFuture.setSuccess();
                                    } else {
                                        connectFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Got status[%s] from CONNECT request to proxy[%s]", httpResponse.getStatus(), proxyUri)));
                                    }
                                } else {
                                    connectFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Got message of type[%s], don't know what to do.", msg.getClass())));
                                }
                            }
                        });
                        channel.write((Object)connectRequest).addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture f2) {
                                if (!f2.isSuccess()) {
                                    connectFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Problem with CONNECT request to proxy[%s]", proxyUri), f2.getCause()));
                                }
                            }
                        });
                    } else {
                        connectFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Problem connecting to proxy[%s]", proxyUri), f1.getCause()));
                    }
                }
            });
        } else {
            connectFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        }
        if ("https".equals(url.getProtocol())) {
            if (this.sslContext == null) {
                throw new IllegalStateException("No sslContext set, cannot do https");
            }
            SSLEngine sslEngine = this.sslContext.createSSLEngine(host, port);
            SSLParameters sslParameters = new SSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
            sslEngine.setUseClientMode(true);
            final SslHandler sslHandler = new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, this.timer, this.sslHandshakeTimeout);
            sslHandler.setCloseOnSSLException(true);
            final ChannelFuture handshakeFuture = Channels.future((Channel)connectFuture.getChannel());
            connectFuture.getChannel().getPipeline().addLast(ERROR_HANDLER_NAME, (ChannelHandler)new ConnectionErrorHandler(handshakeFuture));
            connectFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) {
                    if (f.isSuccess()) {
                        ChannelPipeline pipeline = f.getChannel().getPipeline();
                        pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
                        sslHandler.handshake().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture f2) {
                                if (f2.isSuccess()) {
                                    handshakeFuture.setSuccess();
                                } else {
                                    handshakeFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Failed to handshake with host[%s]", hostname), f2.getCause()));
                                }
                            }
                        });
                    } else {
                        handshakeFuture.setFailure((Throwable)new ChannelException(StringUtils.format("Failed to connect to host[%s]", hostname), f.getCause()));
                    }
                }
            });
            retVal = handshakeFuture;
        } else {
            connectFuture.getChannel().getPipeline().addLast(ERROR_HANDLER_NAME, (ChannelHandler)new ConnectionErrorHandler(null));
            retVal = connectFuture;
        }
        return retVal;
    }

    @Override
    public boolean isGood(ChannelFuture resource) {
        Channel channel = resource.awaitUninterruptibly().getChannel();
        boolean isSuccess = resource.isSuccess();
        boolean isConnected = channel.isConnected();
        boolean isOpen = channel.isOpen();
        if (log.isTraceEnabled()) {
            log.trace("isGood = isSucess[%s] && isConnected[%s] && isOpen[%s]", isSuccess, isConnected, isOpen);
        }
        return isSuccess && isConnected && isOpen;
    }

    @Override
    public void close(ChannelFuture resource) {
        log.trace("Closing", new Object[0]);
        resource.awaitUninterruptibly().getChannel().close();
    }

    private static class ConnectionErrorHandler
    extends SimpleChannelUpstreamHandler {
        @Nullable
        private final ChannelFuture future;

        public ConnectionErrorHandler(@Nullable ChannelFuture future) {
            this.future = future;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            Channel channel = ctx.getChannel();
            if (channel == null) {
                if (this.future != null && !this.future.isDone()) {
                    ChannelException e2 = new ChannelException(StringUtils.format("Channel is null. The context name is [%s]", ctx.getName()));
                    e2.addSuppressed(e.getCause());
                    this.future.setFailure((Throwable)e2);
                }
                return;
            }
            if (this.future != null && !this.future.isDone()) {
                this.future.setFailure(e.getCause());
            }
            if (channel.isOpen() && this == ctx.getPipeline().getLast()) {
                channel.close();
            }
            ctx.sendUpstream((ChannelEvent)e);
        }
    }
}

