/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;

public class ReadableConcatFrameChannel
implements ReadableFrameChannel {
    private final Iterator<ReadableFrameChannel> channelIterator;
    @Nullable
    private ReadableFrameChannel currentChannel;

    private ReadableConcatFrameChannel(Iterator<ReadableFrameChannel> channelIterator) {
        this.channelIterator = channelIterator;
        this.currentChannel = channelIterator.hasNext() ? channelIterator.next() : null;
    }

    public static ReadableConcatFrameChannel open(Iterator<ReadableFrameChannel> channelIterator) {
        return new ReadableConcatFrameChannel(channelIterator);
    }

    @Override
    public boolean isFinished() {
        this.advanceCurrentChannelIfFinished();
        return this.currentChannel == null || this.currentChannel.isFinished();
    }

    @Override
    public boolean canRead() {
        this.advanceCurrentChannelIfFinished();
        return this.currentChannel != null && this.currentChannel.canRead();
    }

    @Override
    public Frame read() {
        if (!this.canRead()) {
            throw new NoSuchElementException();
        }
        assert (this.currentChannel != null);
        return this.currentChannel.read();
    }

    @Override
    public ListenableFuture<?> readabilityFuture() {
        this.advanceCurrentChannelIfFinished();
        if (this.currentChannel == null) {
            return Futures.immediateFuture(null);
        }
        return this.currentChannel.readabilityFuture();
    }

    @Override
    public void close() {
        if (this.currentChannel != null) {
            this.currentChannel.close();
        }
    }

    private void advanceCurrentChannelIfFinished() {
        while (this.currentChannel != null && this.currentChannel.isFinished() && this.channelIterator.hasNext()) {
            this.currentChannel = this.channelIterator.next();
        }
    }
}

