/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.shuffle.output.DurableStorageQueryResultsOutputChannelFactory;
import org.apache.druid.msq.shuffle.output.DurableStorageTaskOutputChannelFactory;
import org.apache.druid.storage.StorageConnector;

public abstract class DurableStorageOutputChannelFactory
implements OutputChannelFactory {
    private static final Logger LOG = new Logger(DurableStorageOutputChannelFactory.class);
    protected final String controllerTaskId;
    protected final int workerNumber;
    protected final int stageNumber;
    protected final String taskId;
    protected final int frameSize;
    protected final StorageConnector storageConnector;
    protected final File tmpDir;
    protected final ExecutorService remoteInputStreamPool;

    public DurableStorageOutputChannelFactory(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector, File tmpDir) {
        this.controllerTaskId = (String)Preconditions.checkNotNull((Object)controllerTaskId, (Object)"controllerTaskId");
        this.workerNumber = workerNumber;
        this.stageNumber = stageNumber;
        this.taskId = taskId;
        this.frameSize = frameSize;
        this.storageConnector = (StorageConnector)Preconditions.checkNotNull((Object)storageConnector, (Object)"storageConnector");
        this.tmpDir = (File)Preconditions.checkNotNull((Object)tmpDir, (Object)"tmpDir is null");
        this.remoteInputStreamPool = Executors.newCachedThreadPool(Execs.makeThreadFactory((String)"-remote-fetcher-%d"));
    }

    public static DurableStorageOutputChannelFactory createStandardImplementation(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector, File tmpDir, boolean isQueryResults) {
        if (isQueryResults) {
            return new DurableStorageQueryResultsOutputChannelFactory(controllerTaskId, workerNumber, stageNumber, taskId, frameSize, storageConnector, tmpDir);
        }
        return new DurableStorageTaskOutputChannelFactory(controllerTaskId, workerNumber, stageNumber, taskId, frameSize, storageConnector, tmpDir);
    }

    public void createSuccessFile(String taskId) throws IOException {
        String fileName = this.getSuccessFilePath();
        if (this.storageConnector.pathExists(fileName)) {
            LOG.warn("Path [%s] already exists. Won't attempt to rewrite on top of it.", new Object[]{fileName});
            return;
        }
        OutputStreamWriter os = new OutputStreamWriter(this.storageConnector.write(fileName), StandardCharsets.UTF_8);
        os.write(taskId);
        os.close();
    }

    public abstract String getSuccessFilePath();

    public OutputChannel openNilChannel(int partitionNumber) {
        String fileName = this.getFileNameWithPathForPartition(partitionNumber);
        try {
            FrameFileWriter.open((WritableByteChannel)Channels.newChannel(this.storageConnector.write(fileName)), null, (ByteTracker)ByteTracker.unboundedTracker()).close();
            return OutputChannel.nil((int)partitionNumber);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Unable to create empty remote output of stage [%d], partition [%d] for worker [%d]", new Object[]{this.stageNumber, partitionNumber, this.workerNumber});
        }
    }

    protected abstract String getFileNameWithPathForPartition(int var1);
}

