/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.results;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.BaseFrameProcessorFactory;
import org.apache.druid.msq.querykit.results.QueryResultsFrameProcessor;

@JsonTypeName(value="selectResults")
public class QueryResultFrameProcessorFactory
extends BaseFrameProcessorFactory {
    @JsonCreator
    public QueryResultFrameProcessorFactory() {
    }

    @Override
    public ProcessorsAndChannels<Object, Long> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher, boolean removeNullBytes) {
        StageInputSlice slice = (StageInputSlice)Iterables.getOnlyElement(inputSlices);
        if (inputSliceReader.numReadableInputs(slice) == 0) {
            return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.none(), OutputChannels.none());
        }
        Int2ObjectAVLTreeMap outputChannels = new Int2ObjectAVLTreeMap();
        for (ReadablePartition partition : slice.getPartitions()) {
            outputChannels.computeIfAbsent(partition.getPartitionNumber(), i -> {
                try {
                    return outputChannelFactory.openChannel(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Sequence readableInputs = Sequences.simple((Iterable)inputSliceReader.attach(0, slice, counters, warningPublisher));
        Sequence processors = readableInputs.map(arg_0 -> QueryResultFrameProcessorFactory.lambda$makeProcessors$1((Int2ObjectSortedMap)outputChannels, arg_0));
        return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.of((Sequence)processors), OutputChannels.wrapReadOnly((List)ImmutableList.copyOf((Collection)outputChannels.values())));
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }

    private static /* synthetic */ FrameProcessor lambda$makeProcessors$1(Int2ObjectSortedMap outputChannels, ReadableInput readableInput) {
        OutputChannel outputChannel = (OutputChannel)outputChannels.get(readableInput.getStagePartition().getPartitionNumber());
        return new QueryResultsFrameProcessor(readableInput.getChannel(), outputChannel.getWritableChannel());
    }
}

