/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessorFactory;
import org.apache.druid.msq.querykit.groupby.GroupByPreShuffleFrameProcessor;
import org.apache.druid.query.Query;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.SegmentReference;

@JsonTypeName(value="groupByPreShuffle")
public class GroupByPreShuffleFrameProcessorFactory
extends BaseLeafFrameProcessorFactory {
    private final GroupByQuery query;

    @JsonCreator
    public GroupByPreShuffleFrameProcessorFactory(@JsonProperty(value="query") GroupByQuery query) {
        super((Query<?>)query);
        this.query = (GroupByQuery)Preconditions.checkNotNull((Object)query, (Object)"query");
    }

    @JsonProperty
    public GroupByQuery getQuery() {
        return this.query;
    }

    @Override
    protected FrameProcessor<Object> makeProcessor(ReadableInput baseInput, Function<SegmentReference, SegmentReference> segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, FrameContext frameContext) {
        return new GroupByPreShuffleFrameProcessor(this.query, frameContext.groupingEngine(), frameContext.processingBuffers().getBufferPool(), baseInput, segmentMapFn, outputChannelHolder, frameWriterFactoryHolder);
    }

    @Override
    public boolean usesProcessingBuffers() {
        return true;
    }
}

