/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.discovery.BrokerClient;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.ReadableConcatFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.apache.druid.frame.write.InvalidFieldException;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.LockReleaseAction;
import org.apache.druid.indexing.common.actions.MarkSegmentsAsUnusedAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalAppendAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalReplaceAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.batch.TooManyBucketsException;
import org.apache.druid.indexing.common.task.batch.parallel.TombstoneHelper;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.function.TriConsumer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.ClusterStatisticsMergeMode;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ControllerQueryResultsReader;
import org.apache.druid.msq.exec.ExceptionWrappingWorkerClient;
import org.apache.druid.msq.exec.ExportMetadataManager;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.exec.QueryKitBasedMSQPlanner;
import org.apache.druid.msq.exec.QueryListener;
import org.apache.druid.msq.exec.QueryValidator;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.exec.RetryCapableWorkerManager;
import org.apache.druid.msq.exec.SegmentLoadStatusFetcher;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.exec.WorkerSketchFetcher;
import org.apache.druid.msq.exec.WorkerStats;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelsImpl;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.WorkerCount;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.destination.ExportMSQDestination;
import org.apache.druid.msq.indexing.destination.SegmentGenerationStageSpec;
import org.apache.druid.msq.indexing.destination.TerminalStageSpec;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.FaultsExceededChecker;
import org.apache.druid.msq.indexing.error.InsertCannotAllocateSegmentFault;
import org.apache.druid.msq.indexing.error.InsertCannotBeEmptyFault;
import org.apache.druid.msq.indexing.error.InsertLockPreemptedFault;
import org.apache.druid.msq.indexing.error.InsertTimeOutOfBoundsFault;
import org.apache.druid.msq.indexing.error.InvalidFieldFault;
import org.apache.druid.msq.indexing.error.InvalidNullByteFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.TooManyBucketsFault;
import org.apache.druid.msq.indexing.error.TooManySegmentsInTimeChunkFault;
import org.apache.druid.msq.indexing.error.TooManyWarningsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.msq.indexing.error.WorkerRpcFailedFault;
import org.apache.druid.msq.indexing.processor.SegmentGeneratorFrameProcessorFactory;
import org.apache.druid.msq.indexing.report.MSQSegmentReport;
import org.apache.druid.msq.indexing.report.MSQStagesReport;
import org.apache.druid.msq.indexing.report.MSQStatusReport;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.InputSpecSlicerFactory;
import org.apache.druid.msq.input.MapInputSpecSlicer;
import org.apache.druid.msq.input.external.ExternalInputSpec;
import org.apache.druid.msq.input.external.ExternalInputSpecSlicer;
import org.apache.druid.msq.input.inline.InlineInputSpec;
import org.apache.druid.msq.input.inline.InlineInputSpecSlicer;
import org.apache.druid.msq.input.lookup.LookupInputSpec;
import org.apache.druid.msq.input.lookup.LookupInputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.input.stage.StageInputSpecSlicer;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.StagePartition;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernel;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelConfig;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.msq.shuffle.input.DurableStorageInputChannelFactory;
import org.apache.druid.msq.shuffle.input.WorkerInputChannelFactory;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;
import org.apache.druid.msq.util.IntervalUtils;
import org.apache.druid.msq.util.MSQFutureUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ControllerImpl
implements Controller {
    private static final Logger log = new Logger(ControllerImpl.class);
    private static final String RESULT_READER_CANCELLATION_ID = "result-reader";
    private final String queryId;
    private final MSQSpec querySpec;
    private final ResultsContext resultsContext;
    private final ControllerContext context;
    private volatile ControllerQueryKernelConfig queryKernelConfig;
    private final BlockingQueue<Consumer<ControllerQueryKernel>> kernelManipulationQueue = new ArrayBlockingQueue<Consumer<ControllerQueryKernel>>(100000);
    private final AtomicReference<MSQErrorReport> workerErrorRef = new AtomicReference();
    private final ConcurrentLinkedQueue<MSQErrorReport> workerWarnings = new ConcurrentLinkedQueue();
    private final AtomicReference<QueryDefinition> queryDefRef = new AtomicReference();
    private final CounterSnapshotsTree taskCountersForLiveReports = new CounterSnapshotsTree();
    private final ConcurrentHashMap<Integer, ControllerStagePhase> stagePhasesForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Interval> stageRuntimesForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> stageWorkerCountsForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> stagePartitionCountsForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, OutputChannelMode> stageOutputChannelModesForLiveReports = new ConcurrentHashMap();
    private WorkerSketchFetcher workerSketchFetcher;
    private final Map<Integer, Set<WorkOrder>> workOrdersToRetry = new HashMap<Integer, Set<WorkOrder>>();
    private volatile DateTime queryStartTime = null;
    private volatile DruidNode selfDruidNode;
    private volatile WorkerManager workerManager;
    private volatile WorkerClient netClient;
    private volatile FaultsExceededChecker faultsExceededChecker = null;
    private Map<Integer, ClusterStatisticsMergeMode> stageToStatsMergingMode;
    private volatile SegmentLoadStatusFetcher segmentLoadWaiter;
    @Nullable
    private MSQSegmentReport segmentReport;

    public ControllerImpl(String queryId, MSQSpec querySpec, ResultsContext resultsContext, ControllerContext controllerContext) {
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        this.querySpec = (MSQSpec)Preconditions.checkNotNull((Object)querySpec, (Object)"querySpec");
        this.resultsContext = (ResultsContext)Preconditions.checkNotNull((Object)resultsContext, (Object)"resultsContext");
        this.context = (ControllerContext)Preconditions.checkNotNull((Object)controllerContext, (Object)"controllerContext");
    }

    @Override
    public String queryId() {
        return this.queryId;
    }

    @Override
    public void run(QueryListener queryListener) throws Exception {
        MSQTaskReportPayload reportPayload;
        try (Closer closer = Closer.create();){
            reportPayload = this.runInternal(queryListener, closer);
        }
        queryListener.onQueryComplete(reportPayload);
    }

    @Override
    public void stop() {
        QueryDefinition queryDef = this.queryDefRef.get();
        log.info("Query [%s] canceled.", new Object[]{queryDef != null ? queryDef.getQueryId() : "<no id yet>"});
        this.stopExternalFetchers();
        this.addToKernelManipulationQueue(kernel -> {
            throw new MSQException(CanceledFault.INSTANCE);
        });
        if (this.workerManager != null) {
            this.workerManager.stop(true);
        }
    }

    private MSQTaskReportPayload runInternal(QueryListener queryListener, Closer closer) {
        MSQStagesReport stagesReport;
        MSQErrorReport errorForReport;
        TaskState taskStateForReport;
        QueryDefinition queryDef = null;
        ControllerQueryKernel queryKernel = null;
        ListenableFuture workerTaskRunnerFuture = null;
        CounterSnapshotsTree countersSnapshot = null;
        Throwable exceptionEncountered = null;
        try {
            this.queryStartTime = DateTimes.nowUtc();
            this.context.registerController(this, closer);
            queryDef = this.initializeQueryDefAndState(closer);
            this.netClient = (WorkerClient)closer.register((Closeable)new ExceptionWrappingWorkerClient(this.context.newWorkerClient()));
            this.workerSketchFetcher = new WorkerSketchFetcher(this.netClient, this.workerManager, this.queryKernelConfig.isFaultTolerant(), MultiStageQueryContext.getSketchEncoding(this.querySpec.getContext()));
            closer.register(this.workerSketchFetcher::close);
            InputSpecSlicerFactory inputSpecSlicerFactory = ControllerImpl.makeInputSpecSlicerFactory(this.context.newTableInputSpecSlicer(this.workerManager));
            Pair<ControllerQueryKernel, ListenableFuture<?>> queryRunResult = new RunQueryUntilDone(queryDef, this.queryKernelConfig, inputSpecSlicerFactory, queryListener, closer).run();
            queryKernel = (ControllerQueryKernel)Preconditions.checkNotNull((Object)((ControllerQueryKernel)queryRunResult.lhs));
            workerTaskRunnerFuture = (ListenableFuture)Preconditions.checkNotNull((Object)((ListenableFuture)queryRunResult.rhs));
            this.handleQueryResults(queryDef, queryKernel);
        }
        catch (Throwable e) {
            exceptionEncountered = e;
        }
        try {
            countersSnapshot = this.getFinalCountersSnapshot(queryKernel);
        }
        catch (Throwable e) {
            if (exceptionEncountered != null) {
                exceptionEncountered.addSuppressed(e);
            }
            exceptionEncountered = e;
        }
        if (queryKernel != null && queryKernel.isSuccess() && exceptionEncountered == null) {
            taskStateForReport = TaskState.SUCCESS;
            errorForReport = null;
        } else {
            String selfHost = MSQTasks.getHostFromSelfNode(this.selfDruidNode);
            MSQErrorReport controllerError = exceptionEncountered != null ? MSQErrorReport.fromException(this.queryId(), selfHost, null, exceptionEncountered, this.querySpec.getColumnMappings()) : null;
            MSQErrorReport workerError = this.workerErrorRef.get();
            taskStateForReport = TaskState.FAILED;
            errorForReport = MSQTasks.makeErrorReport(this.queryId(), selfHost, controllerError, workerError);
            if (controllerError != null) {
                log.warn("Controller: %s", new Object[]{MSQTasks.errorReportToLogMessage(controllerError)});
            }
            if (workerError != null) {
                log.warn("Worker: %s", new Object[]{MSQTasks.errorReportToLogMessage(workerError)});
            }
        }
        if (queryKernel != null && queryKernel.isSuccess()) {
            this.postFinishToWorkers(queryKernel.getAllParticipatingWorkers());
            this.workerManager.stop(false);
        } else if (this.workerManager != null) {
            this.workerManager.stop(true);
        }
        if (workerTaskRunnerFuture != null) {
            try {
                workerTaskRunnerFuture.get();
            }
            catch (Exception selfHost) {
                // empty catch block
            }
        }
        boolean shouldWaitForSegmentLoad = MultiStageQueryContext.shouldWaitForSegmentLoad(this.querySpec.getContext());
        try {
            if (MSQControllerTask.isIngestion(this.querySpec)) {
                this.releaseTaskLocks();
            }
            this.cleanUpDurableStorageIfNeeded();
            if (queryKernel != null && queryKernel.isSuccess() && shouldWaitForSegmentLoad && this.segmentLoadWaiter != null) {
                log.info("Controller will now wait for segments to be loaded. The query has already finished executing, and results will be included once the segments are loaded, even if this query is canceled now.", new Object[0]);
                this.segmentLoadWaiter.waitForSegmentsToLoad();
            }
            this.stopExternalFetchers();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception thrown during cleanup. Ignoring it and writing task report.", new Object[0]);
        }
        if (queryDef != null) {
            Map<Integer, ControllerStagePhase> stagePhaseMap;
            if (queryKernel != null) {
                queryKernel.markSuccessfulTerminalStagesAsFinished();
                stagePhaseMap = queryKernel.getActiveStages().stream().collect(Collectors.toMap(StageId::getStageNumber, queryKernel::getStagePhase));
            } else {
                stagePhaseMap = Collections.emptyMap();
            }
            stagesReport = ControllerImpl.makeStageReport(queryDef, stagePhaseMap, this.stageRuntimesForLiveReports, this.stageWorkerCountsForLiveReports, this.stagePartitionCountsForLiveReports, this.stageOutputChannelModesForLiveReports);
        } else {
            stagesReport = null;
        }
        MSQTaskReportPayload msqTaskReportPayload = new MSQTaskReportPayload(ControllerImpl.makeStatusReport(taskStateForReport, errorForReport, this.workerWarnings, this.queryStartTime, new Interval((ReadableInstant)this.queryStartTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis(), this.workerManager, this.segmentLoadWaiter, this.segmentReport), stagesReport, countersSnapshot, null);
        this.emitSummaryMetrics(msqTaskReportPayload, this.querySpec);
        return msqTaskReportPayload;
    }

    private void emitSummaryMetrics(MSQTaskReportPayload msqTaskReportPayload, MSQSpec querySpec) {
        HashSet<Integer> stagesToInclude = new HashSet<Integer>();
        MSQStagesReport stagesReport = msqTaskReportPayload.getStages();
        if (stagesReport != null) {
            for (MSQStagesReport.Stage stage : stagesReport.getStages()) {
                boolean hasParentStage = stage.getStageDefinition().getInputSpecs().stream().anyMatch(stageInput -> stageInput instanceof StageInputSpec);
                if (hasParentStage) continue;
                stagesToInclude.add(stage.getStageNumber());
            }
        }
        long totalProcessedBytes = 0L;
        if (msqTaskReportPayload.getCounters() != null) {
            totalProcessedBytes = msqTaskReportPayload.getCounters().copyMap().entrySet().stream().filter(entry -> stagesReport == null || stagesToInclude.contains(entry.getKey())).flatMap(counterSnapshotsMap -> ((Map)counterSnapshotsMap.getValue()).values().stream()).flatMap(counterSnapshots -> counterSnapshots.getMap().entrySet().stream()).filter(entry -> ((String)entry.getKey()).startsWith("input")).mapToLong(entry -> {
                ChannelCounters.Snapshot snapshot = (ChannelCounters.Snapshot)entry.getValue();
                return snapshot.getBytes() == null ? 0L : Arrays.stream(snapshot.getBytes()).sum();
            }).sum();
        }
        log.debug("Processed bytes[%d] for query[%s].", new Object[]{totalProcessedBytes, querySpec.getQuery()});
        this.context.emitMetric("ingest/input/bytes", totalProcessedBytes);
    }

    private void releaseTaskLocks() throws IOException {
        try {
            List locks = (List)this.context.taskActionClient().submit((TaskAction)new LockListAction());
            for (TaskLock lock : locks) {
                this.context.taskActionClient().submit((TaskAction)new LockReleaseAction(lock.getInterval()));
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to release locks", e);
        }
    }

    public void addToKernelManipulationQueue(Consumer<ControllerQueryKernel> kernelConsumer) {
        if (!this.kernelManipulationQueue.offer(kernelConsumer)) {
            String message = "Controller kernel queue is full. Main controller loop may be delayed or stuck.";
            log.warn("Controller kernel queue is full. Main controller loop may be delayed or stuck.", new Object[0]);
            throw new IllegalStateException("Controller kernel queue is full. Main controller loop may be delayed or stuck.");
        }
    }

    private QueryDefinition initializeQueryDefAndState(Closer closer) {
        this.selfDruidNode = this.context.selfNode();
        this.queryKernelConfig = this.context.queryKernelConfig(this.queryId, this.querySpec);
        QueryContext queryContext = this.querySpec.getContext();
        QueryKitBasedMSQPlanner qkPlanner = new QueryKitBasedMSQPlanner(this.context, this.querySpec, this.resultsContext, this.queryKernelConfig, this.queryId);
        QueryDefinition queryDef = qkPlanner.makeQueryDefinition();
        if (log.isDebugEnabled()) {
            try {
                log.debug("Query[%s] definition: %s", new Object[]{queryDef.getQueryId(), this.context.jsonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)queryDef)});
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        QueryValidator.validateQueryDef(queryDef);
        this.queryDefRef.set(queryDef);
        this.workerManager = this.context.newWorkerManager(this.queryId, this.querySpec, this.queryKernelConfig, (failedTask, fault) -> {
            if (!this.queryKernelConfig.isFaultTolerant() || !ControllerQueryKernel.isRetriableFault(fault)) {
                throw new MSQException(fault);
            }
            this.addToKernelManipulationQueue(kernel -> this.addToRetryQueue((ControllerQueryKernel)kernel, failedTask.getWorkerNumber(), fault));
        });
        if (this.queryKernelConfig.isFaultTolerant() && !(this.workerManager instanceof RetryCapableWorkerManager)) {
            throw DruidException.defensive((String)"Cannot run with fault tolerance since workerManager class[%s] does not support retrying", (Object[])new Object[]{this.workerManager.getClass().getName()});
        }
        long maxParseExceptions = MultiStageQueryContext.getMaxParseExceptions(queryContext);
        this.faultsExceededChecker = new FaultsExceededChecker((Map<String, Long>)ImmutableMap.of((Object)"CannotParseExternalData", (Object)maxParseExceptions));
        this.stageToStatsMergingMode = new HashMap<Integer, ClusterStatisticsMergeMode>();
        queryDef.getStageDefinitions().forEach(stageDefinition -> this.stageToStatsMergingMode.put(stageDefinition.getId().getStageNumber(), ControllerImpl.finalizeClusterStatisticsMergeMode(stageDefinition, MultiStageQueryContext.getClusterStatisticsMergeMode(queryContext))));
        return queryDef;
    }

    private void addToRetryQueue(ControllerQueryKernel kernel, int worker, MSQFault fault) {
        RetryCapableWorkerManager retryCapableWorkerManager = (RetryCapableWorkerManager)this.workerManager;
        List<WorkOrder> retriableWorkOrders = kernel.getWorkInCaseWorkerEligibleForRetryElseThrow(worker, fault);
        if (!retriableWorkOrders.isEmpty()) {
            log.info("Submitting worker[%s] for relaunch because of fault[%s]", new Object[]{worker, fault});
            retryCapableWorkerManager.submitForRelaunch(worker);
            this.workOrdersToRetry.compute(worker, (workerNumber, workOrders) -> {
                if (workOrders == null) {
                    return new HashSet(retriableWorkOrders);
                }
                workOrders.addAll(retriableWorkOrders);
                return workOrders;
            });
        } else {
            log.debug("Worker[%d] has no active workOrders that need relaunch therefore not relaunching", new Object[]{worker});
            retryCapableWorkerManager.reportFailedInactiveWorker(worker);
        }
    }

    @Override
    public void updatePartialKeyStatisticsInformation(int stageNumber, int workerNumber, Object partialKeyStatisticsInformationObject) {
        this.addToKernelManipulationQueue(queryKernel -> {
            PartialKeyStatisticsInformation partialKeyStatisticsInformation;
            StageId stageId = queryKernel.getStageId(stageNumber);
            if (queryKernel.isStageFinished(stageId)) {
                return;
            }
            try {
                partialKeyStatisticsInformation = (PartialKeyStatisticsInformation)this.context.jsonMapper().convertValue(partialKeyStatisticsInformationObject, PartialKeyStatisticsInformation.class);
            }
            catch (IllegalArgumentException e) {
                throw new IAE((Throwable)e, "Unable to deserialize the key statistic for stage [%s] received from the worker [%d]", new Object[]{stageId, workerNumber});
            }
            queryKernel.addPartialKeyStatisticsForStageAndWorker(stageId, workerNumber, partialKeyStatisticsInformation);
        });
    }

    @Override
    public void doneReadingInput(int stageNumber, int workerNumber) {
        this.addToKernelManipulationQueue(queryKernel -> {
            StageId stageId = queryKernel.getStageId(stageNumber);
            if (queryKernel.isStageFinished(stageId)) {
                return;
            }
            queryKernel.setDoneReadingInputForStageAndWorker(stageId, workerNumber);
        });
    }

    @Override
    public void workerError(MSQErrorReport errorReport) {
        RetryCapableWorkerManager retryCapableWorkerManager;
        if (this.queryKernelConfig.isFaultTolerant() && ((retryCapableWorkerManager = (RetryCapableWorkerManager)this.workerManager).isTaskCanceledByController(errorReport.getTaskId()) || !retryCapableWorkerManager.isWorkerActive(errorReport.getTaskId()))) {
            log.debug("Ignoring error report for worker[%s] because it was intentionally shut down.", new Object[]{errorReport.getTaskId()});
            return;
        }
        this.workerErrorRef.compareAndSet(null, this.mapQueryColumnNameToOutputColumnName(errorReport));
        this.addToKernelManipulationQueue(kernel -> {
            throw new MSQException(new WorkerFailedFault(errorReport.getTaskId(), null));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workerWarning(List<MSQErrorReport> errorReports) {
        long numReportsToAddCheck = Math.min((long)errorReports.size(), 10000L - (long)this.workerWarnings.size());
        if (numReportsToAddCheck > 0L) {
            ConcurrentLinkedQueue<MSQErrorReport> concurrentLinkedQueue = this.workerWarnings;
            synchronized (concurrentLinkedQueue) {
                long numReportsToAdd = Math.min((long)errorReports.size(), 10000L - (long)this.workerWarnings.size());
                int i = 0;
                while ((long)i < numReportsToAdd) {
                    this.workerWarnings.add(errorReports.get(i));
                    ++i;
                }
            }
        }
    }

    @Override
    public void updateCounters(String taskId, CounterSnapshotsTree snapshotsTree) {
        this.taskCountersForLiveReports.putAll(snapshotsTree);
        Optional<Pair<String, Long>> warningsExceeded = this.faultsExceededChecker.addFaultsAndCheckIfExceeded(this.taskCountersForLiveReports);
        if (warningsExceeded.isPresent()) {
            String errorCode = (String)warningsExceeded.get().lhs;
            Long limit = (Long)warningsExceeded.get().rhs;
            this.workerError(MSQErrorReport.fromFault(taskId, this.selfDruidNode.getHost(), null, new TooManyWarningsFault(limit.intValue(), errorCode)));
            this.addToKernelManipulationQueue(queryKernel -> queryKernel.getActiveStages().forEach(queryKernel::failStage));
        }
    }

    @Override
    public void resultsComplete(String queryId, int stageNumber, int workerNumber, Object resultObject) {
        this.addToKernelManipulationQueue(queryKernel -> {
            Object convertedResultObject;
            StageId stageId = new StageId(queryId, stageNumber);
            if (queryKernel.isStageFinished(stageId)) {
                return;
            }
            try {
                convertedResultObject = this.context.jsonMapper().convertValue(resultObject, queryKernel.getStageDefinition(stageId).getProcessorFactory().getResultTypeReference());
            }
            catch (IllegalArgumentException e) {
                throw new IAE((Throwable)e, "Unable to deserialize the result object for stage [%s] received from the worker [%d]", new Object[]{stageId, workerNumber});
            }
            queryKernel.setResultsCompleteForStageAndWorker(stageId, workerNumber, convertedResultObject);
        });
    }

    @Override
    @Nullable
    public TaskReport.ReportMap liveReports() {
        QueryDefinition queryDef = this.queryDefRef.get();
        if (queryDef == null) {
            return null;
        }
        return TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new MSQTaskReport(this.queryId(), new MSQTaskReportPayload(ControllerImpl.makeStatusReport(TaskState.RUNNING, null, this.workerWarnings, this.queryStartTime, this.queryStartTime == null ? -1L : new Interval((ReadableInstant)this.queryStartTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis(), this.workerManager, this.segmentLoadWaiter, this.segmentReport), ControllerImpl.makeStageReport(queryDef, this.stagePhasesForLiveReports, this.stageRuntimesForLiveReports, this.stageWorkerCountsForLiveReports, this.stagePartitionCountsForLiveReports, this.stageOutputChannelModesForLiveReports), this.makeCountersSnapshotForLiveReports(), null))});
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecs(DataSourceMSQDestination destination, RowSignature signature, ClusterBy clusterBy, ClusterByPartitions partitionBoundaries, boolean mayHaveMultiValuedClusterByFields, @Nullable Boolean isStageOutputEmpty) throws IOException {
        if (destination.isReplaceTimeChunks()) {
            return this.generateSegmentIdsWithShardSpecsForReplace(destination, signature, clusterBy, partitionBoundaries, mayHaveMultiValuedClusterByFields, isStageOutputEmpty);
        }
        RowKeyReader keyReader = clusterBy.keyReader((ColumnInspector)signature);
        return this.generateSegmentIdsWithShardSpecsForAppend(destination, partitionBoundaries, keyReader, this.context.taskLockType(), isStageOutputEmpty);
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecsForAppend(DataSourceMSQDestination destination, ClusterByPartitions partitionBoundaries, RowKeyReader keyReader, TaskLockType taskLockType, @Nullable Boolean isStageOutputEmpty) throws IOException {
        if (Boolean.TRUE.equals(isStageOutputEmpty)) {
            return Collections.emptyList();
        }
        ArrayList<SegmentIdWithShardSpec> retVal = new ArrayList<SegmentIdWithShardSpec>(partitionBoundaries.size());
        Granularity segmentGranularity = destination.getSegmentGranularity();
        if (this.querySpec.getTuningConfig().getMaxNumSegments() != null) {
            Map<DateTime, List<Pair<Integer, ClusterByPartition>>> partitionsByBucket = this.getPartitionsByBucket(partitionBoundaries, segmentGranularity, keyReader);
            this.validateNumSegmentsPerBucketOrThrow(partitionsByBucket, segmentGranularity);
        }
        String previousSegmentId = null;
        this.segmentReport = new MSQSegmentReport(NumberedShardSpec.class.getSimpleName(), "Using NumberedShardSpec to generate segments since the query is inserting rows.");
        for (ClusterByPartition partitionBoundary : partitionBoundaries) {
            SegmentIdWithShardSpec allocation;
            DateTime timestamp = ControllerImpl.getBucketDateTime(partitionBoundary, segmentGranularity, keyReader);
            try {
                allocation = (SegmentIdWithShardSpec)this.context.taskActionClient().submit((TaskAction)new SegmentAllocateAction(destination.getDataSource(), timestamp, segmentGranularity, segmentGranularity, this.queryId(), previousSegmentId, false, (PartialShardSpec)NumberedPartialShardSpec.instance(), LockGranularity.TIME_CHUNK, taskLockType));
            }
            catch (ISE e) {
                if (ControllerImpl.isTaskLockPreemptedException((Exception)((Object)e))) {
                    throw new MSQException(e, InsertLockPreemptedFault.instance());
                }
                throw e;
            }
            if (allocation == null) {
                throw new MSQException(new InsertCannotAllocateSegmentFault(destination.getDataSource(), segmentGranularity.bucket(timestamp), null));
            }
            if (!IntervalUtils.isAligned(allocation.getInterval(), segmentGranularity)) {
                throw new MSQException(new InsertCannotAllocateSegmentFault(destination.getDataSource(), segmentGranularity.bucket(timestamp), allocation.getInterval()));
            }
            retVal.add(allocation);
            previousSegmentId = allocation.asSegmentId().toString();
        }
        return retVal;
    }

    private Map<DateTime, List<Pair<Integer, ClusterByPartition>>> getPartitionsByBucket(ClusterByPartitions partitionBoundaries, Granularity segmentGranularity, RowKeyReader keyReader) {
        HashMap<DateTime, List<Pair<Integer, ClusterByPartition>>> partitionsByBucket = new HashMap<DateTime, List<Pair<Integer, ClusterByPartition>>>();
        for (int i = 0; i < partitionBoundaries.ranges().size(); ++i) {
            ClusterByPartition partitionBoundary = (ClusterByPartition)partitionBoundaries.ranges().get(i);
            DateTime bucketDateTime = ControllerImpl.getBucketDateTime(partitionBoundary, segmentGranularity, keyReader);
            partitionsByBucket.computeIfAbsent(bucketDateTime, ignored -> new ArrayList()).add(Pair.of((Object)i, (Object)partitionBoundary));
        }
        return partitionsByBucket;
    }

    private void validateNumSegmentsPerBucketOrThrow(Map<DateTime, List<Pair<Integer, ClusterByPartition>>> partitionsByBucket, Granularity segmentGranularity) {
        Integer maxNumSegments = this.querySpec.getTuningConfig().getMaxNumSegments();
        if (maxNumSegments == null) {
            return;
        }
        for (Map.Entry<DateTime, List<Pair<Integer, ClusterByPartition>>> bucketEntry : partitionsByBucket.entrySet()) {
            int numSegmentsInTimeChunk = bucketEntry.getValue().size();
            if (numSegmentsInTimeChunk <= maxNumSegments) continue;
            throw new MSQException(new TooManySegmentsInTimeChunkFault(bucketEntry.getKey(), numSegmentsInTimeChunk, maxNumSegments, segmentGranularity));
        }
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecsForReplace(DataSourceMSQDestination destination, RowSignature signature, ClusterBy clusterBy, ClusterByPartitions partitionBoundaries, boolean mayHaveMultiValuedClusterByFields, @Nullable Boolean isStageOutputEmpty) throws IOException {
        if (Boolean.TRUE.equals(isStageOutputEmpty)) {
            return Collections.emptyList();
        }
        RowKeyReader keyReader = clusterBy.keyReader((ColumnInspector)signature);
        SegmentIdWithShardSpec[] retVal = new SegmentIdWithShardSpec[partitionBoundaries.size()];
        Granularity segmentGranularity = destination.getSegmentGranularity();
        Pair<List<String>, String> shardReasonPair = ControllerImpl.computeShardColumns(signature, clusterBy, this.querySpec.getColumnMappings(), mayHaveMultiValuedClusterByFields);
        List shardColumns = (List)shardReasonPair.lhs;
        String commentary = (String)shardReasonPair.rhs;
        log.info("ShardSpec chosen: %s", new Object[]{commentary});
        this.segmentReport = shardColumns.isEmpty() ? new MSQSegmentReport(NumberedShardSpec.class.getSimpleName(), commentary) : new MSQSegmentReport(DimensionRangeShardSpec.class.getSimpleName(), commentary);
        Map<DateTime, List<Pair<Integer, ClusterByPartition>>> partitionsByBucket = this.getPartitionsByBucket(partitionBoundaries, segmentGranularity, keyReader);
        this.validateNumSegmentsPerBucketOrThrow(partitionsByBucket, segmentGranularity);
        for (Map.Entry<DateTime, List<Pair<Integer, ClusterByPartition>>> bucketEntry : partitionsByBucket.entrySet()) {
            Interval interval = segmentGranularity.bucket(bucketEntry.getKey());
            if (destination.getReplaceTimeChunks().stream().noneMatch(chunk -> chunk.contains((ReadableInterval)interval))) {
                throw new MSQException(new InsertTimeOutOfBoundsFault(interval, destination.getReplaceTimeChunks()));
            }
            List<Pair<Integer, ClusterByPartition>> ranges = bucketEntry.getValue();
            String version = null;
            List locks = (List)this.context.taskActionClient().submit((TaskAction)new LockListAction());
            for (TaskLock lock : locks) {
                if (!lock.getInterval().contains((ReadableInterval)interval)) continue;
                version = lock.getVersion();
            }
            if (version == null) {
                throw new MSQException(InsertLockPreemptedFault.INSTANCE);
            }
            for (int segmentNumber = 0; segmentNumber < ranges.size(); ++segmentNumber) {
                NumberedShardSpec shardSpec;
                int partitionNumber = (Integer)ranges.get((int)segmentNumber).lhs;
                if (shardColumns.isEmpty()) {
                    shardSpec = new NumberedShardSpec(segmentNumber, ranges.size());
                } else {
                    ClusterByPartition range = (ClusterByPartition)ranges.get((int)segmentNumber).rhs;
                    StringTuple start = segmentNumber == 0 ? null : ControllerImpl.makeStringTuple(clusterBy, keyReader, range.getStart(), shardColumns.size());
                    StringTuple end = segmentNumber == ranges.size() - 1 ? null : ControllerImpl.makeStringTuple(clusterBy, keyReader, range.getEnd(), shardColumns.size());
                    shardSpec = new DimensionRangeShardSpec(shardColumns, start, end, segmentNumber, Integer.valueOf(ranges.size()));
                }
                retVal[partitionNumber] = new SegmentIdWithShardSpec(destination.getDataSource(), interval, version, (ShardSpec)shardSpec);
            }
        }
        return Arrays.asList(retVal);
    }

    @Override
    public List<String> getWorkerIds() {
        if (this.workerManager == null) {
            return Collections.emptyList();
        }
        return this.workerManager.getWorkerIds();
    }

    @Override
    public boolean hasWorker(String workerId) {
        if (this.workerManager == null) {
            return false;
        }
        return this.workerManager.getWorkerNumber(workerId) != -1;
    }

    @Nullable
    private Int2ObjectMap<Object> makeWorkerFactoryInfosForStage(QueryDefinition queryDef, int stageNumber, WorkerInputs workerInputs, @Nullable List<SegmentIdWithShardSpec> segmentsToGenerate) {
        if (MSQControllerTask.isIngestion(this.querySpec) && stageNumber == queryDef.getFinalStageDefinition().getStageNumber()) {
            DataSourceMSQDestination destination = (DataSourceMSQDestination)this.querySpec.getDestination();
            TerminalStageSpec terminalStageSpec = destination.getTerminalStageSpec();
            if (destination.getTerminalStageSpec() instanceof SegmentGenerationStageSpec) {
                return ((SegmentGenerationStageSpec)terminalStageSpec).getWorkerInfo(workerInputs, segmentsToGenerate);
            }
        }
        return null;
    }

    private void contactWorkersForStage(ControllerQueryKernel queryKernel, IntSet workers, TaskContactFn contactFn, TaskContactSuccess successFn, boolean retryOnFailure) {
        List workersCopy = Ordering.natural().sortedCopy((Iterable)workers);
        List<String> workerIds = this.getWorkerIds();
        ArrayList<ListenableFuture<Void>> workerFutures = new ArrayList<ListenableFuture<Void>>(workersCopy.size());
        try {
            this.workerManager.waitForWorkers((Set<Integer>)workers);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        Iterator e = workersCopy.iterator();
        while (e.hasNext()) {
            int workerNumber = (Integer)e.next();
            workerFutures.add(contactFn.contactTask(this.netClient, workerIds.get(workerNumber), workerNumber));
        }
        List workerResults = (List)FutureUtils.getUnchecked((ListenableFuture)FutureUtils.coalesce(workerFutures), (boolean)true);
        for (int i = 0; i < workerResults.size(); ++i) {
            int workerNumber = (Integer)workersCopy.get(i);
            String workerId = workerIds.get(workerNumber);
            Either workerResult = (Either)workerResults.get(i);
            if (workerResult.isValue()) {
                successFn.onSuccess(workerId, workerNumber);
                continue;
            }
            if (retryOnFailure) {
                log.info((Throwable)workerResult.error(), "Detected failure while contacting task[%s]. Initiating relaunch of worker[%d] if applicable", new Object[]{workerId, workerNumber});
                this.addToRetryQueue(queryKernel, workerNumber, new WorkerRpcFailedFault(workerId, ((Throwable)workerResult.error()).toString()));
                continue;
            }
            throw new RuntimeException((Throwable)workerResult.error());
        }
    }

    private void startWorkForStage(QueryDefinition queryDef, ControllerQueryKernel queryKernel, int stageNumber, @Nullable List<SegmentIdWithShardSpec> segmentsToGenerate) {
        Int2ObjectMap<Object> extraInfos = this.makeWorkerFactoryInfosForStage(queryDef, stageNumber, queryKernel.getWorkerInputsForStage(queryKernel.getStageId(stageNumber)), segmentsToGenerate);
        Int2ObjectMap<WorkOrder> workOrders = queryKernel.createWorkOrders(stageNumber, extraInfos);
        StageId stageId = new StageId(queryDef.getQueryId(), stageNumber);
        queryKernel.startStage(stageId);
        this.contactWorkersForStage(queryKernel, workOrders.keySet(), (netClient, taskId, workerNumber) -> netClient.postWorkOrder(taskId, (WorkOrder)workOrders.get(workerNumber)), (workerId, workerNumber) -> queryKernel.workOrdersSentForWorker(stageId, workerNumber), this.queryKernelConfig.isFaultTolerant());
    }

    private void postResultPartitionBoundariesForStage(ControllerQueryKernel queryKernel, QueryDefinition queryDef, int stageNumber, ClusterByPartitions resultPartitionBoundaries, IntSet workers) {
        StageId stageId = new StageId(queryDef.getQueryId(), stageNumber);
        this.contactWorkersForStage(queryKernel, workers, (netClient, workerId, workerNumber) -> netClient.postResultPartitionBoundaries(workerId, stageId, resultPartitionBoundaries), (workerId, workerNumber) -> queryKernel.partitionBoundariesSentForWorker(stageId, workerNumber), this.queryKernelConfig.isFaultTolerant());
    }

    private void publishAllSegments(Set<DataSegment> segments, Function<Set<DataSegment>, Set<DataSegment>> compactionStateAnnotateFunction) throws IOException {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)this.querySpec.getDestination();
        HashSet<DataSegment> segmentsWithTombstones = new HashSet<DataSegment>(segments);
        int numTombstones = 0;
        TaskLockType taskLockType = this.context.taskLockType();
        if (destination.isReplaceTimeChunks()) {
            List<Interval> intervalsToDrop = this.findIntervalsToDrop((Set)Preconditions.checkNotNull(segments, (Object)"segments"));
            if (!intervalsToDrop.isEmpty()) {
                TombstoneHelper tombstoneHelper = new TombstoneHelper(this.context.taskActionClient());
                try {
                    Set tombstones = tombstoneHelper.computeTombstoneSegmentsForReplace(intervalsToDrop, destination.getReplaceTimeChunks(), destination.getDataSource(), destination.getSegmentGranularity(), 5000);
                    segmentsWithTombstones.addAll(tombstones);
                    numTombstones = tombstones.size();
                }
                catch (IllegalStateException e) {
                    throw new MSQException(e, InsertLockPreemptedFault.instance());
                }
                catch (TooManyBucketsException e) {
                    throw new MSQException(e, new TooManyBucketsFault(5000));
                }
            }
            if (segmentsWithTombstones.isEmpty()) {
                for (Interval interval : intervalsToDrop) {
                    this.context.taskActionClient().submit((TaskAction)new MarkSegmentsAsUnusedAction(destination.getDataSource(), interval));
                }
            } else {
                if (MultiStageQueryContext.shouldWaitForSegmentLoad(this.querySpec.getContext())) {
                    this.segmentLoadWaiter = new SegmentLoadStatusFetcher((BrokerClient)this.context.injector().getInstance(BrokerClient.class), this.context.jsonMapper(), this.queryId, destination.getDataSource(), segmentsWithTombstones, true);
                }
                ControllerImpl.performSegmentPublish(this.context.taskActionClient(), this.createOverwriteAction(taskLockType, compactionStateAnnotateFunction.apply(segmentsWithTombstones)));
            }
        } else if (!segments.isEmpty()) {
            if (MultiStageQueryContext.shouldWaitForSegmentLoad(this.querySpec.getContext())) {
                this.segmentLoadWaiter = new SegmentLoadStatusFetcher((BrokerClient)this.context.injector().getInstance(BrokerClient.class), this.context.jsonMapper(), this.queryId, destination.getDataSource(), segments, true);
            }
            ControllerImpl.performSegmentPublish(this.context.taskActionClient(), ControllerImpl.createAppendAction(segments, taskLockType));
        }
        this.context.emitMetric("ingest/tombstones/count", numTombstones);
        this.context.emitMetric("ingest/segments/count", segmentsWithTombstones.size());
    }

    private static TaskAction<SegmentPublishResult> createAppendAction(Set<DataSegment> segments, TaskLockType taskLockType) {
        if (taskLockType.equals((Object)TaskLockType.APPEND)) {
            return SegmentTransactionalAppendAction.forSegments(segments, null);
        }
        if (taskLockType.equals((Object)TaskLockType.SHARED)) {
            return SegmentTransactionalInsertAction.appendAction(segments, null, null, null);
        }
        throw DruidException.defensive((String)"Invalid lock type [%s] received for append action", (Object[])new Object[]{taskLockType});
    }

    private TaskAction<SegmentPublishResult> createOverwriteAction(TaskLockType taskLockType, Set<DataSegment> segmentsWithTombstones) {
        if (taskLockType.equals((Object)TaskLockType.REPLACE)) {
            return SegmentTransactionalReplaceAction.create(segmentsWithTombstones, null);
        }
        if (taskLockType.equals((Object)TaskLockType.EXCLUSIVE)) {
            return SegmentTransactionalInsertAction.overwriteAction(null, segmentsWithTombstones, null);
        }
        throw DruidException.defensive((String)"Invalid lock type [%s] received for overwrite action", (Object[])new Object[]{taskLockType});
    }

    private List<Interval> findIntervalsToDrop(Set<DataSegment> publishedSegments) {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)this.querySpec.getDestination();
        ArrayList<Interval> replaceIntervals = new ArrayList<Interval>(JodaUtils.condenseIntervals(destination.getReplaceTimeChunks()));
        List publishIntervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform(publishedSegments, DataSegment::getInterval));
        return IntervalUtils.difference(replaceIntervals, publishIntervals);
    }

    private CounterSnapshotsTree fetchCountersFromWorkers(IntSet workers) {
        CounterSnapshotsTree retVal = new CounterSnapshotsTree();
        List<String> taskList = this.getWorkerIds();
        ArrayList<ListenableFuture<CounterSnapshotsTree>> futures = new ArrayList<ListenableFuture<CounterSnapshotsTree>>();
        IntIterator intIterator = workers.iterator();
        while (intIterator.hasNext()) {
            int workerNumber = (Integer)intIterator.next();
            futures.add(this.netClient.getCounters(taskList.get(workerNumber)));
        }
        List snapshotsTrees = (List)FutureUtils.getUnchecked(MSQFutureUtils.allAsList(futures, true), (boolean)true);
        for (CounterSnapshotsTree snapshotsTree : snapshotsTrees) {
            retVal.putAll(snapshotsTree);
        }
        return retVal;
    }

    private void postFinishToWorkers(IntSet workers) {
        List<String> taskList = this.getWorkerIds();
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        IntIterator intIterator = workers.iterator();
        while (intIterator.hasNext()) {
            int workerNumber = (Integer)intIterator.next();
            futures.add(this.netClient.postFinish(taskList.get(workerNumber)));
        }
        FutureUtils.getUnchecked(MSQFutureUtils.allAsList(futures, true), (boolean)true);
    }

    private CounterSnapshotsTree makeCountersSnapshotForLiveReports() {
        return CounterSnapshotsTree.fromMap(this.taskCountersForLiveReports.copyMap());
    }

    private CounterSnapshotsTree getFinalCountersSnapshot(@Nullable ControllerQueryKernel queryKernel) {
        if (queryKernel != null && queryKernel.isSuccess()) {
            return this.fetchCountersFromWorkers(queryKernel.getAllParticipatingWorkers());
        }
        return this.makeCountersSnapshotForLiveReports();
    }

    private void handleQueryResults(QueryDefinition queryDef, ControllerQueryKernel queryKernel) throws IOException {
        if (!queryKernel.isSuccess()) {
            return;
        }
        if (MSQControllerTask.isIngestion(this.querySpec)) {
            StageId finalStageId = queryKernel.getStageId(queryDef.getFinalStageDefinition().getStageNumber());
            Function<Set<DataSegment>, Set<DataSegment>> compactionStateAnnotateFunction = Function.identity();
            Set segments = (Set)queryKernel.getResultObjectForStage(finalStageId);
            boolean storeCompactionState = this.querySpec.getContext().getBoolean("storeCompactionState", false);
            if (storeCompactionState) {
                DataSourceMSQDestination destination = (DataSourceMSQDestination)this.querySpec.getDestination();
                if (!destination.isReplaceTimeChunks()) {
                    log.warn("Ignoring storeCompactionState flag since it is set for a non-REPLACE query[%s].", new Object[]{queryDef.getQueryId()});
                } else {
                    DataSchema dataSchema = ((SegmentGeneratorFrameProcessorFactory)queryKernel.getStageDefinition(finalStageId).getProcessorFactory()).getDataSchema();
                    ShardSpec shardSpec = segments.isEmpty() ? null : ((DataSegment)segments.stream().findFirst().get()).getShardSpec();
                    ClusterBy clusterBy = queryKernel.getStageDefinition(finalStageId).getClusterBy();
                    compactionStateAnnotateFunction = ControllerImpl.addCompactionStateToSegments(this.querySpec, this.context.jsonMapper(), dataSchema, shardSpec, clusterBy, queryDef.getQueryId());
                }
            }
            log.info("Query [%s] publishing %d segments.", new Object[]{queryDef.getQueryId(), segments.size()});
            this.publishAllSegments(segments, compactionStateAnnotateFunction);
        } else if (MSQControllerTask.isExport(this.querySpec.getDestination())) {
            ExportMSQDestination destination = (ExportMSQDestination)this.querySpec.getDestination();
            ExportMetadataManager exportMetadataManager = new ExportMetadataManager(destination.getExportStorageProvider(), this.context.taskTempDir());
            StageId finalStageId = queryKernel.getStageId(queryDef.getFinalStageDefinition().getStageNumber());
            Object resultObjectForStage = queryKernel.getResultObjectForStage(finalStageId);
            if (!(resultObjectForStage instanceof List)) {
                log.warn("Unable to create export manifest file. Received result[%s] from worker instead of a list of file names.", new Object[]{resultObjectForStage});
                return;
            }
            List exportedFiles = (List)queryKernel.getResultObjectForStage(finalStageId);
            log.info("Query [%s] exported %d files.", new Object[]{queryDef.getQueryId(), exportedFiles.size()});
            exportMetadataManager.writeMetadata(exportedFiles);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Function<Set<DataSegment>, Set<DataSegment>> addCompactionStateToSegments(MSQSpec querySpec, ObjectMapper jsonMapper, DataSchema dataSchema, @Nullable ShardSpec shardSpec, @Nullable ClusterBy clusterBy, String queryId) {
        void var7_12;
        MSQTuningConfig tuningConfig = querySpec.getTuningConfig();
        if (shardSpec != null) {
            if (Objects.equals(shardSpec.getType(), "range")) {
                List partitionDimensions = ((DimensionRangeShardSpec)shardSpec).getDimensions();
                DimensionRangePartitionsSpec dimensionRangePartitionsSpec = new DimensionRangePartitionsSpec(null, Integer.valueOf(tuningConfig.getRowsPerSegment()), partitionDimensions, false);
            } else {
                if (!Objects.equals(shardSpec.getType(), "numbered")) throw new MSQException(UnknownFault.forMessage(StringUtils.format((String)"Query[%s] cannot store compaction state in segments as shard spec of unsupported type[%s].", (Object[])new Object[]{queryId, shardSpec.getType()})));
                DynamicPartitionsSpec dynamicPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(tuningConfig.getRowsPerSegment()), Long.valueOf(Long.MAX_VALUE));
            }
        } else if (clusterBy != null && !clusterBy.getColumns().isEmpty()) {
            DimensionRangePartitionsSpec dimensionRangePartitionsSpec = new DimensionRangePartitionsSpec(null, Integer.valueOf(tuningConfig.getRowsPerSegment()), clusterBy.getColumns().stream().map(KeyColumn::columnName).collect(Collectors.toList()), false);
        } else {
            DynamicPartitionsSpec dynamicPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(tuningConfig.getRowsPerSegment()), Long.valueOf(Long.MAX_VALUE));
        }
        Granularity segmentGranularity = ((DataSourceMSQDestination)querySpec.getDestination()).getSegmentGranularity();
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(segmentGranularity, querySpec.getContext().getGranularity("sqlInsertQueryGranularity", jsonMapper), Boolean.valueOf(dataSchema.getGranularitySpec().isRollup()), ((DataSourceMSQDestination)querySpec.getDestination()).getReplaceTimeChunks());
        DimensionsSpec dimensionsSpec = dataSchema.getDimensionsSpec();
        CompactionTransformSpec transformSpec = TransformSpec.NONE.equals((Object)dataSchema.getTransformSpec()) ? null : CompactionTransformSpec.of((TransformSpec)dataSchema.getTransformSpec());
        List metricsSpec = Collections.emptyList();
        if (querySpec.getQuery() instanceof GroupByQuery) {
            GroupByQuery groupByQuery = (GroupByQuery)querySpec.getQuery();
            Set aggregatorsInDataSchema = Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet());
            metricsSpec = groupByQuery.getAggregatorSpecs().stream().filter(aggregatorFactory -> aggregatorsInDataSchema.contains(aggregatorFactory.getName())).collect(Collectors.toList());
        }
        IndexSpec indexSpec = tuningConfig.getIndexSpec();
        log.info("Query[%s] storing compaction state in segments.", new Object[]{queryId});
        return CompactionState.addCompactionStateToSegments((PartitionsSpec)var7_12, (DimensionsSpec)dimensionsSpec, metricsSpec, (CompactionTransformSpec)transformSpec, (IndexSpec)indexSpec, (GranularitySpec)granularitySpec, (List)dataSchema.getProjections());
    }

    private void cleanUpDurableStorageIfNeeded() {
        if (this.queryKernelConfig != null && this.queryKernelConfig.isDurableStorage()) {
            String controllerDirName = DurableStorageUtils.getControllerDirectory((String)this.queryId());
            try {
                MSQTasks.makeStorageConnector(this.context.injector()).deleteRecursively(controllerDirName);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Error while cleaning up temporary files at path[%s]. Skipping.", new Object[]{controllerDirName});
            }
        }
    }

    private static String getDataSourceForIngestion(MSQSpec querySpec) {
        return ((DataSourceMSQDestination)querySpec.getDestination()).getDataSource();
    }

    private static Pair<List<String>, String> computeShardColumns(RowSignature signature, ClusterBy clusterBy, ColumnMappings columnMappings, boolean mayHaveMultiValuedClusterByFields) {
        if (mayHaveMultiValuedClusterByFields) {
            return Pair.of(Collections.emptyList(), (Object)"Cannot use 'range' shard specs since CLUSTERED BY contains multi-valued fields.");
        }
        List clusterByColumns = clusterBy.getColumns();
        ArrayList<String> shardColumns = new ArrayList<String>();
        boolean boosted = ControllerImpl.isClusterByBoosted(clusterBy);
        int numShardColumns = clusterByColumns.size() - clusterBy.getBucketByCount() - (boosted ? 1 : 0);
        if (numShardColumns == 0) {
            return Pair.of(Collections.emptyList(), (Object)"CLUSTERED BY clause is empty.");
        }
        for (int i = clusterBy.getBucketByCount(); i < clusterBy.getBucketByCount() + numShardColumns; ++i) {
            KeyColumn column = (KeyColumn)clusterByColumns.get(i);
            IntList outputColumns = columnMappings.getOutputColumnsForQueryColumn(column.columnName());
            if (column.order() != KeyOrder.ASCENDING) {
                return Pair.of(shardColumns, (Object)StringUtils.format((String)"Using[%d] CLUSTERED BY columns for 'range' shard specs, since the next column has order[%s].", (Object[])new Object[]{shardColumns.size(), column.order()}));
            }
            ColumnType columnType = signature.getColumnType(column.columnName()).orElse(null);
            if (!ColumnType.STRING.equals((Object)columnType)) {
                return Pair.of(shardColumns, (Object)StringUtils.format((String)"Using[%d] CLUSTERED BY columns for 'range' shard specs, since the next column is of type[%s]. Only string columns are included in 'range' shard specs.", (Object[])new Object[]{shardColumns.size(), columnType}));
            }
            if (outputColumns.isEmpty()) {
                return Pair.of(shardColumns, (Object)StringUtils.format((String)"Using only[%d] CLUSTERED BY columns for 'range' shard specs, since the next column was not mapped to an output column.", (Object[])new Object[]{shardColumns.size()}));
            }
            shardColumns.add(columnMappings.getOutputColumnName(outputColumns.getInt(0)));
        }
        return Pair.of(shardColumns, (Object)"Using 'range' shard specs with all CLUSTERED BY fields.");
    }

    private static boolean isClusterByBoosted(ClusterBy clusterBy) {
        return !clusterBy.getColumns().isEmpty() && ((KeyColumn)clusterBy.getColumns().get(clusterBy.getColumns().size() - 1)).columnName().equals("__boost");
    }

    private static StringTuple makeStringTuple(ClusterBy clusterBy, RowKeyReader keyReader, RowKey key, int shardFieldCount) {
        String[] array = new String[clusterBy.getColumns().size() - clusterBy.getBucketByCount()];
        for (int i = 0; i < shardFieldCount; ++i) {
            Object val = keyReader.read(key, clusterBy.getBucketByCount() + i);
            array[i] = (String)val;
        }
        return new StringTuple(array);
    }

    private static DateTime getBucketDateTime(ClusterByPartition partitionBoundary, Granularity segmentGranularity, RowKeyReader keyReader) {
        if (Granularities.ALL.equals(segmentGranularity)) {
            return DateTimes.utc((long)0L);
        }
        RowKey startKey = partitionBoundary.getStart();
        DateTime timestamp = DateTimes.utc((long)MSQTasks.primaryTimestampFromObjectForInsert(keyReader.read(startKey, 0)));
        if (segmentGranularity.bucketStart(timestamp.getMillis()) != timestamp.getMillis()) {
            throw new ISE("Received boundary value [%s] misaligned with segmentGranularity [%s]", new Object[]{timestamp, segmentGranularity});
        }
        return timestamp;
    }

    private static MSQStagesReport makeStageReport(QueryDefinition queryDef, Map<Integer, ControllerStagePhase> stagePhaseMap, Map<Integer, Interval> stageRuntimeMap, Map<Integer, Integer> stageWorkerCountMap, Map<Integer, Integer> stagePartitionCountMap, Map<Integer, OutputChannelMode> stageOutputChannelModeMap) {
        return MSQStagesReport.create(queryDef, (Map<Integer, ControllerStagePhase>)ImmutableMap.copyOf(stagePhaseMap), ControllerImpl.copyOfStageRuntimesEndingAtCurrentTime(stageRuntimeMap), stageWorkerCountMap, stagePartitionCountMap, stageOutputChannelModeMap);
    }

    private static MSQStatusReport makeStatusReport(TaskState taskState, @Nullable MSQErrorReport errorReport, Queue<MSQErrorReport> errorReports, @Nullable DateTime queryStartTime, long queryDuration, WorkerManager taskLauncher, SegmentLoadStatusFetcher segmentLoadWaiter, @Nullable MSQSegmentReport msqSegmentReport) {
        int pendingTasks = -1;
        int runningTasks = 1;
        Map<Integer, List<WorkerStats>> workerStatsMap = new HashMap<Integer, List<WorkerStats>>();
        if (taskLauncher != null) {
            WorkerCount workerTaskCount = taskLauncher.getWorkerCount();
            pendingTasks = workerTaskCount.getPendingWorkerCount();
            runningTasks = workerTaskCount.getRunningWorkerCount() + 1;
            workerStatsMap = taskLauncher.getWorkerStats();
        }
        SegmentLoadStatusFetcher.SegmentLoadWaiterStatus status = segmentLoadWaiter == null ? null : segmentLoadWaiter.status();
        return new MSQStatusReport(taskState, errorReport, errorReports, queryStartTime, queryDuration, workerStatsMap, pendingTasks, runningTasks, status, msqSegmentReport);
    }

    private static InputSpecSlicerFactory makeInputSpecSlicerFactory(InputSpecSlicer tableInputSpecSlicer) {
        return (stagePartitionsMap, stageOutputChannelModeMap) -> new MapInputSpecSlicer((Map<Class<? extends InputSpec>, InputSpecSlicer>)ImmutableMap.builder().put(StageInputSpec.class, (Object)new StageInputSpecSlicer((Int2ObjectMap<ReadablePartitions>)stagePartitionsMap, (Int2ObjectMap<OutputChannelMode>)stageOutputChannelModeMap)).put(ExternalInputSpec.class, (Object)new ExternalInputSpecSlicer()).put(InlineInputSpec.class, (Object)new InlineInputSpecSlicer()).put(LookupInputSpec.class, (Object)new LookupInputSpecSlicer()).put(TableInputSpec.class, (Object)tableInputSpecSlicer).build());
    }

    private static Map<Integer, Interval> copyOfStageRuntimesEndingAtCurrentTime(Map<Integer, Interval> stageRuntimesMap) {
        Int2ObjectOpenHashMap retVal = new Int2ObjectOpenHashMap(stageRuntimesMap.size());
        DateTime now = DateTimes.nowUtc();
        for (Map.Entry<Integer, Interval> entry : stageRuntimesMap.entrySet()) {
            int stageNumber = entry.getKey();
            Interval interval = entry.getValue();
            retVal.put(stageNumber, (Object)(interval.getEnd().equals((Object)DateTimes.MAX) ? new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)now) : interval));
        }
        return retVal;
    }

    static void performSegmentPublish(TaskActionClient client, TaskAction<SegmentPublishResult> action) throws IOException {
        try {
            SegmentPublishResult result = (SegmentPublishResult)client.submit(action);
            if (!result.isSuccess()) {
                throw new MSQException(InsertLockPreemptedFault.instance());
            }
        }
        catch (Exception e) {
            if (ControllerImpl.isTaskLockPreemptedException(e)) {
                throw new MSQException(e, InsertLockPreemptedFault.instance());
            }
            throw e;
        }
    }

    private static boolean isTaskLockPreemptedException(Exception e) {
        String exceptionMsg = e.getMessage();
        if (exceptionMsg == null) {
            return false;
        }
        ImmutableList validExceptionExcerpts = ImmutableList.of((Object)"are not covered by locks", (Object)"is preempted and no longer valid");
        return validExceptionExcerpts.stream().anyMatch(exceptionMsg::contains);
    }

    private static void logKernelStatus(String queryId, ControllerQueryKernel queryKernel) {
        if (log.isDebugEnabled()) {
            log.debug("Query [%s] kernel state: %s", new Object[]{queryId, queryKernel.getActiveStages().stream().sorted(Comparator.comparing(id -> queryKernel.getStageDefinition((StageId)id).getStageNumber())).map(id -> StringUtils.format((String)"%d:%d[%s:%s]>%s", (Object[])new Object[]{queryKernel.getStageDefinition((StageId)id).getStageNumber(), queryKernel.getWorkerInputsForStage((StageId)id).workerCount(), queryKernel.getStageDefinition((StageId)id).doesShuffle() ? "SHUFFLE" : "RETAIN", queryKernel.getStagePhase((StageId)id), queryKernel.doesStageHaveResultPartitions((StageId)id) ? Integer.valueOf(Iterators.size(queryKernel.getResultPartitionsForStage((StageId)id).iterator())) : "?"})).collect(Collectors.joining("; "))});
        }
    }

    private static FrameProcessorExecutor createResultReaderExec(String queryId) {
        return new FrameProcessorExecutor(MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)StringUtils.encodeForFormat((String)("msq-result-reader[" + queryId + "]")))));
    }

    private static void closeResultReaderExec(FrameProcessorExecutor exec) {
        try {
            exec.cancel(RESULT_READER_CANCELLATION_ID);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            exec.shutdownNow();
        }
    }

    private void stopExternalFetchers() {
        if (this.workerSketchFetcher != null) {
            this.workerSketchFetcher.close();
        }
        if (this.segmentLoadWaiter != null) {
            this.segmentLoadWaiter.close();
        }
    }

    static ClusterStatisticsMergeMode finalizeClusterStatisticsMergeMode(StageDefinition stageDef, ClusterStatisticsMergeMode initialMode) {
        ClusterStatisticsMergeMode mergeMode = initialMode;
        if (initialMode == ClusterStatisticsMergeMode.AUTO) {
            ClusterBy clusterBy = stageDef.getClusterBy();
            mergeMode = clusterBy.getBucketByCount() == 0 ? ClusterStatisticsMergeMode.PARALLEL : ((long)stageDef.getMaxWorkerCount() > 100L ? ClusterStatisticsMergeMode.SEQUENTIAL : ClusterStatisticsMergeMode.PARALLEL);
            log.info("Stage [%d] AUTO mode: chose %s mode to merge key statistics", new Object[]{stageDef.getStageNumber(), mergeMode});
        }
        return mergeMode;
    }

    @Nullable
    private MSQErrorReport mapQueryColumnNameToOutputColumnName(@Nullable MSQErrorReport workerErrorReport) {
        if (workerErrorReport == null) {
            return null;
        }
        if (workerErrorReport.getFault() instanceof InvalidNullByteFault) {
            InvalidNullByteFault inbf = (InvalidNullByteFault)workerErrorReport.getFault();
            return MSQErrorReport.fromException(workerErrorReport.getTaskId(), workerErrorReport.getHost(), workerErrorReport.getStageNumber(), (Throwable)InvalidNullByteException.builder().source(inbf.getSource()).rowNumber(inbf.getRowNumber()).column(inbf.getColumn()).value(inbf.getValue()).position(inbf.getPosition()).build(), this.querySpec.getColumnMappings());
        }
        if (workerErrorReport.getFault() instanceof InvalidFieldFault) {
            InvalidFieldFault iff = (InvalidFieldFault)workerErrorReport.getFault();
            return MSQErrorReport.fromException(workerErrorReport.getTaskId(), workerErrorReport.getHost(), workerErrorReport.getStageNumber(), (Throwable)InvalidFieldException.builder().source(iff.getSource()).rowNumber(iff.getRowNumber()).column(iff.getColumn()).errorMsg(iff.getErrorMsg()).build(), this.querySpec.getColumnMappings());
        }
        return workerErrorReport;
    }

    private class RunQueryUntilDone {
        private final QueryDefinition queryDef;
        private final InputSpecSlicerFactory inputSpecSlicerFactory;
        private final QueryListener queryListener;
        private final Closer closer;
        private final ControllerQueryKernel queryKernel;
        private ListenableFuture<?> workerTaskLauncherFuture;
        private List<SegmentIdWithShardSpec> segmentsToGenerate;
        @Nullable
        private ListenableFuture<Void> queryResultsReaderFuture;

        public RunQueryUntilDone(QueryDefinition queryDef, ControllerQueryKernelConfig queryKernelConfig, InputSpecSlicerFactory inputSpecSlicerFactory, QueryListener queryListener, Closer closer) {
            this.queryDef = queryDef;
            this.inputSpecSlicerFactory = inputSpecSlicerFactory;
            this.queryListener = queryListener;
            this.closer = closer;
            this.queryKernel = new ControllerQueryKernel(queryDef, queryKernelConfig);
        }

        private Pair<ControllerQueryKernel, ListenableFuture<?>> run() throws IOException, InterruptedException {
            this.startTaskLauncher();
            while (!this.queryKernel.isDone()) {
                this.startStages();
                this.fetchStatsFromWorkers();
                this.sendPartitionBoundaries();
                this.updateLiveReportMaps();
                this.readQueryResults();
                boolean runAgain = this.cleanUpEffectivelyFinishedStages();
                this.retryFailedTasks();
                this.checkForErrorsInSketchFetcher();
                if (runAgain) continue;
                this.runKernelCommands();
            }
            if (!this.queryKernel.isSuccess()) {
                this.throwKernelExceptionIfNotUnknown();
            }
            this.updateLiveReportMaps();
            this.cleanUpEffectivelyFinishedStages();
            return Pair.of((Object)this.queryKernel, this.workerTaskLauncherFuture);
        }

        private void checkForErrorsInSketchFetcher() {
            Throwable throwable = ControllerImpl.this.workerSketchFetcher.getError();
            if (throwable != null) {
                throw new ISE(throwable, "worker sketch fetch failed", new Object[0]);
            }
        }

        private void readQueryResults() {
            if (this.queryListener.readResults() && this.queryKernel.canReadQueryResults() && this.queryResultsReaderFuture == null) {
                this.startQueryResultsReader();
            }
        }

        private void retryFailedTasks() throws InterruptedException {
            if (ControllerImpl.this.workOrdersToRetry.isEmpty()) {
                return;
            }
            HashSet<Integer> workersNeedToBeFullyStarted = new HashSet<Integer>();
            HashMap<StageId, Map> stageWorkerOrders = new HashMap<StageId, Map>();
            for (Map.Entry<Integer, Set<WorkOrder>> entry : ControllerImpl.this.workOrdersToRetry.entrySet()) {
                workersNeedToBeFullyStarted.add(entry.getKey());
                for (WorkOrder workOrder : entry.getValue()) {
                    stageWorkerOrders.compute(new StageId(this.queryDef.getQueryId(), workOrder.getStageNumber()), (stageId, workOrders) -> {
                        if (workOrders == null) {
                            workOrders = new HashMap<Integer, WorkOrder>();
                        }
                        workOrders.put((Integer)workerStages.getKey(), workOrder);
                        return workOrders;
                    });
                }
            }
            ControllerImpl.this.workerManager.waitForWorkers(workersNeedToBeFullyStarted);
            for (Map.Entry<Integer, Set<WorkOrder>> entry : stageWorkerOrders.entrySet()) {
                ControllerImpl.this.contactWorkersForStage(this.queryKernel, (IntSet)new IntArraySet(((Map)((Object)entry.getValue())).keySet()), (netClient, workerId, workerNumber) -> netClient.postWorkOrder(workerId, (WorkOrder)((Map)stageWorkOrders.getValue()).get(workerNumber)), (workerId, workerNumber) -> {
                    this.queryKernel.workOrdersSentForWorker((StageId)stageWorkOrders.getKey(), workerNumber);
                    ControllerImpl.this.workOrdersToRetry.compute(workerNumber, (task, workOrderSet) -> {
                        if (workOrderSet == null || workOrderSet.size() == 0 || !workOrderSet.remove(((Map)stageWorkOrders.getValue()).get(workerNumber))) {
                            throw new ISE("Worker[%s] with number[%d] orders not found", new Object[]{workerId, workerNumber});
                        }
                        if (workOrderSet.size() == 0) {
                            return null;
                        }
                        return workOrderSet;
                    });
                }, ControllerImpl.this.queryKernelConfig.isFaultTolerant());
            }
        }

        private void runKernelCommands() throws InterruptedException {
            if (!this.queryKernel.isDone()) {
                Consumer command = ControllerImpl.this.kernelManipulationQueue.take();
                command.accept((ControllerQueryKernel)this.queryKernel);
                while ((command = (Consumer)ControllerImpl.this.kernelManipulationQueue.poll()) != null) {
                    command.accept(this.queryKernel);
                }
            }
        }

        private void startTaskLauncher() {
            log.debug("Query [%s] starting task launcher.", new Object[]{this.queryDef.getQueryId()});
            this.workerTaskLauncherFuture = ControllerImpl.this.workerManager.start();
            this.closer.register(() -> ControllerImpl.this.workerManager.stop(true));
            this.workerTaskLauncherFuture.addListener(() -> ControllerImpl.this.addToKernelManipulationQueue(queryKernel -> FutureUtils.getUncheckedImmediately(this.workerTaskLauncherFuture)), (Executor)Execs.directExecutor());
        }

        private void fetchStatsFromWorkers() {
            block4: for (Map.Entry<StageId, Set<Integer>> stageToWorker : this.queryKernel.getStagesAndWorkersToFetchClusterStats().entrySet()) {
                List<String> allTasks = ControllerImpl.this.workerManager.getWorkerIds();
                Set<String> tasks = stageToWorker.getValue().stream().map(allTasks::get).collect(Collectors.toSet());
                ClusterStatisticsMergeMode clusterStatisticsMergeMode = ControllerImpl.this.stageToStatsMergingMode.get(stageToWorker.getKey().getStageNumber());
                switch (clusterStatisticsMergeMode) {
                    case SEQUENTIAL: {
                        this.submitSequentialMergeFetchRequests(stageToWorker.getKey(), tasks);
                        continue block4;
                    }
                    case PARALLEL: {
                        this.submitParallelMergeRequests(stageToWorker.getKey(), tasks);
                        continue block4;
                    }
                }
                throw new IllegalStateException("No fetching strategy found for mode: " + String.valueOf((Object)clusterStatisticsMergeMode));
            }
        }

        private void submitParallelMergeRequests(StageId stageId, Set<String> tasks) {
            this.queryKernel.startFetchingStatsFromWorker(stageId, tasks.stream().map(ControllerImpl.this.workerManager::getWorkerNumber).collect(Collectors.toSet()));
            ControllerImpl.this.workerSketchFetcher.inMemoryFullSketchMerging(ControllerImpl.this::addToKernelManipulationQueue, stageId, tasks, (TriConsumer<ControllerQueryKernel, Integer, MSQFault>)((TriConsumer)(x$0, x$1, x$2) -> ControllerImpl.this.addToRetryQueue((ControllerQueryKernel)x$0, (int)x$1, (MSQFault)x$2)));
        }

        private void submitSequentialMergeFetchRequests(StageId stageId, Set<String> tasks) {
            if (this.queryKernel.allPartialKeyInformationPresent(stageId)) {
                this.queryKernel.startFetchingStatsFromWorker(stageId, tasks.stream().map(ControllerImpl.this.workerManager::getWorkerNumber).collect(Collectors.toSet()));
                ControllerImpl.this.workerSketchFetcher.sequentialTimeChunkMerging(ControllerImpl.this::addToKernelManipulationQueue, this.queryKernel.getCompleteKeyStatisticsInformation(stageId), stageId, tasks, (TriConsumer<ControllerQueryKernel, Integer, MSQFault>)((TriConsumer)(x$0, x$1, x$2) -> ControllerImpl.this.addToRetryQueue((ControllerQueryKernel)x$0, (int)x$1, (MSQFault)x$2)));
            }
        }

        private void startStages() throws IOException, InterruptedException {
            List<StageId> newStageIds;
            long maxInputBytesPerWorker = MultiStageQueryContext.getMaxInputBytesPerWorker(ControllerImpl.this.querySpec.getContext());
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            do {
                newStageIds = this.queryKernel.createAndGetNewStageIds(this.inputSpecSlicerFactory, ControllerImpl.this.querySpec.getAssignmentStrategy(), maxInputBytesPerWorker);
                for (StageId stageId : newStageIds) {
                    if (MSQControllerTask.isIngestion(ControllerImpl.this.querySpec) && stageId.getStageNumber() == this.queryDef.getFinalStageDefinition().getStageNumber() && ((DataSourceMSQDestination)ControllerImpl.this.querySpec.getDestination()).getTerminalStageSpec() instanceof SegmentGenerationStageSpec) {
                        this.populateSegmentsToGenerate();
                    }
                    int workerCount = this.queryKernel.getWorkerInputsForStage(stageId).workerCount();
                    StageDefinition stageDef = this.queryKernel.getStageDefinition(stageId);
                    log.info("Query [%s] using workers[%d] for stage[%d], writing to[%s], shuffle[%s].", new Object[]{stageId.getQueryId(), workerCount, stageId.getStageNumber(), this.queryKernel.getStageOutputChannelMode(stageId), stageDef.doesShuffle() ? stageDef.getShuffleSpec().kind() : "none"});
                    ControllerImpl.this.workerManager.launchWorkersIfNeeded(workerCount);
                    ControllerImpl.this.stageRuntimesForLiveReports.put(stageId.getStageNumber(), new Interval((ReadableInstant)DateTimes.nowUtc(), (ReadableInstant)DateTimes.MAX));
                    ControllerImpl.this.startWorkForStage(this.queryDef, this.queryKernel, stageId.getStageNumber(), this.segmentsToGenerate);
                }
            } while (!newStageIds.isEmpty());
        }

        private void populateSegmentsToGenerate() throws IOException {
            int shuffleStageNumber = (Integer)Iterables.getOnlyElement((Iterable)this.queryDef.getFinalStageDefinition().getInputStageNumbers());
            while (!this.queryDef.getStageDefinition(shuffleStageNumber).doesShuffle()) {
                shuffleStageNumber = (Integer)Iterables.getOnlyElement((Iterable)this.queryDef.getStageDefinition(shuffleStageNumber).getInputStageNumbers());
            }
            StageId shuffleStageId = new StageId(this.queryDef.getQueryId(), shuffleStageNumber);
            boolean isFailOnEmptyInsertEnabled = MultiStageQueryContext.isFailOnEmptyInsertEnabled(ControllerImpl.this.querySpec.getContext());
            Boolean isShuffleStageOutputEmpty = this.queryKernel.isStageOutputEmpty(shuffleStageId);
            if (isFailOnEmptyInsertEnabled && Boolean.TRUE.equals(isShuffleStageOutputEmpty)) {
                throw new MSQException(new InsertCannotBeEmptyFault(ControllerImpl.getDataSourceForIngestion(ControllerImpl.this.querySpec)));
            }
            ClusterByPartitions partitionBoundaries = this.queryKernel.getResultPartitionBoundariesForStage(shuffleStageId);
            boolean mayHaveMultiValuedClusterByFields = !this.queryKernel.getStageDefinition(shuffleStageId).mustGatherResultKeyStatistics() || this.queryKernel.hasStageCollectorEncounteredAnyMultiValueField(shuffleStageId);
            this.segmentsToGenerate = ControllerImpl.this.generateSegmentIdsWithShardSpecs((DataSourceMSQDestination)ControllerImpl.this.querySpec.getDestination(), this.queryKernel.getStageDefinition(shuffleStageId).getSignature(), this.queryKernel.getStageDefinition(shuffleStageId).getClusterBy(), partitionBoundaries, mayHaveMultiValuedClusterByFields, isShuffleStageOutputEmpty);
            log.info("Query [%s] generating %d segments.", new Object[]{this.queryDef.getQueryId(), partitionBoundaries.size()});
        }

        private void sendPartitionBoundaries() {
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                if (!this.queryKernel.getStageDefinition(stageId).mustGatherResultKeyStatistics() || !this.queryKernel.doesStageHaveResultPartitions(stageId)) continue;
                IntSet workersToSendPartitionBoundaries = this.queryKernel.getWorkersToSendPartitionBoundaries(stageId);
                if (workersToSendPartitionBoundaries.isEmpty()) {
                    log.debug("No workers for stage[%s] ready to receive partition boundaries", new Object[]{stageId});
                    continue;
                }
                ClusterByPartitions partitions = this.queryKernel.getResultPartitionBoundariesForStage(stageId);
                if (log.isDebugEnabled()) {
                    log.debug("Query [%s] sending out partition boundaries for stage %d: %s for workers %s", new Object[]{stageId.getQueryId(), stageId.getStageNumber(), IntStream.range(0, partitions.size()).mapToObj(i -> StringUtils.format((String)"%s:%s", (Object[])new Object[]{i, partitions.get(i)})).collect(Collectors.joining(", ")), workersToSendPartitionBoundaries.toString()});
                } else {
                    log.info("Query [%s] sending out partition boundaries for stage %d for workers %s", new Object[]{stageId.getQueryId(), stageId.getStageNumber(), workersToSendPartitionBoundaries.toString()});
                }
                ControllerImpl.this.postResultPartitionBoundariesForStage(this.queryKernel, this.queryDef, stageId.getStageNumber(), partitions, workersToSendPartitionBoundaries);
            }
        }

        private void updateLiveReportMaps() {
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                int stageNumber = stageId.getStageNumber();
                ControllerImpl.this.stagePhasesForLiveReports.put(stageNumber, this.queryKernel.getStagePhase(stageId));
                if (this.queryKernel.doesStageHaveResultPartitions(stageId)) {
                    ControllerImpl.this.stagePartitionCountsForLiveReports.computeIfAbsent(stageNumber, k -> Iterators.size(this.queryKernel.getResultPartitionsForStage(stageId).iterator()));
                }
                ControllerImpl.this.stageWorkerCountsForLiveReports.computeIfAbsent(stageNumber, k -> this.queryKernel.getWorkerInputsForStage(stageId).workerCount());
                ControllerImpl.this.stageOutputChannelModesForLiveReports.computeIfAbsent(stageNumber, k -> this.queryKernel.getStageOutputChannelMode(stageId));
            }
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                if (!this.queryKernel.getStagePhase(stageId).isSuccess()) continue;
                ControllerImpl.this.stageRuntimesForLiveReports.compute(this.queryKernel.getStageDefinition(stageId).getStageNumber(), (k, currentValue) -> {
                    if (currentValue.getEnd().equals((Object)DateTimes.MAX)) {
                        return new Interval((ReadableInstant)currentValue.getStart(), (ReadableInstant)DateTimes.nowUtc());
                    }
                    return currentValue;
                });
            }
        }

        private boolean cleanUpEffectivelyFinishedStages() {
            StageId finalStageId = this.queryDef.getFinalStageDefinition().getId();
            boolean didSomething = false;
            for (StageId stageId : this.queryKernel.getEffectivelyFinishedStageIds()) {
                if (finalStageId.equals(stageId) && this.queryListener.readResults() && (this.queryResultsReaderFuture == null || !this.queryResultsReaderFuture.isDone())) continue;
                log.info("Query [%s] issuing cleanup order for stage %d.", new Object[]{this.queryDef.getQueryId(), stageId.getStageNumber()});
                ControllerImpl.this.contactWorkersForStage(this.queryKernel, (IntSet)this.queryKernel.getWorkerInputsForStage(stageId).workers(), (netClient, workerId, workerNumber) -> netClient.postCleanupStage(workerId, stageId), (workerId, workerNumber) -> {}, false);
                this.queryKernel.finishStage(stageId, true);
                didSomething = true;
            }
            return didSomething;
        }

        private void startQueryResultsReader() {
            if (this.queryResultsReaderFuture != null) {
                throw new ISE("Already started", new Object[0]);
            }
            StageId finalStageId = this.queryKernel.getStageId(this.queryDef.getFinalStageDefinition().getStageNumber());
            List<String> taskIds = ControllerImpl.this.getWorkerIds();
            InputChannelFactory inputChannelFactory = ControllerImpl.this.queryKernelConfig.isDurableStorage() || MSQControllerTask.writeFinalStageResultsToDurableStorage(ControllerImpl.this.querySpec.getDestination()) ? DurableStorageInputChannelFactory.createStandardImplementation(ControllerImpl.this.queryId(), MSQTasks.makeStorageConnector(ControllerImpl.this.context.injector()), this.closer, MSQControllerTask.writeFinalStageResultsToDurableStorage(ControllerImpl.this.querySpec.getDestination())) : new WorkerInputChannelFactory(ControllerImpl.this.netClient, () -> taskIds);
            FrameProcessorExecutor resultReaderExec = ControllerImpl.createResultReaderExec(ControllerImpl.this.queryId());
            resultReaderExec.registerCancellationId(ControllerImpl.RESULT_READER_CANCELLATION_ID);
            ReadableConcatFrameChannel resultsChannel = null;
            try {
                InputChannelsImpl inputChannels = new InputChannelsImpl(this.queryDef, this.queryKernel.getResultPartitionsForStage(finalStageId), inputChannelFactory, () -> ArenaMemoryAllocator.createOnHeap((int)5000000), resultReaderExec, ControllerImpl.RESULT_READER_CANCELLATION_ID, null, MultiStageQueryContext.removeNullBytes(ControllerImpl.this.querySpec.getContext()));
                resultsChannel = ReadableConcatFrameChannel.open(StreamSupport.stream(this.queryKernel.getResultPartitionsForStage(finalStageId).spliterator(), false).map(readablePartition -> {
                    try {
                        return inputChannels.openChannel(new StagePartition(this.queryKernel.getStageDefinition(finalStageId).getId(), readablePartition.getPartitionNumber()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).iterator());
                ControllerQueryResultsReader resultsReader = new ControllerQueryResultsReader((ReadableFrameChannel)resultsChannel, this.queryDef.getFinalStageDefinition().getFrameReader(), ControllerImpl.this.querySpec.getColumnMappings(), ControllerImpl.this.resultsContext, ControllerImpl.this.context.jsonMapper(), this.queryListener);
                this.queryResultsReaderFuture = resultReaderExec.runFully((FrameProcessor)resultsReader, ControllerImpl.RESULT_READER_CANCELLATION_ID);
                this.queryResultsReaderFuture.addListener(() -> ControllerImpl.this.addToKernelManipulationQueue(holder -> {}), (Executor)Execs.directExecutor());
            }
            catch (Throwable e) {
                ReadableConcatFrameChannel finalResultsChannel = resultsChannel;
                throw CloseableUtils.closeAndWrapInCatch((Throwable)e, () -> CloseableUtils.closeAll((Closeable)finalResultsChannel, (Closeable[])new Closeable[]{() -> ControllerImpl.closeResultReaderExec(resultReaderExec)}));
            }
            this.closer.register(() -> ControllerImpl.closeResultReaderExec(resultReaderExec));
        }

        private void throwKernelExceptionIfNotUnknown() {
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                MSQFault fault;
                if (this.queryKernel.getStagePhase(stageId) != ControllerStagePhase.FAILED || "UnknownError".equals((fault = this.queryKernel.getFailureReasonForStage(stageId)).getErrorCode())) continue;
                throw new MSQException(fault);
            }
        }
    }

    private static interface TaskContactFn {
        public ListenableFuture<Void> contactTask(WorkerClient var1, String var2, int var3);
    }

    private static interface TaskContactSuccess {
        public void onSuccess(String var1, int var2);
    }
}

