/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.controller.http.DartQueryInfo;
import org.apache.druid.msq.dart.controller.http.GetQueriesResponse;
import org.apache.druid.msq.dart.controller.sql.DartSqlClients;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResource;

@Path(value="/druid/v2/sql/dart/")
public class DartSqlResource
extends SqlResource {
    public static final String PATH = "/druid/v2/sql/dart";
    private static final Logger log = new Logger(DartSqlResource.class);
    private final DartControllerRegistry controllerRegistry;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final DartSqlClients sqlClients;
    private final AuthorizerMapper authorizerMapper;
    private final DefaultQueryConfig dartQueryConfig;

    @Inject
    public DartSqlResource(ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, @Dart SqlStatementFactory sqlStatementFactory, DartControllerRegistry controllerRegistry, SqlLifecycleManager sqlLifecycleManager, DartSqlClients sqlClients, ServerConfig serverConfig, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode, @Dart DefaultQueryConfig dartQueryConfig) {
        super(jsonMapper, authorizerMapper, sqlStatementFactory, sqlLifecycleManager, serverConfig, responseContextConfig, selfNode);
        this.controllerRegistry = controllerRegistry;
        this.sqlLifecycleManager = sqlLifecycleManager;
        this.sqlClients = sqlClients;
        this.authorizerMapper = authorizerMapper;
        this.dartQueryConfig = dartQueryConfig;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public Response doGetEnabled(@Context HttpServletRequest request) {
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        return Response.ok((Object)ImmutableMap.of((Object)"enabled", (Object)true)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public GetQueriesResponse doGetRunningQueries(@QueryParam(value="selfOnly") String selfOnly, @Context HttpServletRequest req) {
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req);
        AuthorizationResult stateReadAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)this.authorizerMapper);
        List<DartQueryInfo> queries = this.controllerRegistry.getAllHolders().stream().map(DartQueryInfo::fromControllerHolder).collect(Collectors.toList());
        if (selfOnly == null) {
            List otherQueries = (List)FutureUtils.getUnchecked((ListenableFuture)Futures.successfulAsList((Iterable)Iterables.transform(this.sqlClients.getAllClients(), client -> client.getRunningQueries(true))), (boolean)true);
            for (GetQueriesResponse response : otherQueries) {
                if (response == null) continue;
                queries.addAll(response.getQueries());
            }
        }
        queries.sort(Comparator.comparing(DartQueryInfo::getStartTime).thenComparing(DartQueryInfo::getDartQueryId));
        GetQueriesResponse response = stateReadAccess.allowAccessWithNoRestriction() ? new GetQueriesResponse(queries) : new GetQueriesResponse(queries.stream().filter(query -> authenticationResult.getAuthenticatedBy() != null && authenticationResult.getIdentity() != null && Objects.equals(authenticationResult.getAuthenticatedBy(), query.getAuthenticator()) && Objects.equals(authenticationResult.getIdentity(), query.getIdentity())).map(DartQueryInfo::withoutAuthenticationResult).collect(Collectors.toList()));
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)req);
        return response;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) {
        HashMap context = new HashMap(sqlQuery.getContext());
        for (Map.Entry entry : this.dartQueryConfig.getContext().entrySet()) {
            context.putIfAbsent((String)entry.getKey(), entry.getValue());
        }
        String dartQueryId = UUID.randomUUID().toString();
        context.put("dartQueryId", dartQueryId);
        return super.doPost(sqlQuery.withOverridenContext(context), req);
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query[%s]", new Object[]{sqlQueryId});
        List cancelables = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (cancelables.isEmpty()) {
            AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)req);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        AuthorizationResult authResult = this.authorizeCancellation(req, cancelables);
        if (authResult.allowAccessWithNoRestriction()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, cancelables);
            for (SqlLifecycleManager.Cancelable cancelable : cancelables) {
                HttpStatement stmt = (HttpStatement)cancelable;
                Object dartQueryId = stmt.context().get("dartQueryId");
                if (dartQueryId instanceof String) {
                    ControllerHolder holder = this.controllerRegistry.get((String)dartQueryId);
                    if (holder == null) continue;
                    holder.cancel();
                    continue;
                }
                log.warn("%s[%s] for query[%s] is not a string, cannot cancel.", new Object[]{"dartQueryId", dartQueryId, sqlQueryId});
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

