/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PeonCommandContext {
    private final List<String> command;
    private final List<String> javaOpts;
    private final File taskDir;
    private final boolean enableTls;
    private final int cpuMicroCore;

    public PeonCommandContext(List<String> command, List<String> javaOpts, File taskDir, int cpuMicroCore) {
        this(command, javaOpts, taskDir, cpuMicroCore, false);
    }

    public PeonCommandContext(List<String> command, List<String> javaOpts, File taskDir, int cpuMicroCore, boolean enableTls) {
        this.command = command;
        this.javaOpts = javaOpts;
        this.taskDir = taskDir;
        this.cpuMicroCore = cpuMicroCore;
        this.enableTls = enableTls;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public List<String> getJavaOpts() {
        ArrayList<String> result = new ArrayList<String>();
        for (String javaOpt : this.javaOpts) {
            String[] value = javaOpt.split("\\s+");
            result.addAll(Arrays.asList(value));
        }
        return result;
    }

    public File getTaskDir() {
        return this.taskDir;
    }

    public int getCpuMicroCore() {
        return this.cpuMicroCore;
    }

    public boolean isEnableTls() {
        return this.enableTls;
    }
}

