/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerUtils;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.k8s.overlord.KubernetesPeonLifecycle;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.KubernetesWorkItem;
import org.apache.druid.k8s.overlord.PeonLifecycleFactory;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesPeonClient;
import org.apache.druid.k8s.overlord.taskadapter.TaskAdapter;
import org.apache.druid.tasklogs.TaskLogStreamer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class KubernetesTaskRunner
implements TaskLogStreamer,
TaskRunner {
    private static final EmittingLogger log = new EmittingLogger(KubernetesTaskRunner.class);
    private final CopyOnWriteArrayList<Pair<TaskRunnerListener, Executor>> listeners = new CopyOnWriteArrayList();
    private final ScheduledExecutorService cleanupExecutor;
    protected final ConcurrentHashMap<String, KubernetesWorkItem> tasks = new ConcurrentHashMap();
    protected final TaskAdapter adapter;
    private final KubernetesPeonClient client;
    private final KubernetesTaskRunnerConfig config;
    private final ListeningExecutorService exec;
    private final HttpClient httpClient;
    private final PeonLifecycleFactory peonLifecycleFactory;
    private final ServiceEmitter emitter;
    protected static final String WORKER_CATEGORY = "_k8s_worker_category";

    public KubernetesTaskRunner(TaskAdapter adapter, KubernetesTaskRunnerConfig config, KubernetesPeonClient client, HttpClient httpClient, PeonLifecycleFactory peonLifecycleFactory, ServiceEmitter emitter) {
        this.adapter = adapter;
        this.config = config;
        this.client = client;
        this.httpClient = httpClient;
        this.peonLifecycleFactory = peonLifecycleFactory;
        this.cleanupExecutor = Executors.newScheduledThreadPool(1);
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)config.getCapacity(), (String)"k8s-task-runner-%d"));
        this.emitter = emitter;
    }

    public Optional<InputStream> streamTaskLog(String taskid, long offset) {
        KubernetesWorkItem workItem = this.tasks.get(taskid);
        if (workItem == null) {
            return Optional.absent();
        }
        return workItem.streamTaskLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<TaskStatus> run(Task task) {
        ConcurrentHashMap<String, KubernetesWorkItem> concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            return this.tasks.computeIfAbsent(task.getId(), k -> new KubernetesWorkItem(task, (ListenableFuture<TaskStatus>)this.exec.submit(() -> this.runTask(task)), this.peonLifecycleFactory.build(task, new K8sTaskId(this.config.getK8sTaskPodNamePrefix(), task), this::emitTaskStateMetrics))).getResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KubernetesWorkItem joinAsync(Task task) {
        ConcurrentHashMap<String, KubernetesWorkItem> concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            return this.tasks.computeIfAbsent(task.getId(), k -> new KubernetesWorkItem(task, (ListenableFuture<TaskStatus>)this.exec.submit(() -> this.joinTask(task)), this.peonLifecycleFactory.build(task, new K8sTaskId(this.config.getK8sTaskPodNamePrefix(), task), this::emitTaskStateMetrics)));
        }
    }

    private TaskStatus runTask(Task task) {
        return this.doTask(task, true);
    }

    private TaskStatus joinTask(Task task) {
        return this.doTask(task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected TaskStatus doTask(Task task, boolean run) {
        try {
            KubernetesPeonLifecycle peonLifecycle;
            ConcurrentHashMap<String, KubernetesWorkItem> concurrentHashMap = this.tasks;
            synchronized (concurrentHashMap) {
                KubernetesWorkItem workItem = this.tasks.get(task.getId());
                if (workItem == null) {
                    throw new ISE("Task [%s] has been shut down", new Object[]{task.getId()});
                }
                peonLifecycle = workItem.getPeonLifeycle();
            }
            TaskStatus taskStatus = run ? peonLifecycle.run(this.adapter.fromTask(task), this.config.getTaskLaunchTimeout().toStandardDuration().getMillis(), this.config.getTaskTimeout().toStandardDuration().getMillis(), this.adapter.shouldUseDeepStorageForTaskPayload(task)) : peonLifecycle.join(this.config.getTaskTimeout().toStandardDuration().getMillis());
            this.updateStatus(task, taskStatus);
            return taskStatus;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Task [%s] execution caught an exception", new Object[]{task.getId()});
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void emitTaskStateMetrics(KubernetesPeonLifecycle.State state, String taskId) {
        switch (state) {
            case RUNNING: {
                KubernetesWorkItem workItem;
                ConcurrentHashMap<String, KubernetesWorkItem> concurrentHashMap = this.tasks;
                synchronized (concurrentHashMap) {
                    workItem = this.tasks.get(taskId);
                    if (workItem == null) {
                        log.warn("Task [%s] disappeared. This could happen if the task was canceled or if it crashed.", new Object[]{taskId});
                        return;
                    }
                }
                ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
                IndexTaskUtils.setTaskDimensions((ServiceMetricEvent.Builder)metricBuilder, (Task)workItem.getTask());
                this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("task/pending/time", (Number)new Duration((ReadableInstant)workItem.getCreatedTime(), (ReadableInstant)DateTimes.nowUtc()).getMillis()));
            }
        }
    }

    public void updateStatus(Task task, TaskStatus status) {
        TaskRunnerUtils.notifyStatusChanged(this.listeners, (String)task.getId(), (TaskStatus)status);
    }

    public void updateLocation(Task task, TaskLocation location) {
        TaskRunnerUtils.notifyLocationChanged(this.listeners, (String)task.getId(), (TaskLocation)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String taskid, String reason) {
        log.info("Shutdown [%s] because [%s]", new Object[]{taskid, reason});
        KubernetesWorkItem workItem = this.tasks.get(taskid);
        if (workItem == null) {
            log.info("Ignoring request to cancel unknown task [%s]", new Object[]{taskid});
            return;
        }
        workItem.shutdown();
        if (!workItem.getResult().isDone()) {
            return;
        }
        ConcurrentHashMap<String, KubernetesWorkItem> concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            this.tasks.remove(taskid);
        }
    }

    public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
        KubernetesWorkItem workItem = this.tasks.get(taskid);
        if (workItem == null) {
            return Optional.absent();
        }
        TaskLocation taskLocation = workItem.getLocation();
        if (TaskLocation.unknown().equals((Object)taskLocation)) {
            return Optional.absent();
        }
        URL url = TaskRunnerUtils.makeTaskLocationURL((TaskLocation)taskLocation, (String)"/druid/worker/v1/chat/%s/liveReports", (String[])new String[]{taskid});
        try {
            return Optional.of((Object)((InputStream)this.httpClient.go(new Request(HttpMethod.GET, url), (HttpResponseHandler)new InputStreamResponseHandler()).get()));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw new RuntimeException(e);
        }
    }

    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
        return ImmutableList.of();
    }

    @LifecycleStart
    public void start() {
        log.info("Starting K8sTaskRunner...", new Object[0]);
        ArrayList<ListenableFuture<Boolean>> taskStatusActiveList = new ArrayList<ListenableFuture<Boolean>>();
        List<Job> peonJobs = this.client.getPeonJobs();
        log.info("Locating [%,d] active tasks.", new Object[]{peonJobs.size()});
        for (Job job : peonJobs) {
            try {
                KubernetesWorkItem kubernetesWorkItem = this.joinAsync(this.adapter.toTask(job));
                taskStatusActiveList.add(kubernetesWorkItem.getPeonLifeycle().getTaskStartedSuccessfullyFuture());
            }
            catch (IOException e) {
                log.error((Throwable)e, "Error deserializing task from job [%s]", new Object[]{job.getMetadata().getName()});
            }
        }
        try {
            DateTime nowUtc = DateTimes.nowUtc();
            long timeoutMs = nowUtc.plus((ReadablePeriod)this.config.getTaskJoinTimeout()).getMillis() - nowUtc.getMillis();
            if (timeoutMs > 0L) {
                FutureUtils.coalesce(taskStatusActiveList).get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            log.info("Located [%,d] active tasks.", new Object[]{taskStatusActiveList.size()});
        }
        catch (Exception e) {
            long numInitialized = this.tasks.values().stream().filter(item -> {
                if (item.getPeonLifeycle().getTaskStartedSuccessfullyFuture().isDone()) {
                    try {
                        return (Boolean)item.getPeonLifeycle().getTaskStartedSuccessfullyFuture().get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        return false;
                    }
                }
                return false;
            }).count();
            log.warn((Throwable)e, "Located [%,d] out of [%,d] active tasks (timeout = %s). Locating others asynchronously.", new Object[]{numInitialized, taskStatusActiveList.size(), this.config.getTaskJoinTimeout()});
        }
        this.cleanupExecutor.scheduleAtFixedRate(() -> this.client.deleteCompletedPeonJobsOlderThan(this.config.getTaskCleanupDelay().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS), 1L, this.config.getTaskCleanupInterval().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
        log.info("Started cleanup executor for jobs older than %s...", new Object[]{this.config.getTaskCleanupDelay()});
    }

    @LifecycleStop
    public void stop() {
        log.info("Stopping KubernetesTaskRunner", new Object[0]);
        this.exec.shutdownNow();
        this.cleanupExecutor.shutdownNow();
        log.debug("Stopped KubernetesTaskRunner", new Object[0]);
    }

    public Map<String, Long> getTotalTaskSlotCount() {
        return ImmutableMap.of((Object)WORKER_CATEGORY, (Object)this.config.getCapacity());
    }

    public Collection<? extends TaskRunnerWorkItem> getKnownTasks() {
        return Lists.newArrayList(this.tasks.values());
    }

    public Optional<ScalingStats> getScalingStats() {
        return Optional.absent();
    }

    public Map<String, Long> getIdleTaskSlotCount() {
        return ImmutableMap.of((Object)WORKER_CATEGORY, (Object)Math.max(0, this.config.getCapacity() - this.tasks.size()));
    }

    public Map<String, Long> getUsedTaskSlotCount() {
        return ImmutableMap.of((Object)WORKER_CATEGORY, (Object)Math.min(this.config.getCapacity(), this.tasks.size()));
    }

    public Map<String, Long> getLazyTaskSlotCount() {
        return Collections.emptyMap();
    }

    public Map<String, Long> getBlacklistedTaskSlotCount() {
        return Collections.emptyMap();
    }

    public void unregisterListener(String listenerId) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (pair.lhs == null || !((TaskRunnerListener)pair.lhs).getListenerId().equals(listenerId)) continue;
            this.listeners.remove(pair);
            log.debug("Unregistered listener [%s]", new Object[]{listenerId});
            return;
        }
    }

    public void registerListener(TaskRunnerListener listener, Executor executor) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (pair.lhs == null || !((TaskRunnerListener)pair.lhs).getListenerId().equals(listener.getListenerId())) continue;
            throw new ISE("Listener [%s] already registered", new Object[]{listener.getListenerId()});
        }
        Pair listenerPair = Pair.of((Object)listener, (Object)executor);
        log.debug("Registered listener [%s]", new Object[]{listener.getListenerId()});
        this.listeners.add((Pair<TaskRunnerListener, Executor>)listenerPair);
    }

    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        return this.tasks.values().stream().filter(KubernetesWorkItem::isRunning).collect(Collectors.toList());
    }

    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        return this.tasks.values().stream().filter(KubernetesWorkItem::isPending).collect(Collectors.toList());
    }

    public TaskLocation getTaskLocation(String taskId) {
        try {
            KubernetesWorkItem workItem = this.tasks.get(taskId);
            if (workItem == null) {
                return TaskLocation.unknown();
            }
            return workItem.getLocation();
        }
        catch (Exception e) {
            log.warn("Unable to find location for task [%s]", new Object[]{taskId});
            return TaskLocation.unknown();
        }
    }

    @Nullable
    public RunnerTaskState getRunnerTaskState(String taskId) {
        KubernetesWorkItem workItem = this.tasks.get(taskId);
        if (workItem == null) {
            return null;
        }
        return workItem.getRunnerTaskState();
    }

    public int getTotalCapacity() {
        return this.config.getCapacity();
    }

    public int getUsedCapacity() {
        return this.tasks.size();
    }
}

