/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.Metric;
import com.amazonaws.services.rds.model.MetricReference;
import com.amazonaws.services.rds.model.transform.MetricQueryStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.MetricReferenceStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class MetricStaxUnmarshaller
implements Unmarshaller<Metric, StaxUnmarshallerContext> {
    private static MetricStaxUnmarshaller instance;

    public Metric unmarshall(StaxUnmarshallerContext context) throws Exception {
        Metric metric = new Metric();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metric;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    metric.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("References", targetDepth)) {
                    metric.withReferences(new ArrayList<MetricReference>());
                    continue;
                }
                if (context.testExpression("References/member", targetDepth)) {
                    metric.withReferences(MetricReferenceStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatisticsDetails", targetDepth)) {
                    metric.setStatisticsDetails(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MetricQuery", targetDepth)) continue;
                metric.setMetricQuery(MetricQueryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metric;
    }

    public static MetricStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStaxUnmarshaller();
        }
        return instance;
    }
}

