/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidUnion
extends Union
implements DruidLogicalNode,
SourceDescProducer {
    public DruidUnion(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, List<RelNode> inputs, boolean all) {
        super(cluster, traits, hints, inputs, all);
        if (!all) {
            throw InvalidSqlInput.exception((String)"SQL requires 'UNION' but only 'UNION ALL' is supported.", (Object[])new Object[0]);
        }
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new DruidUnion(this.getCluster(), traitSet, (List<RelHint>)this.hints, inputs, all);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(mq.getRowCount((RelNode)this).doubleValue(), 0.0, 0.0);
    }

    @Override
    public SourceDescProducer.SourceDesc getSourceDesc(PlannerContext plannerContext, List<SourceDescProducer.SourceDesc> sources) {
        RowSignature signature = RowSignatures.fromRelDataType(sources.get((int)0).rowSignature.getColumnNames(), this.getRowType());
        UnionDataSource unionDataSource = this.buildUnionDataSource(sources);
        if (unionDataSource != null) {
            return new SourceDescProducer.SourceDesc((DataSource)unionDataSource, signature);
        }
        UnionQuery unionQuery = this.makeUnionQuery(sources);
        return new SourceDescProducer.SourceDesc((DataSource)new QueryDataSource((Query)unionQuery), signature);
    }

    private UnionDataSource buildUnionDataSource(List<SourceDescProducer.SourceDesc> sources) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (SourceDescProducer.SourceDesc sourceDesc : sources) {
            DataSource dataSource = sourceDesc.dataSource;
            if (!UnionDataSource.isCompatibleDataSource((DataSource)dataSource)) {
                return null;
            }
            dataSources.add(dataSource);
        }
        return new UnionDataSource(dataSources);
    }

    private UnionQuery makeUnionQuery(List<SourceDescProducer.SourceDesc> sources) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (SourceDescProducer.SourceDesc sourceDesc : sources) {
            DataSource dataSource = sourceDesc.dataSource;
            if (dataSource instanceof QueryDataSource) {
                queries.add(((QueryDataSource)dataSource).getQuery());
                continue;
            }
            throw DruidException.defensive((String)"Expected that all inputs are QueryDataSource-s! Encountered something else [%s].", (Object[])new Object[]{dataSource});
        }
        return new UnionQuery(queries);
    }
}

