/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import java.util.Objects;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.ordering.StringComparator;

public class BoundValue
implements Comparable<BoundValue> {
    private final String value;
    private final StringComparator comparator;

    public BoundValue(String value, StringComparator comparator) {
        this.value = value;
        this.comparator = comparator;
    }

    public String getValue() {
        return this.value;
    }

    public StringComparator getComparator() {
        return this.comparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundValue that = (BoundValue)o;
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.comparator, that.comparator);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.comparator != null ? this.comparator.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(BoundValue o) {
        if (!this.comparator.equals(o.comparator)) {
            throw new ISE("Comparator mismatch", new Object[0]);
        }
        return this.comparator.compare((Object)this.value, (Object)o.value);
    }

    public String toString() {
        return this.value;
    }
}

