/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIpamDiscoveredResourceCidrsRequestMarshaller
implements Marshaller<Request<GetIpamDiscoveredResourceCidrsRequest>, GetIpamDiscoveredResourceCidrsRequest> {
    public Request<GetIpamDiscoveredResourceCidrsRequest> marshall(GetIpamDiscoveredResourceCidrsRequest getIpamDiscoveredResourceCidrsRequest) {
        SdkInternalList getIpamDiscoveredResourceCidrsRequestFiltersList;
        if (getIpamDiscoveredResourceCidrsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamDiscoveredResourceCidrsRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamDiscoveredResourceCidrs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIpamDiscoveredResourceCidrsRequest.getIpamResourceDiscoveryId() != null) {
            request.addParameter("IpamResourceDiscoveryId", StringUtils.fromString((String)getIpamDiscoveredResourceCidrsRequest.getIpamResourceDiscoveryId()));
        }
        if (getIpamDiscoveredResourceCidrsRequest.getResourceRegion() != null) {
            request.addParameter("ResourceRegion", StringUtils.fromString((String)getIpamDiscoveredResourceCidrsRequest.getResourceRegion()));
        }
        if (!(getIpamDiscoveredResourceCidrsRequestFiltersList = (SdkInternalList)getIpamDiscoveredResourceCidrsRequest.getFilters()).isEmpty() || !getIpamDiscoveredResourceCidrsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getIpamDiscoveredResourceCidrsRequestFiltersListValue : getIpamDiscoveredResourceCidrsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getIpamDiscoveredResourceCidrsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getIpamDiscoveredResourceCidrsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getIpamDiscoveredResourceCidrsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getIpamDiscoveredResourceCidrsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamDiscoveredResourceCidrsRequest.getNextToken()));
        }
        if (getIpamDiscoveredResourceCidrsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamDiscoveredResourceCidrsRequest.getMaxResults()));
        }
        return request;
    }
}

