/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.MetadataAction;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.Duration;

public class MarkOvershadowedSegmentsAsUnused
implements CoordinatorDuty {
    private static final Logger log = new Logger(MarkOvershadowedSegmentsAsUnused.class);
    private final MetadataAction.DeleteSegments deleteHandler;
    private final Stopwatch sinceCoordinatorStarted = Stopwatch.createStarted();

    public MarkOvershadowedSegmentsAsUnused(MetadataAction.DeleteSegments deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        Duration requiredDelay = Duration.millis((long)params.getCoordinatorDynamicConfig().getMarkSegmentAsUnusedDelayMillis());
        if (this.sinceCoordinatorStarted.hasNotElapsed(requiredDelay)) {
            return params;
        }
        ImmutableSet<DataSegment> allOvershadowedSegments = params.getDataSourcesSnapshot().getOvershadowedSegments();
        if (allOvershadowedSegments.isEmpty()) {
            return params;
        }
        DruidCluster cluster = params.getDruidCluster();
        HashMap timelines = new HashMap();
        cluster.getHistoricals().values().forEach(historicals -> historicals.forEach(historical -> this.addSegmentsFromServer((ServerHolder)historical, timelines)));
        cluster.getBrokers().forEach(broker -> this.addSegmentsFromServer((ServerHolder)broker, timelines));
        params.getSegmentAssigner().getSegmentsWithZeroRequiredReplicas().forEach((datasource, segments) -> timelines.computeIfAbsent(datasource, ds -> new SegmentTimeline()).addSegments(segments.iterator()));
        HashMap<String, Set> datasourceToUnusedSegments = new HashMap<String, Set>();
        for (DataSegment dataSegment : allOvershadowedSegments) {
            SegmentTimeline timeline = (SegmentTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment)) continue;
            datasourceToUnusedSegments.computeIfAbsent(dataSegment.getDataSource(), ds -> new HashSet()).add(dataSegment.getId());
        }
        CoordinatorRunStats stats = params.getCoordinatorStats();
        datasourceToUnusedSegments.forEach((datasource, unusedSegments) -> {
            RowKey datasourceKey = RowKey.of(Dimension.DATASOURCE, datasource);
            stats.add(Stats.Segments.OVERSHADOWED, datasourceKey, unusedSegments.size());
            Stopwatch updateTime = Stopwatch.createStarted();
            int updatedCount = this.deleteHandler.markSegmentsAsUnused((String)datasource, (Set<SegmentId>)unusedSegments);
            log.info("Marked [%d] segments of datasource[%s] as unused in [%,d]ms.", new Object[]{updatedCount, datasource, updateTime.millisElapsed()});
        });
        return params;
    }

    private void addSegmentsFromServer(ServerHolder serverHolder, Map<String, SegmentTimeline> timelines) {
        ImmutableDruidServer server = serverHolder.getServer();
        for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
            timelines.computeIfAbsent(dataSource.getName(), dsName -> new SegmentTimeline()).addSegments(dataSource.getSegments().iterator());
        }
    }
}

