/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.apache.druid.discovery.ClientUtils;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@Deprecated
public class BrokerClient {
    private static final int MAX_RETRIES = 5;
    private final HttpClient brokerHttpClient;
    private final DruidNodeDiscovery druidNodeDiscovery;

    @Inject
    public BrokerClient(@EscalatedGlobal HttpClient brokerHttpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
        this.brokerHttpClient = brokerHttpClient;
        this.druidNodeDiscovery = druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER);
    }

    public Request makeRequest(HttpMethod httpMethod, String urlPath) throws IOException {
        String host = ClientUtils.pickOneHost(this.druidNodeDiscovery);
        if (host == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.NOT_FOUND).build("A leader node could not be found for [%s] service. Check the logs to validate that service is healthy.", new Object[]{NodeRole.BROKER});
        }
        return new Request(httpMethod, new URL(StringUtils.format((String)"%s%s", (Object[])new Object[]{host, urlPath})));
    }

    public String sendQuery(Request request) throws Exception {
        return (String)RetryUtils.retry(() -> {
            Request newRequestUrl = this.getNewRequestUrl(request);
            StringFullResponseHolder fullResponseHolder = (StringFullResponseHolder)this.brokerHttpClient.go(newRequestUrl, (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8)).get();
            HttpResponseStatus responseStatus = fullResponseHolder.getResponse().getStatus();
            if (HttpResponseStatus.SERVICE_UNAVAILABLE.equals((Object)responseStatus) || HttpResponseStatus.GATEWAY_TIMEOUT.equals((Object)responseStatus)) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Request to broker failed due to failed response status: [%s]", new Object[]{responseStatus});
            }
            return fullResponseHolder.getContent();
        }, throwable -> {
            if (throwable instanceof ExecutionException) {
                return throwable.getCause() instanceof IOException || throwable.getCause() instanceof ChannelException;
            }
            if (throwable instanceof DruidException) {
                return ((DruidException)throwable).getCategory() == DruidException.Category.RUNTIME_FAILURE;
            }
            return throwable instanceof IOE;
        }, (int)5);
    }

    private Request getNewRequestUrl(Request oldRequest) {
        try {
            return ClientUtils.withUrl(oldRequest, new URL(StringUtils.format((String)"%s%s", (Object[])new Object[]{ClientUtils.pickOneHost(this.druidNodeDiscovery), oldRequest.getUrl().getPath()})));
        }
        catch (MalformedURLException e) {
            throw DruidException.defensive((String)"Failed to build url with path[%s] and query string [%s].", (Object[])new Object[]{oldRequest.getUrl().getPath(), oldRequest.getUrl().getQuery()});
        }
    }
}

