/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.indexing.seekablestream.extension.KafkaConfigOverrides;
import org.joda.time.DateTime;

public class KafkaIndexTaskIOConfig
extends SeekableStreamIndexTaskIOConfig<KafkaTopicPartition, Long> {
    private final Map<String, Object> consumerProperties;
    private final long pollTimeout;
    private final KafkaConfigOverrides configOverrides;
    private final boolean multiTopic;

    @JsonCreator
    public KafkaIndexTaskIOConfig(@JsonProperty(value="taskGroupId") @Nullable Integer taskGroupId, @JsonProperty(value="baseSequenceName") String baseSequenceName, @JsonProperty(value="startPartitions") @Nullable @Deprecated SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> startPartitions, @JsonProperty(value="endPartitions") @Nullable @Deprecated SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> endPartitions, @JsonProperty(value="startSequenceNumbers") @Nullable SeekableStreamStartSequenceNumbers<KafkaTopicPartition, Long> startSequenceNumbers, @JsonProperty(value="endSequenceNumbers") @Nullable SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> endSequenceNumbers, @JsonProperty(value="consumerProperties") Map<String, Object> consumerProperties, @JsonProperty(value="pollTimeout") Long pollTimeout, @JsonProperty(value="useTransaction") Boolean useTransaction, @JsonProperty(value="minimumMessageTime") DateTime minimumMessageTime, @JsonProperty(value="maximumMessageTime") DateTime maximumMessageTime, @JsonProperty(value="inputFormat") @Nullable InputFormat inputFormat, @JsonProperty(value="configOverrides") @Nullable KafkaConfigOverrides configOverrides, @JsonProperty(value="multiTopic") @Nullable Boolean multiTopic) {
        super(taskGroupId, baseSequenceName, startSequenceNumbers == null ? ((SeekableStreamEndSequenceNumbers)Preconditions.checkNotNull(startPartitions, (Object)"startPartitions")).asStartPartitions(true) : startSequenceNumbers, endSequenceNumbers == null ? endPartitions : endSequenceNumbers, useTransaction, minimumMessageTime, maximumMessageTime, inputFormat);
        this.consumerProperties = (Map)Preconditions.checkNotNull(consumerProperties, (Object)"consumerProperties");
        this.pollTimeout = pollTimeout != null ? pollTimeout : 100L;
        this.configOverrides = configOverrides;
        this.multiTopic = multiTopic != null ? multiTopic : false;
        SeekableStreamEndSequenceNumbers myEndSequenceNumbers = this.getEndSequenceNumbers();
        for (KafkaTopicPartition partition : myEndSequenceNumbers.getPartitionSequenceNumberMap().keySet()) {
            Preconditions.checkArgument((((Long)myEndSequenceNumbers.getPartitionSequenceNumberMap().get(partition)).compareTo((Long)this.getStartSequenceNumbers().getPartitionSequenceNumberMap().get(partition)) >= 0 ? 1 : 0) != 0, (String)"end offset must be >= start offset for partition[%s]", (Object)partition);
        }
    }

    public KafkaIndexTaskIOConfig(int taskGroupId, String baseSequenceName, SeekableStreamStartSequenceNumbers<KafkaTopicPartition, Long> startSequenceNumbers, SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> endSequenceNumbers, Map<String, Object> consumerProperties, Long pollTimeout, Boolean useTransaction, DateTime minimumMessageTime, DateTime maximumMessageTime, InputFormat inputFormat, KafkaConfigOverrides configOverrides) {
        this(taskGroupId, baseSequenceName, null, null, startSequenceNumbers, endSequenceNumbers, consumerProperties, pollTimeout, useTransaction, minimumMessageTime, maximumMessageTime, inputFormat, configOverrides, false);
    }

    @JsonProperty
    @Deprecated
    public SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> getStartPartitions() {
        SeekableStreamStartSequenceNumbers startSequenceNumbers = this.getStartSequenceNumbers();
        return new SeekableStreamEndSequenceNumbers(startSequenceNumbers.getStream(), startSequenceNumbers.getPartitionSequenceNumberMap());
    }

    @JsonProperty
    @Deprecated
    public SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> getEndPartitions() {
        return this.getEndSequenceNumbers();
    }

    @JsonProperty
    public Map<String, Object> getConsumerProperties() {
        return this.consumerProperties;
    }

    @JsonProperty
    public long getPollTimeout() {
        return this.pollTimeout;
    }

    @JsonProperty
    public KafkaConfigOverrides getConfigOverrides() {
        return this.configOverrides;
    }

    @JsonProperty
    public boolean isMultiTopic() {
        return this.multiTopic;
    }

    public String toString() {
        return "KafkaIndexTaskIOConfig{taskGroupId=" + this.getTaskGroupId() + ", baseSequenceName='" + this.getBaseSequenceName() + '\'' + ", startSequenceNumbers=" + this.getStartSequenceNumbers() + ", endSequenceNumbers=" + this.getEndSequenceNumbers() + ", consumerProperties=" + this.consumerProperties + ", pollTimeout=" + this.pollTimeout + ", useTransaction=" + this.isUseTransaction() + ", minimumMessageTime=" + this.getMinimumMessageTime() + ", maximumMessageTime=" + this.getMaximumMessageTime() + ", configOverrides=" + this.getConfigOverrides() + '}';
    }
}

