/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafkainput;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafkainput.KafkaHeaderReader;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.joda.time.DateTime;

public class KafkaInputReader
implements InputEntityReader {
    private final InputRowSchema inputRowSchema;
    private final SettableByteEntity<KafkaRecordEntity> source;
    private final Function<KafkaRecordEntity, KafkaHeaderReader> headerParserSupplier;
    private final Function<KafkaRecordEntity, InputEntityReader> keyParserSupplier;
    private final InputEntityReader valueParser;
    private final String keyColumnName;
    private final String timestampColumnName;
    private final String topicColumnName;

    public KafkaInputReader(InputRowSchema inputRowSchema, SettableByteEntity<KafkaRecordEntity> source, @Nullable Function<KafkaRecordEntity, KafkaHeaderReader> headerParserSupplier, @Nullable Function<KafkaRecordEntity, InputEntityReader> keyParserSupplier, InputEntityReader valueParser, String keyColumnName, String timestampColumnName, String topicColumnName) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.headerParserSupplier = headerParserSupplier;
        this.keyParserSupplier = keyParserSupplier;
        this.valueParser = valueParser;
        this.keyColumnName = keyColumnName;
        this.timestampColumnName = timestampColumnName;
        this.topicColumnName = topicColumnName;
    }

    public CloseableIterator<InputRow> read() throws IOException {
        KafkaRecordEntity record = (KafkaRecordEntity)this.source.getEntity();
        Map<String, Object> mergedHeaderMap = this.extractHeaderAndKeys(record);
        if (record.getRecord().value() != null) {
            return this.buildBlendedRows(this.valueParser, mergedHeaderMap);
        }
        return CloseableIterators.withEmptyBaggage(this.buildInputRowsForMap(mergedHeaderMap).iterator());
    }

    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        KafkaRecordEntity record = (KafkaRecordEntity)this.source.getEntity();
        InputRowListPlusRawValues keysAndHeader = this.extractHeaderAndKeysSample(record);
        if (record.getRecord().value() != null) {
            return this.buildBlendedRowsSample(this.valueParser, keysAndHeader.getRawValues());
        }
        List<InputRowListPlusRawValues> rows = Collections.singletonList(keysAndHeader);
        return CloseableIterators.withEmptyBaggage(rows.iterator());
    }

    private Map<String, Object> extractHeader(KafkaRecordEntity record) {
        HashMap<String, Object> mergedHeaderMap = new HashMap<String, Object>();
        if (this.headerParserSupplier != null) {
            KafkaHeaderReader headerParser = this.headerParserSupplier.apply(record);
            List<Pair<String, Object>> headerList = headerParser.read();
            for (Pair<String, Object> ele : headerList) {
                mergedHeaderMap.put((String)ele.lhs, ele.rhs);
            }
        }
        mergedHeaderMap.putIfAbsent(this.timestampColumnName, record.getRecord().timestamp());
        mergedHeaderMap.putIfAbsent(this.topicColumnName, record.getRecord().topic());
        return mergedHeaderMap;
    }

    private Map<String, Object> extractHeaderAndKeys(KafkaRecordEntity record) throws IOException {
        InputEntityReader keyParser;
        Map<String, Object> mergedHeaderMap = this.extractHeader(record);
        InputEntityReader inputEntityReader = keyParser = this.keyParserSupplier == null ? null : this.keyParserSupplier.apply(record);
        if (keyParser != null) {
            try (CloseableIterator keyIterator = keyParser.read();){
                if (keyIterator.hasNext()) {
                    MapBasedInputRow keyRow = (MapBasedInputRow)keyIterator.next();
                    mergedHeaderMap.putIfAbsent(this.keyColumnName, ((Map.Entry)keyRow.getEvent().entrySet().stream().findFirst().get()).getValue());
                }
            }
            catch (ClassCastException e) {
                throw new IOException("Unsupported keyFormat. KafkaInputformat only supports input format that return MapBasedInputRow rows");
            }
        }
        return mergedHeaderMap;
    }

    private CloseableIterator<InputRow> buildBlendedRows(InputEntityReader valueParser, Map<String, Object> headerKeyList) throws IOException {
        return valueParser.read().map(r -> {
            HashSet<String> newDimensions = new HashSet<String>(r.getDimensions());
            Map<String, Object> event = KafkaInputReader.buildBlendedEventMap(arg_0 -> ((InputRow)r).getRaw(arg_0), newDimensions, headerKeyList);
            newDimensions.addAll(headerKeyList.keySet());
            newDimensions.remove("__kif_auto_timestamp");
            DateTime timestamp = MapInputRowParser.parseTimestamp((TimestampSpec)this.inputRowSchema.getTimestampSpec(), event);
            return new MapBasedInputRow(timestamp, MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), newDimensions), event);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputRowListPlusRawValues extractHeaderAndKeysSample(KafkaRecordEntity record) throws IOException {
        Map<String, Object> mergedHeaderMap = this.extractHeader(record);
        InputEntityReader keyParser = this.keyParserSupplier == null ? null : this.keyParserSupplier.apply(record);
        if (keyParser == null) return InputRowListPlusRawValues.of(this.buildInputRowsForMap(mergedHeaderMap), mergedHeaderMap);
        try (CloseableIterator keyIterator = keyParser.sample();){
            if (!keyIterator.hasNext()) return InputRowListPlusRawValues.of(this.buildInputRowsForMap(mergedHeaderMap), mergedHeaderMap);
            InputRowListPlusRawValues keyRow = (InputRowListPlusRawValues)keyIterator.next();
            mergedHeaderMap.putIfAbsent(this.keyColumnName, ((Map.Entry)keyRow.getRawValues().entrySet().stream().findFirst().get()).getValue());
            InputRowListPlusRawValues inputRowListPlusRawValues = InputRowListPlusRawValues.of(this.buildInputRowsForMap(mergedHeaderMap), mergedHeaderMap);
            return inputRowListPlusRawValues;
        }
        catch (ClassCastException e) {
            throw new IOException("Unsupported keyFormat. KafkaInputformat only supports input format that return MapBasedInputRow rows");
        }
    }

    private CloseableIterator<InputRowListPlusRawValues> buildBlendedRowsSample(InputEntityReader valueParser, Map<String, Object> headerKeyList) throws IOException {
        return valueParser.sample().map(rowAndValues -> {
            if (rowAndValues.getParseException() != null) {
                return rowAndValues;
            }
            ArrayList newInputRows = Lists.newArrayListWithCapacity((int)rowAndValues.getInputRows().size());
            ArrayList newRawRows = Lists.newArrayListWithCapacity((int)rowAndValues.getRawValues().size());
            for (Map raw : rowAndValues.getRawValuesList()) {
                newRawRows.add(KafkaInputReader.buildBlendedEventMap(raw::get, raw.keySet(), headerKeyList));
            }
            for (InputRow r : rowAndValues.getInputRows()) {
                if (r == null) continue;
                HashSet<String> newDimensions = new HashSet<String>(r.getDimensions());
                Map<String, Object> event = KafkaInputReader.buildBlendedEventMap(arg_0 -> ((InputRow)r).getRaw(arg_0), newDimensions, headerKeyList);
                newDimensions.addAll(headerKeyList.keySet());
                newDimensions.remove("__kif_auto_timestamp");
                newInputRows.add(new MapBasedInputRow(this.inputRowSchema.getTimestampSpec().extractTimestamp(event), MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), newDimensions), event));
            }
            return InputRowListPlusRawValues.ofList((List)newRawRows, (List)newInputRows, null);
        });
    }

    private List<InputRow> buildInputRowsForMap(Map<String, Object> headerKeyList) {
        return Collections.singletonList(new MapBasedInputRow(this.inputRowSchema.getTimestampSpec().extractTimestamp(headerKeyList), MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), headerKeyList.keySet()), headerKeyList));
    }

    private static Map<String, Object> buildBlendedEventMap(final Function<String, Object> getRowValue, Set<String> rowDimensions, final Map<String, Object> fallback) {
        final HashSet<String> keySet = new HashSet<String>(fallback.keySet());
        keySet.addAll(rowDimensions);
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                String skey = (String)key;
                Object val = getRowValue.apply(skey);
                if (val == null) {
                    return fallback.get(skey);
                }
                return val;
            }

            @Override
            public Set<String> keySet() {
                return keySet;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.keySet().stream().map(field -> new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return field;
                    }

                    @Override
                    public Object getValue() {
                        return this.get(field);
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                }).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        };
    }
}

