/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.sql;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.BloomDimFilter;
import org.apache.druid.query.filter.BloomKFilter;
import org.apache.druid.query.filter.BloomKFilterHolder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class BloomFilterOperatorConversion
extends DirectOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder((String)StringUtils.toUpperCase((String)"bloom_filter_test")).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER}).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

    public BloomFilterOperatorConversion() {
        super((SqlOperator)SQL_FUNCTION, "bloom_filter_test");
    }

    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        BloomKFilterHolder holder;
        List operands = ((RexCall)rexNode).getOperands();
        DruidExpression druidExpression = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)((RexNode)operands.get(0)));
        if (druidExpression == null) {
            return null;
        }
        String base64EncodedBloomKFilter = RexLiteral.stringValue((RexNode)((RexNode)operands.get(1)));
        byte[] decoded = StringUtils.decodeBase64String((String)base64EncodedBloomKFilter);
        try {
            BloomKFilter filter = BloomFilterSerializersModule.bloomKFilterFromBytes(decoded);
            holder = BloomKFilterHolder.fromBloomKFilter(filter);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to deserialize bloom filter", ioe);
        }
        if (druidExpression.isSimpleExtraction()) {
            return new BloomDimFilter(druidExpression.getSimpleExtraction().getColumn(), holder, druidExpression.getSimpleExtraction().getExtractionFn(), null);
        }
        if (virtualColumnRegistry != null) {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, ((RexNode)operands.get(0)).getType());
            if (virtualColumnName == null) {
                return null;
            }
            return new BloomDimFilter(virtualColumnName, holder, null, null);
        }
        return null;
    }
}

