/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.storage.s3.output.S3ExportConfig;
import org.apache.druid.storage.s3.output.S3OutputConfig;
import org.apache.druid.storage.s3.output.S3StorageConnector;
import org.apache.druid.storage.s3.output.S3UploadManager;

@JsonTypeName(value="s3")
public class S3ExportStorageProvider
implements ExportStorageProvider {
    public static final String TYPE_NAME = "s3";
    private static final String DELIM = "/";
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    @JsonProperty
    private final String bucket;
    @JsonProperty
    private final String prefix;
    @JacksonInject
    S3ExportConfig s3ExportConfig;
    @JacksonInject
    ServerSideEncryptingAmazonS3 s3;
    @JacksonInject
    S3UploadManager s3UploadManager;

    @JsonCreator
    public S3ExportStorageProvider(@JsonProperty(value="bucket", required=true) String bucket, @JsonProperty(value="prefix", required=true) String prefix) {
        this.bucket = bucket;
        this.prefix = prefix;
    }

    public StorageConnector get() {
        String tempDir = this.s3ExportConfig.getTempLocalDir();
        if (tempDir == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.NOT_FOUND).build("The runtime property `druid.export.storage.s3.tempLocalDir` must be configured for S3 export.", new Object[0]);
        }
        List<String> allowedExportPaths = this.s3ExportConfig.getAllowedExportPaths();
        if (allowedExportPaths == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.NOT_FOUND).build("The runtime property `druid.export.storage.s3.allowedExportPaths` must be configured for S3 export.", new Object[0]);
        }
        S3ExportStorageProvider.validateS3Prefix(allowedExportPaths, this.bucket, this.prefix);
        S3OutputConfig s3OutputConfig = new S3OutputConfig(this.bucket, this.prefix, new File(tempDir), this.s3ExportConfig.getChunkSize(), this.s3ExportConfig.getMaxRetry());
        return new S3StorageConnector(s3OutputConfig, this.s3, this.s3UploadManager);
    }

    @VisibleForTesting
    static void validateS3Prefix(@NotNull List<String> allowedExportPaths, String bucket, String prefix) {
        URI providedUri = new CloudObjectLocation(bucket, prefix).toUri(TYPE_NAME);
        for (String path : allowedExportPaths) {
            URI allowedUri = URI.create(path);
            if (!S3ExportStorageProvider.validateUri(allowedUri, providedUri)) continue;
            return;
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("None of the allowed prefixes matched the input path [%s]. Please reach out to the cluster admin for the whitelisted paths for export. The paths are controlled via the property `druid.export.storage.s3.allowedExportPaths`.", new Object[]{providedUri});
    }

    private static boolean validateUri(URI allowedUri, URI providedUri) {
        if (!allowedUri.getHost().equals(providedUri.getHost())) {
            return false;
        }
        String allowedPath = StringUtils.maybeAppendTrailingSlash((String)allowedUri.getPath());
        String providedPath = StringUtils.maybeAppendTrailingSlash((String)providedUri.getPath());
        return providedPath.startsWith(allowedPath);
    }

    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    @JsonIgnore
    public String getResourceType() {
        return TYPE_NAME;
    }

    @JsonIgnore
    public String getBasePath() {
        return new CloudObjectLocation(this.bucket, this.prefix).toUri(TYPE_NAME).toString();
    }

    public String getFilePathForManifest(String fileName) {
        return new CloudObjectLocation(this.bucket, JOINER.join((Object)this.prefix, (Object)fileName, new Object[0])).toUri(TYPE_NAME).toString();
    }
}

