/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.common.aws.AWSClientConfig;
import org.apache.druid.common.aws.AWSEndpointConfig;
import org.apache.druid.common.aws.AWSProxyConfig;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.s3.S3DataSegmentArchiver;
import org.apache.druid.storage.s3.S3DataSegmentArchiverConfig;
import org.apache.druid.storage.s3.S3DataSegmentKiller;
import org.apache.druid.storage.s3.S3DataSegmentMover;
import org.apache.druid.storage.s3.S3DataSegmentPusher;
import org.apache.druid.storage.s3.S3DataSegmentPusherConfig;
import org.apache.druid.storage.s3.S3InputDataConfig;
import org.apache.druid.storage.s3.S3LoadSpec;
import org.apache.druid.storage.s3.S3SSECustomConfig;
import org.apache.druid.storage.s3.S3SSEKmsConfig;
import org.apache.druid.storage.s3.S3StorageConfig;
import org.apache.druid.storage.s3.S3TaskLogs;
import org.apache.druid.storage.s3.S3TaskLogsConfig;
import org.apache.druid.storage.s3.S3TimestampVersionedDataFinder;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class S3StorageDruidModule
implements DruidModule {
    public static final String SCHEME = "s3";
    public static final String SCHEME_S3N = "s3n";
    public static final String SCHEME_S3_ZIP = "s3_zip";
    private static final Logger log = new Logger(S3StorageDruidModule.class);

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidS3-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{S3LoadSpec.class});
            }
        });
    }

    public void configure(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME).to(S3TimestampVersionedDataFinder.class).in(LazySingleton.class);
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME_S3N).to(S3TimestampVersionedDataFinder.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME_S3_ZIP).to(S3DataSegmentKiller.class).in(LazySingleton.class);
        Binders.dataSegmentMoverBinder((Binder)binder).addBinding((Object)SCHEME_S3_ZIP).to(S3DataSegmentMover.class).in(LazySingleton.class);
        Binders.dataSegmentArchiverBinder((Binder)binder).addBinding((Object)SCHEME_S3_ZIP).to(S3DataSegmentArchiver.class).in(LazySingleton.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(S3DataSegmentPusher.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3InputDataConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3DataSegmentPusherConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3DataSegmentArchiverConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3StorageConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage.sse.kms", S3SSEKmsConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage.sse.custom", S3SSECustomConfig.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)SCHEME).to(S3TaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", S3TaskLogsConfig.class);
        binder.bind(S3TaskLogs.class).in(LazySingleton.class);
    }

    @Provides
    public ServerSideEncryptingAmazonS3.Builder getServerSideEncryptingAmazonS3Builder(AWSCredentialsProvider provider, AWSProxyConfig proxyConfig, AWSEndpointConfig endpointConfig, AWSClientConfig clientConfig, S3StorageConfig storageConfig) {
        ClientConfiguration configuration = new ClientConfigurationFactory().getConfig();
        Protocol protocol = S3Utils.determineProtocol(clientConfig, endpointConfig);
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(provider)).withClientConfiguration(S3Utils.setProxyConfig(configuration, proxyConfig).withProtocol(protocol))).withChunkedEncodingDisabled(Boolean.valueOf(clientConfig.isDisableChunkedEncoding()))).withPathStyleAccessEnabled(Boolean.valueOf(clientConfig.isEnablePathStyleAccess()))).withForceGlobalBucketAccessEnabled(Boolean.valueOf(clientConfig.isForceGlobalBucketAccessEnabled()));
        if (StringUtils.isNotEmpty((String)endpointConfig.getUrl())) {
            amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpointConfig.getUrl(), endpointConfig.getSigningRegion()));
        }
        return ServerSideEncryptingAmazonS3.builder().setAmazonS3ClientBuilder(amazonS3ClientBuilder).setS3StorageConfig(storageConfig);
    }

    @Provides
    @LazySingleton
    public ServerSideEncryptingAmazonS3 getAmazonS3Client(ServerSideEncryptingAmazonS3.Builder serverSideEncryptingAmazonS3Builder) {
        return serverSideEncryptingAmazonS3Builder.build();
    }

    @Provides
    @LazySingleton
    public Supplier<ServerSideEncryptingAmazonS3> getAmazonS3ClientSupplier(ServerSideEncryptingAmazonS3.Builder serverSideEncryptingAmazonS3Builder) {
        return Suppliers.memoize(serverSideEncryptingAmazonS3Builder::build);
    }
}

