/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

public class BasicSecurityResourceFilter
extends AbstractResourceFilter {
    private static final String SECURITY_RESOURCE_NAME = "security";

    @Inject
    public BasicSecurityResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource(SECURITY_RESOURCE_NAME, "CONFIG"), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)this.getReq(), (ResourceAction)resourceAction, (AuthorizerMapper)this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)StringUtils.format((String)"Access-Check-Result: %s", (Object[])new Object[]{authResult.toString()})).build());
        }
        return request;
    }
}

