/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AffinityConfig {
    private final Map<String, Set<String>> affinity;
    private final boolean strong;
    private final Set<String> affinityWorkers;

    @JsonCreator
    public AffinityConfig(@JsonProperty(value="affinity") Map<String, Set<String>> affinity, @JsonProperty(value="strong") boolean strong) {
        this.affinity = affinity;
        this.strong = strong;
        this.affinityWorkers = affinity.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @JsonProperty
    public Map<String, Set<String>> getAffinity() {
        return this.affinity;
    }

    @JsonProperty
    public boolean isStrong() {
        return this.strong;
    }

    public Set<String> getAffinityWorkers() {
        return this.affinityWorkers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffinityConfig that = (AffinityConfig)o;
        return this.strong == that.strong && Objects.equals(this.affinity, that.affinity);
    }

    public int hashCode() {
        return Objects.hash(this.affinity, this.strong);
    }

    public String toString() {
        return "AffinityConfig{affinity=" + this.affinity + ", strong=" + this.strong + '}';
    }
}

