/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.actions.SegmentAllocationQueue;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.TaskContextEnricher;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.indexing.overlord.duty.OverlordDutyExecutor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.CoordinatorOverlordServiceConfig;

public class DruidOverlord {
    private static final EmittingLogger log = new EmittingLogger(DruidOverlord.class);
    private final DruidLeaderSelector overlordLeaderSelector;
    private final DruidLeaderSelector.Listener leadershipListener;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final AtomicReference<Lifecycle> leaderLifecycleRef = new AtomicReference<Object>(null);
    private volatile boolean initialized;

    @Inject
    public DruidOverlord(final TaskMaster taskMaster, final TaskLockConfig taskLockConfig, final TaskQueueConfig taskQueueConfig, final DefaultTaskConfig defaultTaskConfig, final TaskLockbox taskLockbox, final TaskStorage taskStorage, final TaskActionClientFactory taskActionClientFactory, @Self DruidNode selfNode, final TaskRunnerFactory runnerFactory, final ServiceAnnouncer serviceAnnouncer, CoordinatorOverlordServiceConfig coordinatorOverlordServiceConfig, final ServiceEmitter emitter, final SupervisorManager supervisorManager, final OverlordDutyExecutor overlordDutyExecutor, @IndexingService DruidLeaderSelector overlordLeaderSelector, final SegmentAllocationQueue segmentAllocationQueue, final CompactionScheduler compactionScheduler, final ObjectMapper mapper, final TaskContextEnricher taskContextEnricher) {
        this.overlordLeaderSelector = overlordLeaderSelector;
        final DruidNode node = coordinatorOverlordServiceConfig.getOverlordService() == null ? selfNode : selfNode.withService(coordinatorOverlordServiceConfig.getOverlordService());
        this.leadershipListener = new DruidLeaderSelector.Listener(){

            public void becomeLeader() {
                DruidOverlord.this.giant.lock();
                log.info("By the power of Grayskull, I have the power!", new Object[0]);
                try {
                    Object taskRunner = runnerFactory.build();
                    TaskQueue taskQueue = new TaskQueue(taskLockConfig, taskQueueConfig, defaultTaskConfig, taskStorage, (TaskRunner)taskRunner, taskActionClientFactory, taskLockbox, emitter, mapper, taskContextEnricher);
                    Lifecycle leaderLifecycle = new Lifecycle("task-master");
                    if (DruidOverlord.this.leaderLifecycleRef.getAndSet(leaderLifecycle) != null) {
                        log.makeAlert("TaskMaster set a new Lifecycle without the old one being cleared!  Race condition", new Object[0]).emit();
                    }
                    leaderLifecycle.addManagedInstance(taskRunner);
                    leaderLifecycle.addManagedInstance((Object)taskQueue);
                    leaderLifecycle.addManagedInstance((Object)supervisorManager);
                    leaderLifecycle.addManagedInstance((Object)overlordDutyExecutor);
                    leaderLifecycle.addHandler(new Lifecycle.Handler((TaskRunner)taskRunner, taskQueue){
                        final /* synthetic */ TaskRunner val$taskRunner;
                        final /* synthetic */ TaskQueue val$taskQueue;
                        {
                            this.val$taskRunner = taskRunner;
                            this.val$taskQueue = taskQueue;
                        }

                        public void start() {
                            segmentAllocationQueue.becomeLeader();
                            taskMaster.becomeLeader(this.val$taskRunner, this.val$taskQueue);
                            compactionScheduler.start();
                            DruidOverlord.this.initialized = true;
                            serviceAnnouncer.announce(node);
                        }

                        public void stop() {
                            serviceAnnouncer.unannounce(node);
                            compactionScheduler.stop();
                            taskMaster.stopBeingLeader();
                            segmentAllocationQueue.stopBeingLeader();
                        }
                    });
                    leaderLifecycle.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    DruidOverlord.this.giant.unlock();
                }
            }

            public void stopBeingLeader() {
                DruidOverlord.this.giant.lock();
                try {
                    DruidOverlord.this.initialized = false;
                    Lifecycle leaderLifecycle = DruidOverlord.this.leaderLifecycleRef.getAndSet(null);
                    if (leaderLifecycle != null) {
                        leaderLifecycle.stop();
                    }
                }
                finally {
                    DruidOverlord.this.giant.unlock();
                }
            }
        };
    }

    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            this.overlordLeaderSelector.registerListener(this.leadershipListener);
        }
        finally {
            this.giant.unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.gracefulStopLeaderLifecycle();
            this.overlordLeaderSelector.unregisterListener();
        }
        finally {
            this.giant.unlock();
        }
    }

    public boolean isLeader() {
        return this.overlordLeaderSelector.isLeader() && this.initialized;
    }

    public String getCurrentLeader() {
        return this.overlordLeaderSelector.getCurrentLeader();
    }

    public Optional<String> getRedirectLocation() {
        String leader = this.overlordLeaderSelector.getCurrentLeader();
        if (leader == null || leader.isEmpty() || this.overlordLeaderSelector.isLeader()) {
            return Optional.absent();
        }
        return Optional.of((Object)leader);
    }

    private void gracefulStopLeaderLifecycle() {
        try {
            if (this.isLeader()) {
                this.leadershipListener.stopBeingLeader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

