/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.CompactionIOConfig;
import org.apache.druid.indexing.common.task.CompactionRunner;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.CurrentSubTaskHolder;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.utils.CollectionUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.joda.time.Interval;

public class NativeCompactionRunner
implements CompactionRunner {
    public static final String TYPE = "native";
    private static final Logger log = new Logger(NativeCompactionRunner.class);
    private static final boolean STORE_COMPACTION_STATE = true;
    @JsonIgnore
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    @JsonIgnore
    private final CurrentSubTaskHolder currentSubTaskHolder = new CurrentSubTaskHolder((taskObject, config) -> {
        ParallelIndexSupervisorTask indexTask = (ParallelIndexSupervisorTask)taskObject;
        indexTask.stopGracefully((TaskConfig)config);
    });

    @JsonCreator
    public NativeCompactionRunner(@JacksonInject SegmentCacheManagerFactory segmentCacheManagerFactory) {
        this.segmentCacheManagerFactory = segmentCacheManagerFactory;
    }

    @Override
    public CurrentSubTaskHolder getCurrentSubTaskHolder() {
        return this.currentSubTaskHolder;
    }

    @Override
    public CompactionConfigValidationResult validateCompactionTask(CompactionTask compactionTask, Map<Interval, DataSchema> intervalDataSchemaMap) {
        return CompactionConfigValidationResult.success();
    }

    @VisibleForTesting
    static List<ParallelIndexIngestionSpec> createIngestionSpecs(Map<Interval, DataSchema> intervalDataSchemaMap, TaskToolbox toolbox, CompactionIOConfig ioConfig, PartitionConfigurationManager partitionConfigurationManager, CoordinatorClient coordinatorClient, SegmentCacheManagerFactory segmentCacheManagerFactory) {
        CompactionTask.CompactionTuningConfig compactionTuningConfig = partitionConfigurationManager.computeTuningConfig();
        return intervalDataSchemaMap.entrySet().stream().map(dataSchema -> new ParallelIndexIngestionSpec((DataSchema)dataSchema.getValue(), NativeCompactionRunner.createIoConfig(toolbox, (DataSchema)dataSchema.getValue(), (Interval)dataSchema.getKey(), coordinatorClient, segmentCacheManagerFactory, ioConfig), compactionTuningConfig)).collect(Collectors.toList());
    }

    private String createIndexTaskSpecId(String taskId, int i) {
        return StringUtils.format((String)"%s_%d", (Object[])new Object[]{taskId, i});
    }

    private static ParallelIndexIOConfig createIoConfig(TaskToolbox toolbox, DataSchema dataSchema, Interval interval, CoordinatorClient coordinatorClient, SegmentCacheManagerFactory segmentCacheManagerFactory, CompactionIOConfig compactionIOConfig) {
        Granularity segmentGranularity;
        Interval widenedInterval;
        if (!compactionIOConfig.isAllowNonAlignedInterval() && !interval.equals((Object)(widenedInterval = Intervals.utc((long)(segmentGranularity = dataSchema.getGranularitySpec().getSegmentGranularity()).bucketStart(interval.getStart()).getMillis(), (long)segmentGranularity.bucketEnd(interval.getEnd().minus(1L)).getMillis())))) {
            throw new IAE("Interval[%s] to compact is not aligned with segmentGranularity[%s]", new Object[]{interval, segmentGranularity});
        }
        return new ParallelIndexIOConfig(new DruidInputSource(dataSchema.getDataSource(), interval, null, null, null, null, toolbox.getIndexIO(), coordinatorClient, segmentCacheManagerFactory, toolbox.getConfig()).withTaskToolbox(toolbox), null, false, compactionIOConfig.isDropExisting());
    }

    @Override
    public TaskStatus runCompactionTasks(CompactionTask compactionTask, Map<Interval, DataSchema> intervalDataSchemaMap, TaskToolbox taskToolbox) throws Exception {
        PartitionConfigurationManager partitionConfigurationManager = new PartitionConfigurationManager(compactionTask.getTuningConfig());
        List<ParallelIndexIngestionSpec> ingestionSpecs = NativeCompactionRunner.createIngestionSpecs(intervalDataSchemaMap, taskToolbox, compactionTask.getIoConfig(), partitionConfigurationManager, taskToolbox.getCoordinatorClient(), this.segmentCacheManagerFactory);
        List<ParallelIndexSupervisorTask> subtasks = IntStream.range(0, ingestionSpecs.size()).mapToObj(i -> {
            ParallelIndexIngestionSpec ingestionSpec = (ParallelIndexIngestionSpec)((Object)((Object)ingestionSpecs.get(i)));
            String baseSequenceName = this.createIndexTaskSpecId(compactionTask.getId(), i);
            return this.newTask(compactionTask, baseSequenceName, ingestionSpec);
        }).collect(Collectors.toList());
        if (subtasks.isEmpty()) {
            String msg = StringUtils.format((String)"Can't find segments from inputSpec[%s], nothing to do.", (Object[])new Object[]{compactionTask.getIoConfig().getInputSpec()});
            log.warn(msg, new Object[0]);
            return TaskStatus.failure((String)compactionTask.getId(), (String)msg);
        }
        return this.runParallelIndexSubtasks(subtasks, taskToolbox, this.currentSubTaskHolder, compactionTask.getId());
    }

    private TaskStatus runParallelIndexSubtasks(List<ParallelIndexSupervisorTask> tasks, TaskToolbox toolbox, CurrentSubTaskHolder currentSubTaskHolder, String compactionTaskId) throws JsonProcessingException {
        int totalNumSpecs = tasks.size();
        log.info("Generated [%d] compaction task specs", new Object[]{totalNumSpecs});
        int failCnt = 0;
        TaskReport.ReportMap completionReports = new TaskReport.ReportMap();
        for (int i = 0; i < tasks.size(); ++i) {
            ParallelIndexSupervisorTask eachSpec = tasks.get(i);
            String json = toolbox.getJsonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)eachSpec);
            if (!currentSubTaskHolder.setTask(eachSpec)) {
                String errMsg = "Task was asked to stop. Finish as failed.";
                log.info(errMsg, new Object[0]);
                return TaskStatus.failure((String)compactionTaskId, (String)errMsg);
            }
            try {
                if (eachSpec.isReady(toolbox.getTaskActionClient())) {
                    log.info("Running indexSpec: " + json, new Object[0]);
                    TaskStatus eachResult = eachSpec.run(toolbox);
                    if (!eachResult.isSuccess()) {
                        ++failCnt;
                        log.warn("Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
                    }
                    String reportKeySuffix = "_" + i;
                    Optional.ofNullable(eachSpec.getCompletionReports()).ifPresent(reports -> completionReports.putAll(CollectionUtils.mapKeys((Map)reports, key -> key + reportKeySuffix)));
                    continue;
                }
                ++failCnt;
                log.warn("indexSpec is not ready: [%s].\nTrying the next indexSpec.", new Object[]{json});
                continue;
            }
            catch (Exception e) {
                ++failCnt;
                log.warn((Throwable)e, "Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
        }
        String msg = StringUtils.format((String)"Ran [%d] specs, [%d] succeeded, [%d] failed", (Object[])new Object[]{totalNumSpecs, totalNumSpecs - failCnt, failCnt});
        toolbox.getTaskReportFileWriter().write(compactionTaskId, completionReports);
        log.info(msg, new Object[0]);
        return failCnt == 0 ? TaskStatus.success((String)compactionTaskId) : TaskStatus.failure((String)compactionTaskId, (String)msg);
    }

    private ParallelIndexSupervisorTask newTask(CompactionTask compactionTask, String baseSequenceName, ParallelIndexIngestionSpec ingestionSpec) {
        return new ParallelIndexSupervisorTask(compactionTask.getId(), compactionTask.getGroupId(), compactionTask.getTaskResource(), ingestionSpec, baseSequenceName, this.createContextForSubtask(compactionTask), true);
    }

    Map<String, Object> createContextForSubtask(CompactionTask compactionTask) {
        HashMap<String, Object> newContext = new HashMap<String, Object>(compactionTask.getContext());
        newContext.put("appenderatorTrackingTaskId", compactionTask.getId());
        newContext.putIfAbsent("storeCompactionState", true);
        newContext.put("priority", compactionTask.getPriority());
        return newContext;
    }

    @VisibleForTesting
    static class PartitionConfigurationManager {
        private final CompactionTask.CompactionTuningConfig tuningConfig;

        PartitionConfigurationManager(@Nullable CompactionTask.CompactionTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
        }

        @Nullable
        CompactionTask.CompactionTuningConfig computeTuningConfig() {
            CompactionTask.CompactionTuningConfig newTuningConfig = this.tuningConfig == null ? CompactionTask.CompactionTuningConfig.defaultConfig() : this.tuningConfig;
            PartitionsSpec partitionsSpec = newTuningConfig.getGivenOrDefaultPartitionsSpec();
            if (partitionsSpec instanceof DynamicPartitionsSpec) {
                DynamicPartitionsSpec dynamicPartitionsSpec = (DynamicPartitionsSpec)partitionsSpec;
                partitionsSpec = new DynamicPartitionsSpec(dynamicPartitionsSpec.getMaxRowsPerSegment(), Long.valueOf(dynamicPartitionsSpec.getMaxTotalRowsOr(Long.MAX_VALUE)));
            }
            return newTuningConfig.withPartitionsSpec(partitionsSpec);
        }
    }
}

