/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractBatchSubtask;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class RetrieveUsedSegmentsAction
implements TaskAction<Collection<DataSegment>> {
    private static final Logger log = new Logger(RetrieveUsedSegmentsAction.class);
    private final String dataSource;
    private final List<Interval> intervals;
    private final Segments visibility;

    @JsonCreator
    public RetrieveUsedSegmentsAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") Collection<Interval> intervals, @JsonProperty(value="visibility") @Nullable Segments visibility) {
        if (CollectionUtils.isNullOrEmpty(intervals)) {
            throw InvalidInput.exception((String)"No interval specified for retrieving used segments", (Object[])new Object[0]);
        }
        this.dataSource = dataSource;
        this.intervals = JodaUtils.condenseIntervals(intervals);
        this.visibility = (Segments)Configs.valueOrDefault((Object)visibility, (Object)Segments.ONLY_VISIBLE);
    }

    public RetrieveUsedSegmentsAction(String dataSource, Collection<Interval> intervals) {
        this(dataSource, intervals, Segments.ONLY_VISIBLE);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public Segments getVisibility() {
        return this.visibility;
    }

    @Override
    public TypeReference<Collection<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Collection<DataSegment>>(){};
    }

    @Override
    public Collection<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        if (!task.getDataSource().equals(this.dataSource)) {
            return this.retrieveUsedSegments(toolbox);
        }
        String supervisorId = task instanceof AbstractBatchSubtask ? ((AbstractBatchSubtask)task).getSupervisorTaskId() : task.getId();
        Set replaceLocksForTask = toolbox.getTaskLockbox().getAllReplaceLocksForDatasource(task.getDataSource()).stream().filter(lock -> supervisorId.equals(lock.getSupervisorTaskId())).collect(Collectors.toSet());
        if (replaceLocksForTask.isEmpty()) {
            return this.retrieveUsedSegments(toolbox);
        }
        HashMap<Interval, Map> intervalToCreatedToSegments = new HashMap<Interval, Map>();
        for (Pair segmentAndCreatedDate : toolbox.getIndexerMetadataStorageCoordinator().retrieveUsedSegmentsAndCreatedDates(this.dataSource, this.intervals)) {
            DataSegment segment = (DataSegment)segmentAndCreatedDate.lhs;
            String createdDate = (String)segmentAndCreatedDate.rhs;
            intervalToCreatedToSegments.computeIfAbsent(segment.getInterval(), s -> new HashMap()).computeIfAbsent(createdDate, c -> new HashSet()).add(segment);
        }
        HashSet<DataSegment> allSegmentsToBeReplaced = new HashSet<DataSegment>();
        for (Map.Entry entry : intervalToCreatedToSegments.entrySet()) {
            Interval segmentInterval = (Interval)entry.getKey();
            String lockVersion = null;
            for (ReplaceTaskLock replaceLock : replaceLocksForTask) {
                if (!replaceLock.getInterval().contains((ReadableInterval)segmentInterval)) continue;
                lockVersion = replaceLock.getVersion();
                break;
            }
            Map createdToSegmentsMap = (Map)entry.getValue();
            for (Map.Entry createdAndSegments : createdToSegmentsMap.entrySet()) {
                if (lockVersion == null || lockVersion.compareTo((String)createdAndSegments.getKey()) > 0) {
                    allSegmentsToBeReplaced.addAll((Collection)createdAndSegments.getValue());
                    continue;
                }
                for (DataSegment segment : (Set)createdAndSegments.getValue()) {
                    log.info("Ignoring segment[%s] as it has created_date[%s] greater than the REPLACE lock version[%s]", new Object[]{segment.getId(), createdAndSegments.getKey(), lockVersion});
                }
            }
        }
        if (this.visibility == Segments.ONLY_VISIBLE) {
            return SegmentTimeline.forSegments(allSegmentsToBeReplaced).findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE);
        }
        return allSegmentsToBeReplaced;
    }

    private Set<DataSegment> retrieveUsedSegments(TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().retrieveUsedSegmentsForIntervals(this.dataSource, this.intervals, this.visibility);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveUsedSegmentsAction that = (RetrieveUsedSegmentsAction)o;
        if (!this.dataSource.equals(that.dataSource)) {
            return false;
        }
        if (!this.intervals.equals(that.intervals)) {
            return false;
        }
        return this.visibility.equals((Object)that.visibility);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.intervals, this.visibility);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + '\'' + ", intervals=" + this.intervals + ", visibility=" + this.visibility + '}';
    }
}

