/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Set;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.UpgradedToSegmentsResponse;
import org.apache.druid.indexing.common.task.Task;

public class RetrieveUpgradedToSegmentIdsAction
implements TaskAction<UpgradedToSegmentsResponse> {
    private final String dataSource;
    private final Set<String> segmentIds;

    @JsonCreator
    public RetrieveUpgradedToSegmentIdsAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
        this.dataSource = dataSource;
        this.segmentIds = segmentIds;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Set<String> getSegmentIds() {
        return this.segmentIds;
    }

    @Override
    public TypeReference<UpgradedToSegmentsResponse> getReturnTypeReference() {
        return new TypeReference<UpgradedToSegmentsResponse>(){};
    }

    @Override
    public UpgradedToSegmentsResponse perform(Task task, TaskActionToolbox toolbox) {
        return new UpgradedToSegmentsResponse(toolbox.getIndexerMetadataStorageCoordinator().retrieveUpgradedToSegmentIds(this.dataSource, this.segmentIds));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + '\'' + ", segmentIds=" + this.segmentIds + '}';
    }
}

