/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.cronscheduler;

import io.timeandspace.cronscheduler.CronSchedulerBuilder;
import io.timeandspace.cronscheduler.CronTask;
import io.timeandspace.cronscheduler.DefaultCronSchedulerThreadFactory;
import io.timeandspace.cronscheduler.FixedRatePeriodicScheduling;
import io.timeandspace.cronscheduler.OneShotTasksShutdownPolicy;
import io.timeandspace.cronscheduler.RoundWallTimeInDayPeriodicScheduling;
import io.timeandspace.cronscheduler.ScheduledThreadPoolExecutor;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CronScheduler
extends ScheduledThreadPoolExecutor {
    static final Duration MIN_SYNC_PERIOD = Duration.ofSeconds(1L);
    private static final int MIN_ROUND_TIMES_IN_DAY_PERIOD_SECONDS = 5;
    private static final long SECONDS_IN_DAY = TimeUnit.DAYS.toSeconds(1L);
    static final Duration MAX_SYNC_PERIOD = Duration.ofDays(1L);
    static final Consumer<String> DEFAULT_BACKWARD_TIME_SHIFT_LOGGER = message -> System.err.println((String)message);

    @Override
    public boolean isThreadRunning() {
        return super.isThreadRunning();
    }

    static void checkSyncPeriod(Duration syncPeriod) {
        Objects.requireNonNull(syncPeriod);
        if (syncPeriod.compareTo(MIN_SYNC_PERIOD) < 0 || syncPeriod.compareTo(MAX_SYNC_PERIOD) > 0) {
            throw new IllegalArgumentException(String.format("syncPeriod is outside of allowed range [%s, %s]: %s", MIN_SYNC_PERIOD, MAX_SYNC_PERIOD, syncPeriod));
        }
    }

    public static CronSchedulerBuilder newBuilder(Duration syncPeriod) {
        return new CronSchedulerBuilder(syncPeriod);
    }

    public static CronScheduler create(Duration syncPeriod) {
        return new CronScheduler(Clock.systemUTC(), syncPeriod, DefaultCronSchedulerThreadFactory.INSTANCE);
    }

    private CronScheduler(Clock clock, Duration syncPeriod, ThreadFactory threadFactory) {
        super(clock, syncPeriod, threadFactory, DEFAULT_BACKWARD_TIME_SHIFT_LOGGER);
    }

    CronScheduler(CronSchedulerBuilder builder) {
        super(builder.getTimeProvider(), builder.getSyncPeriod(), builder.getThreadFactory(), builder.getBackwardTimeShiftLogger());
    }

    public Future<?> scheduleAt(Instant triggerTime, Runnable command) {
        Objects.requireNonNull(triggerTime);
        Objects.requireNonNull(command);
        ScheduledThreadPoolExecutor.ScheduledFutureTask<Object> t = new ScheduledThreadPoolExecutor.ScheduledFutureTask<Object>(this, command, null, triggerTime.toEpochMilli());
        this.delayedExecute(t);
        return t;
    }

    public <V> Future<V> scheduleAt(Instant triggerTime, Callable<V> callable) {
        Objects.requireNonNull(triggerTime);
        Objects.requireNonNull(callable);
        ScheduledThreadPoolExecutor.ScheduledFutureTask<V> t = new ScheduledThreadPoolExecutor.ScheduledFutureTask<V>(this, callable, triggerTime.toEpochMilli());
        this.delayedExecute(t);
        return t;
    }

    public Future<?> scheduleAtRoundTimesInDay(Duration period, ZoneId zoneId, CronTask task) {
        return this.scheduleAtRoundTimesInDay(period, zoneId, task, false);
    }

    public Future<?> scheduleAtRoundTimesInDaySkippingToLatest(Duration period, ZoneId zoneId, CronTask task) {
        return this.scheduleAtRoundTimesInDay(period, zoneId, task, true);
    }

    Future<?> scheduleAtRoundTimesInDay(Duration period, ZoneId zoneId, CronTask task, boolean skippingToLatest) {
        Objects.requireNonNull(period);
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(task);
        long periodSeconds = CronScheduler.toSeconds(period);
        if (!Duration.ofSeconds(periodSeconds).equals(period)) {
            throw new IllegalArgumentException(period + " should be an integral number of seconds");
        }
        if (periodSeconds < 5L || SECONDS_IN_DAY % periodSeconds != 0L) {
            throw new IllegalArgumentException("period should be no less than 5 seconds and be an integral part of a day, " + period + " given");
        }
        RoundWallTimeInDayPeriodicScheduling periodicScheduling = new RoundWallTimeInDayPeriodicScheduling(this.timeProvider, task, zoneId, periodSeconds, skippingToLatest);
        ScheduledThreadPoolExecutor.ScheduledFutureTask sft = new ScheduledThreadPoolExecutor.ScheduledFutureTask(this, periodicScheduling);
        this.delayedExecute(sft);
        return sft;
    }

    private static long toSeconds(Duration period) {
        return TimeUnit.MILLISECONDS.toSeconds(period.toMillis());
    }

    public Future<?> scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, CronTask task) {
        return this.scheduleAtFixedRate(initialDelay, period, unit, task, false);
    }

    public Future<?> scheduleAtFixedRateSkippingToLatest(long initialDelay, long period, TimeUnit unit, CronTask task) {
        return this.scheduleAtFixedRate(initialDelay, period, unit, task, true);
    }

    private Future<?> scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, CronTask task, boolean skippingToLatest) {
        Objects.requireNonNull(task);
        Objects.requireNonNull(unit);
        if (unit == TimeUnit.NANOSECONDS || unit == TimeUnit.MICROSECONDS) {
            throw new IllegalArgumentException("unit must be at least milliseconds, " + (Object)((Object)unit) + " given");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be positive, " + period + " given");
        }
        long initialDelayMillis = unit.toMillis(initialDelay);
        if (Math.abs(initialDelayMillis) > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("initial delay out of reasonable bounds: " + initialDelay + " " + (Object)((Object)unit));
        }
        long triggerTimeMillis = Math.max(initialDelayMillis, 0L) + this.timeProvider.millis();
        FixedRatePeriodicScheduling periodicScheduling = new FixedRatePeriodicScheduling(this.timeProvider, task, triggerTimeMillis, unit.toMillis(period), skippingToLatest);
        ScheduledThreadPoolExecutor.ScheduledFutureTask sft = new ScheduledThreadPoolExecutor.ScheduledFutureTask(this, periodicScheduling);
        this.delayedExecute(sft);
        return sft;
    }

    public ScheduledExecutorService asScheduledExecutorService() {
        return new ScheduledExecutorServiceAdapter();
    }

    @Override
    public void shutdown(OneShotTasksShutdownPolicy oneShotTasksShutdownPolicy) {
        super.shutdown(oneShotTasksShutdownPolicy);
    }

    private class ScheduledExecutorServiceAdapter
    extends AbstractExecutorService
    implements ScheduledExecutorService {
        private ScheduledExecutorServiceAdapter() {
        }

        @Override
        public void execute(@NotNull Runnable command) {
            CronScheduler.this.scheduleAt(CronScheduler.this.timeProvider.instant(), command);
        }

        @Override
        public void shutdown() {
            CronScheduler.this.shutdown(OneShotTasksShutdownPolicy.EXECUTE_DELAYED);
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return CronScheduler.this.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return CronScheduler.this.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return CronScheduler.this.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return CronScheduler.this.awaitTermination(timeout, unit);
        }

        @Override
        @NotNull
        public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
            return (ScheduledThreadPoolExecutor.ScheduledFutureTask)CronScheduler.this.scheduleAt(CronScheduler.this.timeProvider.instant().plus(unit.toNanos(delay), ChronoUnit.NANOS), command);
        }

        @Override
        @NotNull
        public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
            return (ScheduledThreadPoolExecutor.ScheduledFutureTask)CronScheduler.this.scheduleAt(CronScheduler.this.timeProvider.instant().plus(unit.toNanos(delay), ChronoUnit.NANOS), callable);
        }

        @Override
        @NotNull
        public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
            Objects.requireNonNull(command);
            return (ScheduledThreadPoolExecutor.ScheduledFutureTask)CronScheduler.this.scheduleAtFixedRate(initialDelay, period, unit, (long t) -> command.run());
        }

        @Override
        @NotNull
        public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
            Objects.requireNonNull(command);
            Objects.requireNonNull(unit);
            throw new UnsupportedOperationException("scheduleWithFixedDelay is not supported");
        }

        public String toString() {
            return "ScheduledExecutorServiceAdapter[" + CronScheduler.this.toString() + "]";
        }
    }
}

