/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.DruidNode;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

public class RestUpdateSender
implements Consumer<byte[]> {
    private static final EmittingLogger LOG = new EmittingLogger(RestUpdateSender.class);
    private final String callerName;
    private final Supplier<Iterable<DruidNode>> destinationSupplier;
    private final String baseUrl;
    private final RestSender sender;
    private final long cacheNotificationsTimeoutMs;

    public RestUpdateSender(String callerName, Supplier<Iterable<DruidNode>> destinationSupplier, RestSender sender, String baseUrl, long cacheNotificationsTimeoutMs) {
        this.callerName = callerName;
        this.destinationSupplier = destinationSupplier;
        this.sender = sender;
        this.baseUrl = baseUrl;
        this.cacheNotificationsTimeoutMs = cacheNotificationsTimeoutMs;
    }

    public static RestSender httpClientSender(HttpClient httpClient, Duration cacheNotificationsTimeou) {
        return new HttpClientSender(httpClient, cacheNotificationsTimeou);
    }

    @Override
    public void accept(byte[] serializedEntity) {
        LOG.debug(this.callerName + ": Sending update notifications", new Object[0]);
        ArrayList<ListenableFuture<StatusResponseHolder>> futures = new ArrayList<ListenableFuture<StatusResponseHolder>>();
        for (DruidNode node : this.destinationSupplier.get()) {
            futures.add(this.sender.send(this.getListenerURL(node, this.baseUrl), serializedEntity));
        }
        try {
            List<StatusResponseHolder> responses = this.getResponsesFromFutures(futures);
            for (StatusResponseHolder response : responses) {
                if (response == null) {
                    LOG.error("Got null future response from update request.", new Object[0]);
                    continue;
                }
                HttpResponseStatus status = response.getStatus();
                if (HttpResponseStatus.OK.equals((Object)status) || HttpResponseStatus.ACCEPTED.equals((Object)status)) {
                    LOG.debug("Got status [%s]", new Object[]{status});
                    continue;
                }
                LOG.error("Got error status [%s], content [%s]", new Object[]{status, response.getContent()});
            }
        }
        catch (Exception e) {
            LOG.makeAlert((Throwable)e, this.callerName + ": Failed to get response for cache notification.", new Object[0]).emit();
        }
        LOG.debug(this.callerName + ": Received responses for cache update notifications.", new Object[0]);
    }

    @VisibleForTesting
    List<StatusResponseHolder> getResponsesFromFutures(List<ListenableFuture<StatusResponseHolder>> futures) throws InterruptedException, ExecutionException, TimeoutException {
        return (List)Futures.successfulAsList(futures).get(this.cacheNotificationsTimeoutMs, TimeUnit.MILLISECONDS);
    }

    private URL getListenerURL(DruidNode druidNode, String baseUrl) {
        try {
            return new URL(druidNode.getServiceScheme(), druidNode.getHost(), druidNode.getPortToUse(), baseUrl);
        }
        catch (MalformedURLException mue) {
            String msg = StringUtils.format((String)(this.callerName + ": Malformed url for DruidNode [%s] and baseUrl [%s]"), (Object[])new Object[]{druidNode, baseUrl});
            LOG.error(msg, new Object[0]);
            throw new RE((Throwable)mue, msg, new Object[0]);
        }
    }

    private static class HttpClientSender
    implements RestSender {
        private final HttpClient httpClient;
        private final Duration cacheNotificationsTimeout;

        private HttpClientSender(HttpClient httpClient, Duration cacheNotificationsTimeout) {
            this.httpClient = httpClient;
            this.cacheNotificationsTimeout = cacheNotificationsTimeout;
        }

        @Override
        public ListenableFuture<StatusResponseHolder> send(URL listenerURL, byte[] serializedEntity) {
            return this.httpClient.go(new Request(HttpMethod.POST, listenerURL).setContent("application/x-jackson-smile", serializedEntity), (HttpResponseHandler)StatusResponseHandler.getInstance(), this.cacheNotificationsTimeout);
        }
    }

    public static interface RestSender {
        public ListenableFuture<StatusResponseHolder> send(URL var1, byte[] var2);
    }
}

