/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.kinesis.KinesisRecordEntity;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.kinesis.KinesisDataSourceMetadata;
import org.apache.druid.indexing.kinesis.KinesisIndexTask;
import org.apache.druid.indexing.kinesis.KinesisSequenceNumber;
import org.apache.druid.indexing.seekablestream.SeekableStreamDataSourceMetadata;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SequenceMetadata;
import org.apache.druid.indexing.seekablestream.common.OrderedPartitionableRecord;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.security.AuthorizerMapper;

public class KinesisIndexTaskRunner
extends SeekableStreamIndexTaskRunner<String, String, KinesisRecordEntity> {
    private static final EmittingLogger log = new EmittingLogger(KinesisIndexTaskRunner.class);
    private static final long POLL_TIMEOUT = 100L;
    private final KinesisIndexTask task;

    KinesisIndexTaskRunner(KinesisIndexTask task, @Nullable InputRowParser<ByteBuffer> parser, AuthorizerMapper authorizerMapper, LockGranularity lockGranularityToUse) {
        super((SeekableStreamIndexTask)task, parser, authorizerMapper, lockGranularityToUse);
        this.task = task;
    }

    protected String getNextStartOffset(String sequenceNumber) {
        return sequenceNumber;
    }

    @Nonnull
    protected List<OrderedPartitionableRecord<String, String, KinesisRecordEntity>> getRecords(RecordSupplier<String, String, KinesisRecordEntity> recordSupplier, TaskToolbox toolbox) {
        return recordSupplier.poll(100L);
    }

    protected SeekableStreamEndSequenceNumbers<String, String> deserializePartitionsFromMetadata(ObjectMapper mapper, Object object) {
        return (SeekableStreamEndSequenceNumbers)mapper.convertValue(object, mapper.getTypeFactory().constructParametrizedType(SeekableStreamEndSequenceNumbers.class, SeekableStreamEndSequenceNumbers.class, new Class[]{String.class, String.class}));
    }

    protected SeekableStreamDataSourceMetadata<String, String> createDataSourceMetadata(SeekableStreamSequenceNumbers<String, String> partitions) {
        return new KinesisDataSourceMetadata(partitions);
    }

    protected OrderedSequenceNumber<String> createSequenceNumber(String sequenceNumber) {
        return KinesisSequenceNumber.of(sequenceNumber);
    }

    protected void possiblyResetDataSourceMetadata(TaskToolbox toolbox, RecordSupplier<String, String, KinesisRecordEntity> recordSupplier, Set<StreamPartition<String>> assignment) {
        if (!this.task.getTuningConfig().isSkipSequenceNumberAvailabilityCheck()) {
            ConcurrentMap currOffsets = this.getCurrentOffsets();
            HashMap<StreamPartition<String>, String> partitionToSequenceResetMap = new HashMap<StreamPartition<String>, String>();
            for (StreamPartition<String> streamPartition : assignment) {
                String sequence;
                if (recordSupplier.isOffsetAvailable(streamPartition, (OrderedSequenceNumber)KinesisSequenceNumber.of(sequence = (String)currOffsets.get(streamPartition.getPartitionId())))) continue;
                partitionToSequenceResetMap.put(streamPartition, sequence);
            }
            if (!partitionToSequenceResetMap.isEmpty()) {
                for (Map.Entry entry : partitionToSequenceResetMap.entrySet()) {
                    log.warn("Starting sequenceNumber[%s] is no longer available for partition[%s].", new Object[]{entry.getValue(), entry.getKey()});
                }
                if (this.task.getTuningConfig().isResetOffsetAutomatically()) {
                    log.info("Attempting to reset offsets for [%d] partitions with ids[%s].", new Object[]{partitionToSequenceResetMap.size(), partitionToSequenceResetMap.keySet()});
                    try {
                        this.sendResetRequestAndWait(partitionToSequenceResetMap, toolbox);
                    }
                    catch (IOException e) {
                        throw new ISE((Throwable)e, "Exception while attempting to automatically reset sequences for partitions[%s]", new Object[]{partitionToSequenceResetMap.keySet()});
                    }
                } else {
                    throw new ISE("Automatic offset reset is disabled, but there are partitions with unavailable sequence numbers [%s].", new Object[]{partitionToSequenceResetMap});
                }
            }
        }
    }

    protected boolean isEndOffsetExclusive() {
        return false;
    }

    protected boolean isEndOfShard(String seqNum) {
        return "EOS".equals(seqNum);
    }

    public TypeReference<List<SequenceMetadata<String, String>>> getSequenceMetadataTypeReference() {
        return new TypeReference<List<SequenceMetadata<String, String>>>(){};
    }

    @Nullable
    protected TreeMap<Integer, Map<String, String>> getCheckPointsFromContext(TaskToolbox toolbox, String checkpointsString) throws IOException {
        if (checkpointsString != null) {
            log.debug("Got checkpoints from task context[%s]", new Object[]{checkpointsString});
            return (TreeMap)toolbox.getJsonMapper().readValue(checkpointsString, (TypeReference)new TypeReference<TreeMap<Integer, Map<String, String>>>(){});
        }
        return null;
    }
}

