/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;

public class PartialKeyStatisticsInformation {
    private final Set<Long> timeSegments;
    private final boolean multipleValues;
    private final double bytesRetained;

    @JsonCreator
    public PartialKeyStatisticsInformation(@JsonProperty(value="timeSegments") Set<Long> timeSegments, @JsonProperty(value="multipleValues") boolean hasMultipleValues, @JsonProperty(value="bytesRetained") double bytesRetained) {
        this.timeSegments = timeSegments;
        this.multipleValues = hasMultipleValues;
        this.bytesRetained = bytesRetained;
    }

    @JsonProperty(value="timeSegments")
    public Set<Long> getTimeSegments() {
        return this.timeSegments;
    }

    @JsonProperty(value="multipleValues")
    public boolean hasMultipleValues() {
        return this.multipleValues;
    }

    @JsonProperty(value="bytesRetained")
    public double getBytesRetained() {
        return this.bytesRetained;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialKeyStatisticsInformation that = (PartialKeyStatisticsInformation)o;
        return this.multipleValues == that.multipleValues && Double.compare(this.bytesRetained, that.bytesRetained) == 0 && Objects.equals(this.timeSegments, that.timeSegments);
    }

    public int hashCode() {
        return Objects.hash(this.timeSegments, this.multipleValues, this.bytesRetained);
    }

    public String toString() {
        return "PartialKeyStatisticsInformation{timeSegments=" + this.timeSegments + ", multipleValues=" + this.multipleValues + ", bytesRetained=" + this.bytesRetained + '}';
    }
}

