/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.Forbidden;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.error.NotFound;
import org.apache.druid.error.QueryExceptionCompat;
import org.apache.druid.frame.channel.FrameChannelSequence;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.destination.DurableStorageMSQDestination;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.shuffle.input.DurableStorageInputChannelFactory;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.msq.sql.SqlStatementState;
import org.apache.druid.msq.sql.entity.ColumnNameAndTypes;
import org.apache.druid.msq.sql.entity.PageInformation;
import org.apache.druid.msq.sql.entity.ResultSetInformation;
import org.apache.druid.msq.sql.entity.SqlStatementResult;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.msq.util.SqlStatementResourceHelper;
import org.apache.druid.query.ExecutionMode;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryException;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.storage.NilStorageConnector;
import org.apache.druid.storage.StorageConnector;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@Path(value="/druid/v2/sql/statements/")
public class SqlStatementResource {
    public static final String RESULT_FORMAT = "__resultFormat";
    private static final Logger log = new Logger(SqlStatementResource.class);
    private final SqlStatementFactory msqSqlStatementFactory;
    private final ObjectMapper jsonMapper;
    private final OverlordClient overlordClient;
    private final StorageConnector storageConnector;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public SqlStatementResource(@MultiStageQuery SqlStatementFactory msqSqlStatementFactory, ObjectMapper jsonMapper, OverlordClient overlordClient, @MultiStageQuery StorageConnector storageConnector, AuthorizerMapper authorizerMapper) {
        this.msqSqlStatementFactory = msqSqlStatementFactory;
        this.jsonMapper = jsonMapper;
        this.overlordClient = overlordClient;
        this.storageConnector = storageConnector;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public Response isEnabled(@Context HttpServletRequest request) {
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        return Response.ok((Object)ImmutableMap.of((Object)"enabled", (Object)true)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) {
        Response response;
        Response plan;
        SqlQuery modifiedQuery = this.createModifiedSqlQuery(sqlQuery);
        HttpStatement stmt = this.msqSqlStatementFactory.httpStatement(modifiedQuery, req);
        String sqlQueryId = stmt.sqlQueryId();
        String currThreadName = Thread.currentThread().getName();
        boolean isDebug = false;
        try {
            QueryContext queryContext = QueryContext.of((Map)modifiedQuery.getContext());
            isDebug = queryContext.isDebug();
            this.contextChecks(queryContext);
            Thread.currentThread().setName(StringUtils.format((String)"statement_sql[%s]", (Object[])new Object[]{sqlQueryId}));
            plan = stmt.plan();
            QueryResponse response2 = plan.run();
            Sequence sequence = response2.getResults();
            SqlRowTransformer rowTransformer = plan.createRowTransformer();
            boolean isTaskStruct = MSQTaskSqlEngine.TASK_STRUCT_FIELD_NAMES.equals(rowTransformer.getFieldList());
            if (isTaskStruct) {
                Response response3 = this.buildTaskResponse((Sequence<Object[]>)sequence, stmt.query().authResult());
                return response3;
            }
            Response response4 = this.buildStandardResponse((Sequence<Object[]>)sequence, modifiedQuery, sqlQueryId, rowTransformer);
            return response4;
        }
        catch (DruidException e) {
            stmt.reporter().failed((Throwable)e);
            plan = this.buildNonOkResponse(e);
            return plan;
        }
        catch (QueryException queryException) {
            stmt.reporter().failed((Throwable)queryException);
            DruidException underlyingException = DruidException.fromFailure((DruidException.Failure)new QueryExceptionCompat(queryException));
            Response response5 = this.buildNonOkResponse(underlyingException);
            return response5;
        }
        catch (ForbiddenException e) {
            log.debug("Got forbidden request for reason [%s]", new Object[]{e.getErrorMessage()});
            response = this.buildNonOkResponse(Forbidden.exception());
            return response;
        }
        catch (AssertionError | Exception e) {
            stmt.reporter().failed((Throwable)e);
            if (isDebug) {
                log.warn((Throwable)e, "Failed to handle query [%s]", new Object[]{sqlQueryId});
            } else {
                log.noStackTrace().warn((Throwable)e, "Failed to handle query [%s]", new Object[]{sqlQueryId});
            }
            response = this.buildNonOkResponse(DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build("%s", new Object[]{((Throwable)e).getMessage()}));
            return response;
        }
        finally {
            stmt.close();
            Thread.currentThread().setName(currThreadName);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response doGetStatus(@PathParam(value="id") String queryId, @QueryParam(value="detail") boolean detail, @Context HttpServletRequest req) {
        try {
            AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)req);
            AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req);
            Optional<SqlStatementResult> sqlStatementResult = this.getStatementStatus(queryId, authenticationResult, true, Action.READ, detail);
            if (sqlStatementResult.isPresent()) {
                return Response.ok().entity((Object)sqlStatementResult.get()).build();
            }
            throw SqlStatementResource.queryNotFoundException(queryId);
        }
        catch (DruidException e) {
            return this.buildNonOkResponse(e);
        }
        catch (ForbiddenException e) {
            log.debug("Got forbidden request for reason [%s]", new Object[]{e.getErrorMessage()});
            return this.buildNonOkResponse(Forbidden.exception());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId});
            return this.buildNonOkResponse(DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId}));
        }
    }

    @GET
    @Path(value="/{id}/results")
    @Produces(value={"application/json"})
    public Response doGetResults(@PathParam(value="id") String queryId, @QueryParam(value="page") Long page, @QueryParam(value="resultFormat") String resultFormat, @Context HttpServletRequest req) {
        try {
            AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)req);
            AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req);
            if (page != null && page < 0L) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Page cannot be negative. Please pass a positive number.", new Object[0]);
            }
            TaskStatusResponse taskResponse = (TaskStatusResponse)this.contactOverlord(this.overlordClient.taskStatus(queryId), queryId);
            if (taskResponse == null) {
                throw SqlStatementResource.queryNotFoundException(queryId);
            }
            TaskStatusPlus statusPlus = taskResponse.getStatus();
            if (statusPlus == null || !"query_controller".equals(statusPlus.getType())) {
                throw SqlStatementResource.queryNotFoundException(queryId);
            }
            MSQControllerTask msqControllerTask = this.getMSQControllerTaskAndCheckPermission(queryId, authenticationResult, Action.READ);
            SqlStatementResource.throwIfQueryIsNotSuccessful(queryId, statusPlus);
            Optional<List<ColumnNameAndTypes>> signature = SqlStatementResourceHelper.getSignature(msqControllerTask);
            if (!signature.isPresent() || MSQControllerTask.isIngestion(msqControllerTask.getQuerySpec())) {
                return Response.ok().build();
            }
            Closer closer = Closer.create();
            Optional<Yielder<Object[]>> results = this.getResultYielder(queryId, page, msqControllerTask, closer);
            if (!results.isPresent()) {
                return Response.ok().build();
            }
            ResultFormat preferredFormat = this.getPreferredResultFormat(resultFormat, msqControllerTask.getQuerySpec());
            return Response.ok(outputStream -> this.resultPusher(queryId, signature, closer, results, new CountingOutputStream(outputStream), preferredFormat)).build();
        }
        catch (DruidException e) {
            return this.buildNonOkResponse(e);
        }
        catch (ForbiddenException e) {
            log.debug("Got forbidden request for reason [%s]", new Object[]{e.getErrorMessage()});
            return this.buildNonOkResponse(Forbidden.exception());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId});
            return this.buildNonOkResponse(DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId}));
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        try {
            AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)req);
            AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req);
            Optional<SqlStatementResult> sqlStatementResult = this.getStatementStatus(queryId, authenticationResult, false, Action.WRITE, false);
            if (sqlStatementResult.isPresent()) {
                switch (sqlStatementResult.get().getState()) {
                    case ACCEPTED: 
                    case RUNNING: {
                        this.overlordClient.cancelTask(queryId);
                        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
                    }
                    case SUCCESS: 
                    case FAILED: {
                        return Response.ok().build();
                    }
                }
                throw new ISE("Illegal State[%s] encountered", new Object[]{sqlStatementResult.get().getState()});
            }
            throw SqlStatementResource.queryNotFoundException(queryId);
        }
        catch (DruidException e) {
            return this.buildNonOkResponse(e);
        }
        catch (ForbiddenException e) {
            log.debug("Got forbidden request for reason [%s]", new Object[]{e.getErrorMessage()});
            return this.buildNonOkResponse(Forbidden.exception());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId});
            return this.buildNonOkResponse(DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "Failed to handle query [%s]", new Object[]{queryId}));
        }
    }

    private Response buildStandardResponse(Sequence<Object[]> sequence, SqlQuery sqlQuery, String sqlQueryId, SqlRowTransformer rowTransformer) throws IOException {
        Yielder yielder0 = Yielders.each(sequence);
        try {
            Response.ResponseBuilder responseBuilder = Response.ok(outputStream -> {
                CountingOutputStream os = new CountingOutputStream(outputStream);
                try (Yielder yielder = yielder0;
                     ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, this.jsonMapper);){
                    writer.writeResponseStart();
                    if (sqlQuery.includeHeader()) {
                        writer.writeHeader(rowTransformer.getRowType(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader());
                    }
                    while (!yielder.isDone()) {
                        Object[] row = (Object[])yielder.get();
                        writer.writeRowStart();
                        for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                            Object value = rowTransformer.transform(row, i);
                            writer.writeRowField((String)rowTransformer.getFieldList().get(i), value);
                        }
                        writer.writeRowEnd();
                        yielder = yielder.next(null);
                    }
                    writer.writeResponseEnd();
                }
            });
            if (sqlQuery.includeHeader()) {
                responseBuilder.header("X-Druid-SQL-Header-Included", (Object)"yes");
            }
            return responseBuilder.build();
        }
        catch (Throwable e) {
            yielder0.close();
            throw e;
        }
    }

    private Response buildTaskResponse(Sequence<Object[]> sequence, AuthenticationResult authenticationResult) {
        List rows = sequence.toList();
        int numRows = rows.size();
        if (numRows != 1) {
            throw new RE("Expected a single row but got [%d] rows. Please check broker logs for more information.", new Object[]{numRows});
        }
        Object[] firstRow = (Object[])rows.get(0);
        if (firstRow == null || firstRow.length != 1) {
            throw new RE("Expected a single column but got [%s] columns. Please check broker logs for more information.", new Object[]{firstRow == null ? 0 : firstRow.length});
        }
        String taskId = String.valueOf(firstRow[0]);
        Optional<SqlStatementResult> statementResult = this.getStatementStatus(taskId, authenticationResult, true, Action.READ, false);
        if (statementResult.isPresent()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)statementResult.get()).build();
        }
        return this.buildNonOkResponse(DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("Unable to find associated task for query id [%s]. Contact cluster admin to check overlord logs for [%s]", new Object[]{taskId, taskId}));
    }

    private Response buildNonOkResponse(DruidException exception) {
        return Response.status((int)exception.getStatusCode()).entity((Object)new ErrorResponse(exception)).build();
    }

    private Optional<ResultSetInformation> getResultSetInformation(String queryId, String dataSource, SqlStatementState sqlStatementState, MSQDestination msqDestination) {
        if (sqlStatementState == SqlStatementState.SUCCESS) {
            MSQTaskReportPayload msqTaskReportPayload = SqlStatementResourceHelper.getPayload((TaskReport.ReportMap)this.contactOverlord(this.overlordClient.taskReportAsMap(queryId), queryId));
            Optional<List<PageInformation>> pageList = SqlStatementResourceHelper.populatePageList(msqTaskReportPayload, msqDestination);
            Long rows = null;
            Long size = null;
            if (pageList.isPresent()) {
                rows = 0L;
                size = 0L;
                for (PageInformation pageInformation : pageList.get()) {
                    rows = rows + (pageInformation.getNumRows() != null ? pageInformation.getNumRows() : 0L);
                    size = size + (pageInformation.getSizeInBytes() != null ? pageInformation.getSizeInBytes() : 0L);
                }
            }
            boolean isSelectQuery = msqDestination instanceof TaskReportMSQDestination || msqDestination instanceof DurableStorageMSQDestination;
            List<Object[]> results = null;
            if (isSelectQuery) {
                results = new ArrayList<Object[]>();
                if (msqTaskReportPayload.getResults() != null) {
                    results = msqTaskReportPayload.getResults().getResults();
                }
            }
            return Optional.of(new ResultSetInformation(rows, size, null, dataSource, results, isSelectQuery ? (List)pageList.orElse(null) : null));
        }
        return Optional.empty();
    }

    private Optional<SqlStatementResult> getStatementStatus(String queryId, AuthenticationResult authenticationResult, boolean withResults, Action forAction, boolean detail) throws DruidException {
        MSQTaskReportPayload taskReportPayload;
        SqlStatementState sqlStatementState;
        MSQControllerTask msqControllerTask;
        TaskStatusPlus statusPlus;
        TaskStatusResponse taskResponse;
        block6: {
            taskResponse = (TaskStatusResponse)this.contactOverlord(this.overlordClient.taskStatus(queryId), queryId);
            if (taskResponse == null) {
                return Optional.empty();
            }
            statusPlus = taskResponse.getStatus();
            if (statusPlus == null || !"query_controller".equals(statusPlus.getType())) {
                return Optional.empty();
            }
            msqControllerTask = this.getMSQControllerTaskAndCheckPermission(queryId, authenticationResult, forAction);
            sqlStatementState = SqlStatementResourceHelper.getSqlStatementState(statusPlus);
            taskReportPayload = null;
            if (detail || SqlStatementState.FAILED == sqlStatementState) {
                try {
                    taskReportPayload = SqlStatementResourceHelper.getPayload((TaskReport.ReportMap)this.contactOverlord(this.overlordClient.taskReportAsMap(queryId), queryId));
                }
                catch (DruidException e) {
                    if (e.getErrorCode().equals("notFound") || e.getMessage().contains("Unable to contact overlord")) break block6;
                    throw e;
                }
            }
        }
        if (SqlStatementState.FAILED == sqlStatementState) {
            return SqlStatementResourceHelper.getExceptionPayload(queryId, taskResponse, statusPlus, sqlStatementState, taskReportPayload, this.jsonMapper, detail);
        }
        Optional<List<ColumnNameAndTypes>> signature = SqlStatementResourceHelper.getSignature(msqControllerTask);
        return Optional.of(new SqlStatementResult(queryId, sqlStatementState, taskResponse.getStatus().getCreatedTime(), signature.orElse(null), taskResponse.getStatus().getDuration(), withResults ? (ResultSetInformation)this.getResultSetInformation(queryId, msqControllerTask.getDataSource(), sqlStatementState, msqControllerTask.getQuerySpec().getDestination()).orElse(null) : null, null, SqlStatementResourceHelper.getQueryStagesReport(taskReportPayload), SqlStatementResourceHelper.getQueryCounters(taskReportPayload), SqlStatementResourceHelper.getQueryWarningDetails(taskReportPayload)));
    }

    private MSQControllerTask getMSQControllerTaskAndCheckPermission(String queryId, AuthenticationResult authenticationResult, Action forAction) throws ForbiddenException {
        TaskPayloadResponse taskPayloadResponse = (TaskPayloadResponse)this.contactOverlord(this.overlordClient.taskPayload(queryId), queryId);
        SqlStatementResourceHelper.isMSQPayload(taskPayloadResponse, queryId);
        MSQControllerTask msqControllerTask = (MSQControllerTask)taskPayloadResponse.getPayload();
        String queryUser = String.valueOf(msqControllerTask.getQuerySpec().getQuery().getContext().get("__user"));
        String currentUser = authenticationResult.getIdentity();
        if (currentUser != null && currentUser.equals(queryUser)) {
            return msqControllerTask;
        }
        Access access = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, forAction)), (AuthorizerMapper)this.authorizerMapper);
        if (access.isAllowed()) {
            return msqControllerTask;
        }
        throw new ForbiddenException(StringUtils.format((String)"The current user[%s] cannot view query id[%s] since the query is owned by another user", (Object[])new Object[]{currentUser, queryId}));
    }

    private SqlQuery createModifiedSqlQuery(SqlQuery sqlQuery) {
        Map context = sqlQuery.getContext();
        if (context.containsKey(RESULT_FORMAT)) {
            throw InvalidInput.exception((String)"Query context parameter [%s] is not allowed", (Object[])new Object[]{RESULT_FORMAT});
        }
        ImmutableMap modifiedContext = ImmutableMap.builder().putAll(context).put((Object)RESULT_FORMAT, (Object)sqlQuery.getResultFormat().toString()).build();
        return new SqlQuery(sqlQuery.getQuery(), sqlQuery.getResultFormat(), sqlQuery.includeHeader(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader(), (Map)modifiedContext, sqlQuery.getParameters());
    }

    private ResultFormat getPreferredResultFormat(String resultFormatParam, MSQSpec msqSpec) {
        if (resultFormatParam == null) {
            return (ResultFormat)QueryContexts.getAsEnum((String)RESULT_FORMAT, (Object)msqSpec.getQuery().context().get(RESULT_FORMAT), ResultFormat.class, (Enum)ResultFormat.DEFAULT_RESULT_FORMAT);
        }
        return (ResultFormat)QueryContexts.getAsEnum((String)"resultFormat", (Object)resultFormatParam, ResultFormat.class);
    }

    private Optional<Yielder<Object[]>> getResultYielder(String queryId, Long page, MSQControllerTask msqControllerTask, Closer closer) {
        Optional<Object> results;
        if (msqControllerTask.getQuerySpec().getDestination() instanceof TaskReportMSQDestination) {
            if (page != null && page > 0L) {
                throw InvalidInput.exception((String)"Page number [%d] is out of the range of results", (Object[])new Object[]{page});
            }
            MSQTaskReportPayload msqTaskReportPayload = SqlStatementResourceHelper.getPayload((TaskReport.ReportMap)this.contactOverlord(this.overlordClient.taskReportAsMap(queryId), queryId));
            results = msqTaskReportPayload.getResults().getResults() == null ? Optional.empty() : Optional.of(Yielders.each((Sequence)Sequences.simple(msqTaskReportPayload.getResults().getResults())));
        } else if (msqControllerTask.getQuerySpec().getDestination() instanceof DurableStorageMSQDestination) {
            MSQTaskReportPayload msqTaskReportPayload = SqlStatementResourceHelper.getPayload((TaskReport.ReportMap)this.contactOverlord(this.overlordClient.taskReportAsMap(queryId), queryId));
            List pages = SqlStatementResourceHelper.populatePageList(msqTaskReportPayload, msqControllerTask.getQuerySpec().getDestination()).orElse(null);
            if (pages == null || pages.isEmpty()) {
                return Optional.empty();
            }
            StageDefinition finalStage = Objects.requireNonNull(SqlStatementResourceHelper.getFinalStage(msqTaskReportPayload)).getStageDefinition();
            Long selectedPageId = page != null ? Long.valueOf(this.getPageInformationForPageId(pages, page).getId()) : null;
            this.checkForDurableStorageConnectorImpl();
            DurableStorageInputChannelFactory standardImplementation = DurableStorageInputChannelFactory.createStandardImplementation(msqControllerTask.getId(), this.storageConnector, closer, true);
            results = Optional.of(Yielders.each((Sequence)Sequences.concat((Iterable)pages.stream().filter(pageInformation -> selectedPageId == null || selectedPageId.equals(pageInformation.getId())).map(pageInformation -> {
                try {
                    if (pageInformation.getWorker() == null || pageInformation.getPartition() == null) {
                        throw DruidException.defensive((String)"Worker or partition number is null for page id [%d]", (Object[])new Object[]{pageInformation.getId()});
                    }
                    return new FrameChannelSequence(standardImplementation.openChannel(finalStage.getId(), pageInformation.getWorker(), pageInformation.getPartition()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList())).flatMap(frame -> SqlStatementResourceHelper.getResultSequence(frame, finalStage.getFrameReader(), msqControllerTask.getQuerySpec().getColumnMappings(), new ResultsContext(msqControllerTask.getSqlTypeNames(), msqControllerTask.getSqlResultsContext()), this.jsonMapper)).withBaggage((Closeable)closer)));
        } else {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build("MSQ select destination[%s] not supported. Please reach out to druid slack community for more help.", new Object[]{msqControllerTask.getQuerySpec().getDestination().toString()});
        }
        return results;
    }

    private PageInformation getPageInformationForPageId(List<PageInformation> pages, Long pageId) {
        for (PageInformation pageInfo : pages) {
            if (pageInfo.getId() != pageId.longValue()) continue;
            return pageInfo;
        }
        throw InvalidInput.exception((String)"Invalid page id [%d] passed.", (Object[])new Object[]{pageId});
    }

    private void resultPusher(String queryId, Optional<List<ColumnNameAndTypes>> signature, Closer closer, Optional<Yielder<Object[]>> results, CountingOutputStream os, ResultFormat resultFormat) throws IOException {
        try {
            try (ResultFormat.Writer writer = resultFormat.createFormatter((OutputStream)os, this.jsonMapper);){
                Yielder<Object[]> yielder = results.get();
                List<ColumnNameAndTypes> rowSignature = signature.get();
                SqlStatementResource.resultPusherInternal(writer, yielder, rowSignature);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to stream results back for query[%s]", new Object[]{queryId});
                throw new ISE((Throwable)e, "Unable to stream results back for query[%s]", new Object[]{queryId});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to stream results back for query[%s]", new Object[]{queryId});
            throw new ISE((Throwable)e, "Unable to stream results back for query[%s]", new Object[]{queryId});
        }
        finally {
            closer.close();
        }
    }

    @VisibleForTesting
    static void resultPusherInternal(ResultFormat.Writer writer, Yielder<Object[]> yielder, List<ColumnNameAndTypes> rowSignature) throws IOException {
        writer.writeResponseStart();
        while (!yielder.isDone()) {
            writer.writeRowStart();
            Object[] row = (Object[])yielder.get();
            for (int i = 0; i < Math.min(rowSignature.size(), row.length); ++i) {
                writer.writeRowField(rowSignature.get(i).getColName(), row[i]);
            }
            writer.writeRowEnd();
            yielder = yielder.next(null);
        }
        writer.writeResponseEnd();
        yielder.close();
    }

    private static void throwIfQueryIsNotSuccessful(String queryId, TaskStatusPlus statusPlus) {
        SqlStatementState sqlStatementState = SqlStatementResourceHelper.getSqlStatementState(statusPlus);
        if (sqlStatementState == SqlStatementState.RUNNING || sqlStatementState == SqlStatementState.ACCEPTED) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Query[%s] is currently in [%s] state. Please wait for it to complete.", new Object[]{queryId, sqlStatementState});
        }
        if (sqlStatementState == SqlStatementState.FAILED) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Query[%s] failed. Check the status api for more details.", new Object[]{queryId});
        }
    }

    private void contextChecks(QueryContext queryContext) {
        ExecutionMode executionMode = (ExecutionMode)queryContext.getEnum("executionMode", ExecutionMode.class, null);
        if (executionMode == null) {
            throw InvalidInput.exception((String)"Execution mode is not provided to the sql statement api. Please set [%s] to [%s] in the query context", (Object[])new Object[]{"executionMode", ExecutionMode.ASYNC});
        }
        if (!ExecutionMode.ASYNC.equals((Object)executionMode)) {
            throw InvalidInput.exception((String)"The sql statement api currently does not support the provided execution mode [%s]. Please set [%s] to [%s] in the query context", (Object[])new Object[]{executionMode, "executionMode", ExecutionMode.ASYNC});
        }
        MSQSelectDestination selectDestination = MultiStageQueryContext.getSelectDestination(queryContext);
        if (MSQSelectDestination.DURABLESTORAGE.equals((Object)selectDestination)) {
            this.checkForDurableStorageConnectorImpl();
        }
    }

    private void checkForDurableStorageConnectorImpl() {
        if (this.storageConnector instanceof NilStorageConnector) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(StringUtils.format((String)"The sql statement api cannot read from the select destination [%s] provided in the query context [%s] since it is not configured on the %s. It is recommended to configure durable storage as it allows the user to fetch large result sets. Please contact your cluster admin to configure durable storage.", (Object[])new Object[]{MSQSelectDestination.DURABLESTORAGE.getName(), "selectDestination", NodeRole.BROKER.getJsonName()}), new Object[0]);
        }
    }

    private <T> T contactOverlord(ListenableFuture<T> future, String queryId) {
        try {
            return (T)FutureUtils.getUnchecked(future, (boolean)true);
        }
        catch (RuntimeException e) {
            HttpResponseException httpResponseException;
            if (e.getCause() instanceof HttpResponseException && (httpResponseException = (HttpResponseException)e.getCause()).getResponse() != null && httpResponseException.getResponse().getResponse().getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
                log.info((Throwable)httpResponseException, "Query details not found for queryId [%s]", new Object[]{queryId});
                throw SqlStatementResource.queryNotFoundException(queryId);
            }
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build("Unable to contact overlord " + e.getMessage(), new Object[0]);
        }
    }

    private static DruidException queryNotFoundException(String queryId) {
        return NotFound.exception((String)"Query [%s] was not found. The query details are no longer present or might not be of the type [%s]. Verify that the id is correct.", (Object[])new Object[]{queryId, "query_controller"});
    }
}

