/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.report.MSQStagesReport;
import org.apache.druid.msq.sql.SqlStatementState;
import org.apache.druid.msq.sql.entity.ColumnNameAndTypes;
import org.apache.druid.msq.sql.entity.ResultSetInformation;
import org.joda.time.DateTime;

public class SqlStatementResult {
    private final String queryId;
    private final SqlStatementState state;
    private final DateTime createdAt;
    @Nullable
    private final List<ColumnNameAndTypes> sqlRowSignature;
    @Nullable
    private final Long durationMs;
    @Nullable
    private final ResultSetInformation resultSetInformation;
    @Nullable
    private final ErrorResponse errorResponse;
    @Nullable
    private final MSQStagesReport stages;
    @Nullable
    private final CounterSnapshotsTree counters;
    @Nullable
    private final List<MSQErrorReport> warnings;

    public SqlStatementResult(String queryId, SqlStatementState state, DateTime createdAt, List<ColumnNameAndTypes> sqlRowSignature, Long durationMs, ResultSetInformation resultSetInformation, ErrorResponse errorResponse) {
        this(queryId, state, createdAt, sqlRowSignature, durationMs, resultSetInformation, errorResponse, null, null, null);
    }

    @JsonCreator
    public SqlStatementResult(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="state") SqlStatementState state, @JsonProperty(value="createdAt") DateTime createdAt, @Nullable @JsonProperty(value="schema") List<ColumnNameAndTypes> sqlRowSignature, @Nullable @JsonProperty(value="durationMs") Long durationMs, @Nullable @JsonProperty(value="result") ResultSetInformation resultSetInformation, @Nullable @JsonProperty(value="errorDetails") ErrorResponse errorResponse, @Nullable @JsonProperty(value="stages") MSQStagesReport stages, @Nullable @JsonProperty(value="counters") CounterSnapshotsTree counters, @Nullable @JsonProperty(value="warnings") List<MSQErrorReport> warnings) {
        this.queryId = queryId;
        this.state = state;
        this.createdAt = createdAt;
        this.sqlRowSignature = sqlRowSignature;
        this.durationMs = durationMs;
        this.resultSetInformation = resultSetInformation;
        this.errorResponse = errorResponse;
        this.stages = stages;
        this.counters = counters;
        this.warnings = warnings;
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SqlStatementState getState() {
        return this.state;
    }

    @JsonProperty
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="schema")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ColumnNameAndTypes> getSqlRowSignature() {
        return this.sqlRowSignature;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getDurationMs() {
        return this.durationMs;
    }

    @JsonProperty(value="result")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ResultSetInformation getResultSetInformation() {
        return this.resultSetInformation;
    }

    @JsonProperty(value="errorDetails")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    @JsonProperty(value="stages")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MSQStagesReport getStages() {
        return this.stages;
    }

    @JsonProperty(value="counters")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CounterSnapshotsTree getCounters() {
        return this.counters;
    }

    @JsonProperty(value="warnings")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<MSQErrorReport> getWarnings() {
        return this.warnings;
    }

    public String toString() {
        return "SqlStatementResult{queryId='" + this.queryId + '\'' + ", state=" + (Object)((Object)this.state) + ", createdAt=" + this.createdAt + ", sqlRowSignature=" + this.sqlRowSignature + ", durationInMs=" + this.durationMs + ", resultSetInformation=" + this.resultSetInformation + ", errorResponse=" + (this.errorResponse == null ? "{}" : this.errorResponse.getAsMap().toString()) + ", stages=" + this.stages + ", counters=" + this.counters + ", warnings=" + this.warnings + '}';
    }
}

