/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.shuffle.output.ByteChunksInputStream;
import org.apache.druid.msq.shuffle.output.StageOutputReader;

public class ChannelStageOutputReader
implements StageOutputReader {
    private final ReadableFrameChannel channel;
    private final FrameFileWriter writer;
    private final Deque<byte[]> chunks = new ArrayDeque<byte[]>();
    @GuardedBy(value="this")
    private State state = State.INIT;
    @GuardedBy(value="this")
    private long cursor;
    @GuardedBy(value="this")
    private int positionWithinFirstChunk;
    @GuardedBy(value="this")
    private boolean didCloseWriter;

    public ChannelStageOutputReader(ReadableFrameChannel channel) {
        this.channel = channel;
        this.writer = FrameFileWriter.open((WritableByteChannel)new ChunkAcceptor(), null, (ByteTracker)ByteTracker.unboundedTracker());
    }

    @Override
    public synchronized ListenableFuture<InputStream> readRemotelyFrom(long offset) {
        if (this.state == State.INIT) {
            this.state = State.REMOTE;
        } else {
            if (this.state == State.LOCAL) {
                throw new ISE("Cannot read both remotely and locally", new Object[0]);
            }
            if (this.state == State.CLOSED) {
                throw new ISE("Closed", new Object[0]);
            }
        }
        if (offset < this.cursor) {
            return Futures.immediateFailedFuture((Throwable)new ISE("Offset[%,d] no longer available, current cursor is[%,d]", new Object[]{offset, this.cursor}));
        }
        while (this.chunks.isEmpty() || offset > this.cursor) {
            if (this.chunks.isEmpty()) {
                if (this.didCloseWriter) {
                    if (offset == this.cursor) {
                        return Futures.immediateFuture((Object)new ByteArrayInputStream(ByteArrays.EMPTY_ARRAY));
                    }
                    throw DruidException.defensive((String)"Channel finished but cursor[%,d] does not match requested offset[%,d]", (Object[])new Object[]{this.cursor, offset});
                }
                if (this.channel.isFinished()) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.didCloseWriter = true;
                    continue;
                }
                if (this.channel.canRead()) {
                    try {
                        this.writer.writeFrame(this.channel.read(), -1);
                    }
                    catch (Exception e) {
                        try {
                            this.writer.abort();
                        }
                        catch (IOException e2) {
                            e.addSuppressed(e2);
                        }
                        throw new RuntimeException(e);
                    }
                }
                return FutureUtils.transformAsync((ListenableFuture)this.channel.readabilityFuture(), ignored -> this.readRemotelyFrom(offset));
            }
            byte[] chunk = this.chunks.peek();
            long amountToAdvance = Math.min(offset - this.cursor, (long)(chunk.length - this.positionWithinFirstChunk));
            this.cursor += amountToAdvance;
            this.positionWithinFirstChunk += Ints.checkedCast((long)amountToAdvance);
            if (this.positionWithinFirstChunk != chunk.length) continue;
            this.chunks.poll();
            this.positionWithinFirstChunk = 0;
        }
        if (this.chunks.isEmpty() || offset != this.cursor) {
            throw DruidException.defensive((String)"Expected cursor[%,d] to be caught up to offset[%,d] by this point, and to have nonzero chunks", (Object[])new Object[]{this.cursor, offset});
        }
        return Futures.immediateFuture((Object)new ByteChunksInputStream((List<byte[]>)ImmutableList.copyOf(this.chunks), this.positionWithinFirstChunk));
    }

    @Override
    public synchronized ReadableFrameChannel readLocally() {
        if (this.state == State.INIT) {
            this.state = State.LOCAL;
            return this.channel;
        }
        if (this.state == State.REMOTE) {
            throw new ISE("Cannot read both remotely and locally", new Object[0]);
        }
        if (this.state == State.LOCAL) {
            throw new ISE("Cannot read channel multiple times", new Object[0]);
        }
        assert (this.state == State.CLOSED);
        throw new ISE("Closed", new Object[0]);
    }

    @Override
    public synchronized void close() {
        if (this.state != State.LOCAL) {
            this.state = State.CLOSED;
            this.channel.close();
        }
    }

    private class ChunkAcceptor
    implements WritableByteChannel {
        private boolean open = true;

        private ChunkAcceptor() {
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (!this.open) {
                throw new IOException("Closed");
            }
            int len = src.remaining();
            if (len > 0) {
                byte[] bytes = new byte[len];
                src.get(bytes);
                ChannelStageOutputReader.this.chunks.add(bytes);
            }
            return len;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() {
            this.open = false;
        }
    }

    static enum State {
        INIT,
        LOCAL,
        REMOTE,
        CLOSED;

    }
}

