/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.groupby.GroupByQueryKit;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.having.AlwaysHavingSpec;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class GroupByPostShuffleFrameProcessor
implements FrameProcessor<Object> {
    private final GroupByQuery query;
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final FrameWriterFactory frameWriterFactory;
    private final FrameReader frameReader;
    private final ColumnSelectorFactory columnSelectorFactoryForFrameWriter;
    private final Comparator<ResultRow> compareFn;
    private final BinaryOperator<ResultRow> mergeFn;
    private final Consumer<ResultRow> finalizeFn;
    @Nullable
    private final HavingSpec havingSpec;
    private final SettableLongVirtualColumn partitionBoostVirtualColumn;
    private Cursor frameCursor = null;
    private Supplier<ResultRow> rowSupplierFromFrameCursor;
    private ResultRow outputRow = null;
    private FrameWriter frameWriter = null;

    public GroupByPostShuffleFrameProcessor(GroupByQuery query, GroupingEngine groupingEngine, ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, FrameReader frameReader, ObjectMapper jsonMapper) {
        this.query = query;
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.frameWriterFactory = frameWriterFactory;
        this.compareFn = groupingEngine.createResultComparator((Query)query);
        this.mergeFn = groupingEngine.createMergeFn((Query)query);
        this.finalizeFn = GroupByPostShuffleFrameProcessor.makeFinalizeFn(query);
        this.havingSpec = GroupByPostShuffleFrameProcessor.cloneHavingSpec(query);
        this.partitionBoostVirtualColumn = new SettableLongVirtualColumn("__boost");
        this.columnSelectorFactoryForFrameWriter = GroupByPostShuffleFrameProcessor.makeVirtualColumnsForFrameWriter((VirtualColumn)this.partitionBoostVirtualColumn, jsonMapper, query).wrap(RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory((GroupByQuery)query, () -> this.outputRow, (RowSignature.Finalization)(GroupByQueryKit.isFinalize(query) ? RowSignature.Finalization.YES : RowSignature.Finalization.NO)));
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.frameCursor == null || this.frameCursor.isDone()) {
            if (readableInputs.isEmpty()) {
                return ReturnOrAwait.awaitAll((int)1);
            }
            if (this.inputChannel.isFinished()) {
                if (this.outputRow != null && this.writeOutputRow()) {
                    return ReturnOrAwait.runAgain();
                }
                this.writeCurrentFrameIfNeeded();
                return ReturnOrAwait.returnObject((Object)Unit.instance());
            }
            Frame frame = this.inputChannel.read();
            this.frameCursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)this.frameReader);
            ColumnSelectorFactory frameColumnSelectorFactory = this.frameCursor.getColumnSelectorFactory();
            Supplier[] fieldSuppliers = new Supplier[this.query.getResultRowSizeWithoutPostAggregators()];
            for (int i = 0; i < fieldSuppliers.length; ++i) {
                ColumnValueSelector selector = frameColumnSelectorFactory.makeColumnValueSelector(this.frameReader.signature().getColumnName(i));
                fieldSuppliers[i] = () -> ((ColumnValueSelector)selector).getObject();
            }
            int fullRowSize = this.query.getResultRowSignature().size();
            this.rowSupplierFromFrameCursor = () -> {
                int i;
                ResultRow row = ResultRow.create((int)fullRowSize);
                for (i = 0; i < fieldSuppliers.length; ++i) {
                    row.set(i, fieldSuppliers[i].get());
                }
                for (i = fieldSuppliers.length; i < fullRowSize; ++i) {
                    row.set(i, null);
                }
                return row;
            };
        }
        this.setUpFrameWriterIfNeeded();
        while (!this.frameCursor.isDone()) {
            ResultRow currentRow = this.rowSupplierFromFrameCursor.get();
            if (this.outputRow == null) {
                this.outputRow = currentRow.copy();
            } else if (this.compareFn.compare(this.outputRow, currentRow) == 0) {
                this.outputRow = (ResultRow)this.mergeFn.apply(this.outputRow, currentRow);
            } else {
                if (this.writeOutputRow()) {
                    return ReturnOrAwait.runAgain();
                }
                this.outputRow = currentRow.copy();
            }
            this.frameCursor.advance();
        }
        return ReturnOrAwait.runAgain();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{this.frameWriter});
    }

    private boolean writeOutputRow() throws IOException {
        int resultRowSize = this.query.getResultRowSignature().size();
        if (this.outputRow.length() < resultRowSize) {
            Object[] newArray = new Object[resultRowSize];
            System.arraycopy(this.outputRow.getArray(), 0, newArray, 0, this.outputRow.length());
            this.outputRow = ResultRow.of((Object[])newArray);
        }
        Map outputRowAsMap = this.outputRow.toMap(this.query);
        for (int i = 0; i < this.query.getPostAggregatorSpecs().size(); ++i) {
            PostAggregator postAggregator = (PostAggregator)this.query.getPostAggregatorSpecs().get(i);
            Object value = postAggregator.compute(outputRowAsMap);
            this.outputRow.set(this.query.getResultRowPostAggregatorStart() + i, value);
            outputRowAsMap.put(postAggregator.getName(), value);
        }
        if (this.havingSpec != null && !this.havingSpec.eval(this.outputRow)) {
            this.outputRow = null;
            return false;
        }
        this.finalizeFn.accept(this.outputRow);
        if (this.frameWriter.addSelection()) {
            this.incrementBoostColumn();
            this.outputRow = null;
            return false;
        }
        if (this.frameWriter.getNumRows() > 0) {
            this.writeCurrentFrameIfNeeded();
            this.setUpFrameWriterIfNeeded();
            if (this.frameWriter.addSelection()) {
                this.incrementBoostColumn();
                this.outputRow = null;
                return true;
            }
            throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
        }
        throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
    }

    private void writeCurrentFrameIfNeeded() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            this.outputChannel.write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
        }
    }

    private void setUpFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            this.frameWriter = this.frameWriterFactory.newFrameWriter(this.columnSelectorFactoryForFrameWriter);
        }
    }

    private static Consumer<ResultRow> makeFinalizeFn(GroupByQuery query) {
        if (GroupByQueryKit.isFinalize(query)) {
            int startIndex = query.getResultRowAggregatorStart();
            List aggregators = query.getAggregatorSpecs();
            return row -> {
                for (int i = 0; i < aggregators.size(); ++i) {
                    row.set(startIndex + i, ((AggregatorFactory)aggregators.get(i)).finalizeComputation(row.get(startIndex + i)));
                }
            };
        }
        return row -> {};
    }

    @Nullable
    private static HavingSpec cloneHavingSpec(GroupByQuery query) {
        if (query.getHavingSpec() == null || query.getHavingSpec() instanceof AlwaysHavingSpec) {
            return null;
        }
        if (query.getHavingSpec() instanceof DimFilterHavingSpec) {
            DimFilterHavingSpec dimFilterHavingSpec = (DimFilterHavingSpec)query.getHavingSpec();
            DimFilterHavingSpec clonedHavingSpec = new DimFilterHavingSpec(dimFilterHavingSpec.getDimFilter(), Boolean.valueOf(dimFilterHavingSpec.isFinalize()));
            clonedHavingSpec.setQuery(query);
            return clonedHavingSpec;
        }
        throw new UnsupportedOperationException("Must use 'filter' or 'always' havingSpec");
    }

    private static VirtualColumns makeVirtualColumnsForFrameWriter(@Nullable VirtualColumn partitionBoostVirtualColumn, ObjectMapper jsonMapper, GroupByQuery query) {
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        virtualColumns.add(partitionBoostVirtualColumn);
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, query);
        if (segmentGranularityVirtualColumn != null) {
            virtualColumns.add(segmentGranularityVirtualColumn);
        }
        return VirtualColumns.create(virtualColumns);
    }

    private void incrementBoostColumn() {
        this.partitionBoostVirtualColumn.setValue(this.partitionBoostVirtualColumn.getValue() + 1L);
    }
}

