/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.BaseFrameProcessorFactory;
import org.apache.druid.msq.querykit.WindowOperatorQueryFrameProcessor;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.segment.column.RowSignature;

@JsonTypeName(value="window")
public class WindowOperatorQueryFrameProcessorFactory
extends BaseFrameProcessorFactory {
    private final WindowOperatorQuery query;
    private final List<OperatorFactory> operatorList;
    private final RowSignature stageRowSignature;
    private final int maxRowsMaterializedInWindow;
    private final List<String> partitionColumnNames;

    @JsonCreator
    public WindowOperatorQueryFrameProcessorFactory(@JsonProperty(value="query") WindowOperatorQuery query, @JsonProperty(value="operatorList") List<OperatorFactory> operatorFactoryList, @JsonProperty(value="stageRowSignature") RowSignature stageRowSignature, @JsonProperty(value="maxRowsMaterializedInWindow") int maxRowsMaterializedInWindow, @JsonProperty(value="partitionColumnNames") List<String> partitionColumnNames) {
        this.query = (WindowOperatorQuery)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.operatorList = (List)Preconditions.checkNotNull(operatorFactoryList, (Object)"bad operator");
        this.stageRowSignature = (RowSignature)Preconditions.checkNotNull((Object)stageRowSignature, (Object)"stageSignature");
        this.maxRowsMaterializedInWindow = maxRowsMaterializedInWindow;
        if (partitionColumnNames == null) {
            throw DruidException.defensive((String)"List of partition column names encountered as null.", (Object[])new Object[0]);
        }
        this.partitionColumnNames = partitionColumnNames;
    }

    @JsonProperty(value="query")
    public WindowOperatorQuery getQuery() {
        return this.query;
    }

    @JsonProperty(value="operatorList")
    public List<OperatorFactory> getOperators() {
        return this.operatorList;
    }

    @JsonProperty(value="partitionColumnNames")
    public List<String> getPartitionColumnNames() {
        return this.partitionColumnNames;
    }

    @JsonProperty(value="stageRowSignature")
    public RowSignature getSignature() {
        return this.stageRowSignature;
    }

    @JsonProperty(value="maxRowsMaterializedInWindow")
    public int getMaxRowsMaterializedInWindow() {
        return this.maxRowsMaterializedInWindow;
    }

    @Override
    public ProcessorsAndChannels<Object, Long> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher, boolean removeNullBytes) {
        StageInputSlice slice = (StageInputSlice)Iterables.getOnlyElement(inputSlices);
        Int2ObjectAVLTreeMap outputChannels = new Int2ObjectAVLTreeMap();
        for (ReadablePartition partition : slice.getPartitions()) {
            outputChannels.computeIfAbsent(partition.getPartitionNumber(), i -> {
                try {
                    return outputChannelFactory.openChannel(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Sequence readableInputs = Sequences.simple((Iterable)inputSliceReader.attach(0, slice, counters, warningPublisher));
        Sequence processors = readableInputs.map(arg_0 -> this.lambda$makeProcessors$1((Int2ObjectSortedMap)outputChannels, stageDefinition, removeNullBytes, frameContext, arg_0));
        return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.of((Sequence)processors), OutputChannels.wrapReadOnly((List)ImmutableList.copyOf((Collection)outputChannels.values())));
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowOperatorQueryFrameProcessorFactory that = (WindowOperatorQueryFrameProcessorFactory)o;
        return this.maxRowsMaterializedInWindow == that.maxRowsMaterializedInWindow && Objects.equals(this.query, that.query) && Objects.equals(this.operatorList, that.operatorList) && Objects.equals(this.partitionColumnNames, that.partitionColumnNames) && Objects.equals(this.stageRowSignature, that.stageRowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.operatorList, this.partitionColumnNames, this.stageRowSignature, this.maxRowsMaterializedInWindow);
    }

    private /* synthetic */ FrameProcessor lambda$makeProcessors$1(Int2ObjectSortedMap outputChannels, StageDefinition stageDefinition, boolean removeNullBytes, FrameContext frameContext, ReadableInput readableInput) {
        OutputChannel outputChannel = (OutputChannel)outputChannels.get(readableInput.getStagePartition().getPartitionNumber());
        return new WindowOperatorQueryFrameProcessor(this.query, readableInput.getChannel(), outputChannel.getWritableChannel(), stageDefinition.createFrameWriterFactory(outputChannel.getFrameMemoryAllocator(), removeNullBytes), readableInput.getChannelFrameReader(), frameContext.jsonMapper(), this.operatorList, this.stageRowSignature, this.maxRowsMaterializedInWindow, this.partitionColumnNames);
    }
}

