/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.stage.ReadablePartitions;

@JsonTypeName(value="stage")
public class StageInputSlice
implements InputSlice {
    private final int stage;
    private final ReadablePartitions partitions;
    @Nullable
    private final OutputChannelMode outputChannelMode;

    @JsonCreator
    public StageInputSlice(@JsonProperty(value="stage") int stageNumber, @JsonProperty(value="partitions") ReadablePartitions partitions, @JsonProperty(value="output") OutputChannelMode outputChannelMode) {
        this.stage = stageNumber;
        this.partitions = (ReadablePartitions)Preconditions.checkNotNull((Object)partitions, (Object)"partitions");
        this.outputChannelMode = outputChannelMode;
    }

    @JsonProperty(value="stage")
    public int getStageNumber() {
        return this.stage;
    }

    @JsonProperty(value="partitions")
    public ReadablePartitions getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="output")
    @Nullable
    public OutputChannelMode getOutputChannelMode() {
        return this.outputChannelMode;
    }

    @Override
    public int fileCount() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageInputSlice that = (StageInputSlice)o;
        return this.stage == that.stage && Objects.equals(this.partitions, that.partitions) && this.outputChannelMode == that.outputChannelMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stage, this.partitions, this.outputChannelMode});
    }

    public String toString() {
        return "StageInputSlice{stage=" + this.stage + ", partitions=" + this.partitions + ", outputChannelMode=" + (Object)((Object)this.outputChannelMode) + '}';
    }
}

