/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.WarningCounters;
import org.apache.druid.msq.input.external.ExternalInputSliceReader;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;

public class ExternalSegment
extends RowBasedSegment<InputRow> {
    private final InputSource inputSource;
    private final RowSignature signature;
    public static final String SEGMENT_ID = "__external";

    public ExternalSegment(final InputSource inputSource, final InputSourceReader reader, final InputStats inputStats, final WarningCounters warningCounters, final Consumer<Throwable> warningPublisher, final ChannelCounters channelCounters, RowSignature signature) {
        super(SegmentId.dummy((String)SEGMENT_ID), (Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<InputRow, CloseableIterator<InputRow>>(){

            public CloseableIterator<InputRow> make() {
                try {
                    final CloseableIterator baseIterator = reader.read(inputStats);
                    return new CloseableIterator<InputRow>(){
                        private InputRow next = null;

                        public void close() throws IOException {
                            baseIterator.close();
                        }

                        public boolean hasNext() {
                            while (true) {
                                try {
                                    while (this.next == null && baseIterator.hasNext()) {
                                        this.next = (InputRow)baseIterator.next();
                                    }
                                }
                                catch (ParseException e) {
                                    warningCounters.incrementWarningCount("CannotParseExternalData");
                                    warningPublisher.accept(e);
                                    continue;
                                }
                                break;
                            }
                            return this.next != null;
                        }

                        public InputRow next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            InputRow row = this.next;
                            this.next = null;
                            return row;
                        }
                    };
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void cleanup(CloseableIterator<InputRow> iterFromMake) {
                try {
                    iterFromMake.close();
                    if (ExternalInputSliceReader.isFileBasedInputSource(inputSource)) {
                        channelCounters.incrementFileCount();
                        channelCounters.incrementBytes(inputStats.getProcessedBytes());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }), reader.rowAdapter(), signature);
        this.inputSource = inputSource;
        this.signature = signature;
    }

    public InputSource externalInputSource() {
        return this.inputSource;
    }

    public RowSignature signature() {
        return this.signature;
    }
}

